@extends('BackOfficeAR.dashboardAR')
@section('content')
<style>
    .btn-success-custom {
    background-color: green; /* Set your desired green color */
    color: white; /* Ensure text is readable */
}

.btn-success-custom i {
    color: white; /* Set the icon color to match the button text */
}

.btn-orange {
    background-color: orange; /* Set your desired orange color */
    color: white; /* Ensure text is readable */
}

.btn-orange i {
    color: white; /* Set the icon color to match the button text */
}

</style>
    <div class="container-fluid dashboard-inner-body-container">
        <div class="row">
            <div class="col-lg-12">
                <div class="block-card dashboard-card mb-4 px-0">
                    <div
                        class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between align-items-center">
                        <h2 class="widget-title pb-0 ">قائمة أقسام الصفحة : {{ $page->titre_P }}</h2>
                        <a class="btn btn-success font-weight-medium"
                            href="{{ route('ajoutesectionform', ['id' => $page->id_P]) }}"><i class="la la-plus mr-1"> إضافة
                                قسم </i></a>
                    </div>
                    <div class="block-card-body">
                        <div class="my-table table-responsive">
                            <table class="table align-items-center table-flush mb-0">
                                <thead class="thead-light">
                                    <tr>

                                        <th>العنوان</th>
                                        <th>الترتيب</th>

                                        <th>محتوى القسم</th>
                                        <th> </th>

                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($page->sections as $section)
                                        <tr>

                                            <td>{{ $section->titre_S }}</td>
                                            <td>{{ $section->ordre_S }}</td>

                                            <td>{!! $section->contenue_S !!}</td>
                                            @if (auth()->user()->hasAnyRole(['super-admin', 'editeur']))
                                                <td class="btn-group">
                                                    <a class="btn btn-orange btn-sm mr-2" 
                                                        onclick="return confirmAction('هل تريد حقًا تعديل هذا القسم؟', '{{ route('sections.edit', ['id' => $section->id_S]) }}')"
                                                        href="#">
                                                        <i class="la la-edit mr-1"> تعديل</i>
                                                    </a>
                                                
                                                    <form action="{{ route('section.destroy', ['id' => $section->id_S]) }}"
                                                        method="POST" style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button
                                                            onclick="return confirmAction('هل تريد حقًا حذف هذا القسم؟', null, this.closest('form'))"
                                                            type="button" class="btn bg-rgb-primary1 font-weight-medium mr-2">
                                                            <i class="la la-trash mr-1"> حذف</i>
                                                        </button>
                                                    </form>
                                                
                                            @endif

                                            
                                                <a class="btn bg-primary text-white btn-sm"
                                                    href="{{ route('listesinfosuppsS', ['id' => $section->id_S]) }}"><i
                                                        class="la la-plus-square mr-1"> الملاحق</i></a>

                                            </td>


                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-start">

                                <a class="btn bg-rgb-primary1 font-weight-medium ml-auto"
                                    href="{{ route('guides.listepages', ['id' => $page->guide->id_G]) }}"><i
                                        class="la la-arrow-left mr-1"></i></a>
                            </div>
                        </div>
                    </div><!-- end block-card-body -->

                </div><!-- end block-card -->



            </div><!-- end col-lg-6 -->
        </div><!-- end row -->
    </div><!-- end dashboard-inner-body-container -->
    <div id="back-to-top">
        <i class="la la-arrow-up" title="Go top"></i>
    </div>
@endsection
