@extends('BackOfficeAR.dashboardAR')
@section('content')
<style>
    .btn-success-custom {
    background-color: green; /* Set your desired green color */
    color: white; /* Ensure text is readable */
}

.btn-success-custom i {
    color: white; /* Set the icon color to match the button text */
}

.btn-orange {
    background-color: orange; /* Set your desired orange color */
    color: white; /* Ensure text is readable */
}

.btn-orange i {
    color: white; /* Set the icon color to match the button text */
}

</style>
    <div class="container-fluid dashboard-inner-body-container">
        <div class="row">
            <div class="col-lg-12">
                <div class="block-card dashboard-card mb-4 px-0">
                    <div
                        class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between align-items-center">
                        <h2 class="widget-title pb-0">قائمة صفحات : {{ $guide->titre_G }}</h2>
                        <a class="btn btn-success font-weight-medium"
                            href="{{ url('/ajoutpageforme', ['id' => $guide->id_G]) }}"><i class="la la-plus mr-1"> إضافة صفحة
                            </i></a>
                    </div>
                    <div class="block-card-body">
                        <div class="my-table table-responsive">
                            <table class="table align-items-center table-flush mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th width="20%">العنوان</th>
                                        <th width="20%">الترتيب</th>

                                        <th width="20%">الصورة</th>
                                        <th width="20%"> </th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($guide->pages as $page)
                                        <tr>
                                            <td>{{ $page->titre_P }}</td>
                                            <td>{{ $page->ordre_P }}</td>

                                            <td>
                                                @if ($page->image_titre)
                                                    <div class="existing-images mt-2">
                                                        <a href="{{ asset('idmej/uploads/' . $page->image_titre) }}"
                                                            target="_blank" class="btn btn-link text-danger">اضغط هنا</a>
                                                    </div>
                                                @endif
                                            </td>
                                            @if (auth()->user()->hasAnyRole(['super-admin', 'editeur']))
                                                <td class="btn-group">
                                                    <a class="btn btn-orange btn-sm mr-2"
                                                        onclick="return confirmAction('هل تريد حقًا تعديل هذه الصفحة؟', '{{ route('pages.edit', ['id' => $page->id_P]) }}')"
                                                        href="#">
                                                        <i class="la la-edit mr-1"> تعديل</i>
                                                    </a>
                                                
                                                    <form action="{{ route('page.destroy', ['id' => $page->id_P]) }}"
                                                        method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button
                                                            onclick="return confirmAction('هل تريد حقًا حذف هذه الصفحة؟', null, this.closest('form'))"
                                                            type="button" class="btn bg-rgb-primary1 font-weight-medium mr-2">
                                                            <i class="la la-trash mr-1"> حذف</i>
                                                        </button>
                                                    </form>
                                              
                                            @endif

                                           
                                                <a class="btn bg-primary text-white btn-sm"
                                                    href="{{ route('pages.listesections', ['id' => $page->id_P]) }}"><i
                                                        class="la la-list mr-1"> الاقسام</i></a>
                                            </td>

                                            
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-start">
                            <a class="btn bg-rgb-primary1 font-weight-medium ml-auto"
                                href="{{ route('guides.index', ['tp' => $guide->id_type]) }}"><i
                                    class="la la-arrow-left mr-1"></i></a>
                        </div>
                    </div><!-- end block-card-body -->
                </div><!-- end block-card -->
            </div><!-- end col-lg-6 -->
        </div><!-- end row -->
    </div><!-- end dashboard-inner-body-container -->
    <div id="back-to-top">
        <i class="la la-arrow-up" title="Go top"></i>
    </div>
@endsection
