@extends('BackOfficeAR.dashboardAR')
@section('content')
<style>
    .btn-success-custom {
    background-color: green; /* Set your desired green color */
    color: white; /* Ensure text is readable */
}

.btn-success-custom i {
    color: white; /* Set the icon color to match the button text */
}

.btn-orange {
    background-color: orange; /* Set your desired orange color */
    color: white; /* Ensure text is readable */
}

.btn-orange i {
    color: white; /* Set the icon color to match the button text */
}

</style>
    <div class="container-fluid dashboard-inner-body-container">
        <div class="row">
            <div class="col-lg-12">
                <div class="block-card dashboard-card mb-4 px-0">
                    <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                        <h2 class="widget-title pb-0">
                            @if ($nbtype == 1)
                                ملاحق الصفحة : {{ $ob->titre_P }}
                            @elseif($nbtype == 2)
                                ملاحق القسم : {{ $ob->titre_S }}
                            @endif
                        </h2>
                        <a  class="btn btn-success font-weight-medium"
                            href="{{ url('/ajoutinfosuppform', ['id' => $id_ob, 'nbtype' => $nbtype]) }}"> <i
                                class="la la-plus mr-1">إضافة ملحق</i></a>
                    </div>
                    <div class="block-card-body">
                        <div class="my-table table-responsive">
                            <table class="table align-items-center table-flush mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>الترتيب</th>

                                        <th>الرابط</th>
                                        <th>الصورة</th>
                                        @if ($nbtype == 2)
                                            <th>الملف </th>
                                        @endif
                                        <th> </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($ob->info_supps ?? [] as $infoSupp)
                                        <tr>
                                            <td>{{ $infoSupp->ordre_I }}</td>

                                            <td>{{ $infoSupp->link }}</td>

                                            <td>
                                                @if ($infoSupp->image)
                                                    <div class="existing-images mt-2">
                                                        <a href="{{ asset('uploads/' . $infoSupp->image) }}" target="_blank"
                                                            class="btn btn-link text-danger">اضغط هنا</a>
                                                    </div>
                                                @endif
                                            </td>
                                            @if ($nbtype == 2)
                                                <td>
                                                    @if ($infoSupp->pdf)
                                                        <div class="existing-images mt-2">
                                                            <a href="{{ asset('uploads/' . $infoSupp->pdf) }}"
                                                                target="_blank" class="btn btn-link text-danger">اضغط
                                                                هنا</a>
                                                        </div>
                                                    @endif
                                                </td>
                                            @endif
                                            @if (auth()->user()->hasAnyRole(['super-admin', 'editeur']))
                                                <td class="btn-group">
                                                    <a class="btn btn-orange btn-sm mr-2" 
                                                        onclick="return confirmAction('هل تريد حقًا تعديل هذا الملحق؟', '{{ route('infosupp.edit', ['id' => $infoSupp->id_I, 'nbtype' => $nbtype]) }}')"
                                                        href="#">
                                                        <i class="la la-edit mr-1"> تعديل</i>
                                                    </a>
                                                
                                                    <form
                                                        action="{{ route('infosupp.destroy', ['id' => $infoSupp->id_I, 'nbtype' => $nbtype]) }}"
                                                        method="POST" style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button
                                                            onclick="return confirmAction('هل تريد حقًا حذف هذا الملحق؟', null, this.closest('form'))"
                                                            type="button"  class="btn bg-rgb-primary1 font-weight-medium mr-2">
                                                            <i class="la la-trash mr-1"> حذف</i>
                                                        </button>
                                                    </form>
                                                </td>
                                            @endif

                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-start">
                                @if ($nbtype == 1)
                                    <a href="{{ route('guides.listepages', ['id' => $ob->id_G]) }}"
                                        class="btn bg-rgb-primary1 font-weight-medium ml-auto"><i
                                            class="la la-arrow-left mr-1"></i></a>
                                @elseif($nbtype == 2)
                                    <a href="{{ route('pages.listesections', ['id' => $ob->id_P]) }}"
                                        class="btn bg-rgb-primary1 font-weight-medium ml-auto"><i
                                            class="la la-arrow-left mr-1"></i></a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- end table -->
    <div id="back-to-top">
        <i class="la la-arrow-up" title="Go top"></i>
    </div>
@endsection
