@extends('BackOfficeAR.dashboardAR')
@section('content')
<style>
    .btn-success-custom {
    background-color: green; /* Set your desired green color */
    color: white; /* Ensure text is readable */
}

.btn-success-custom i {
    color: white; /* Set the icon color to match the button text */
}

.btn-orange {
    background-color: orange; /* Set your desired orange color */
    color: white; /* Ensure text is readable */
}

.btn-orange i {
    color: white; /* Set the icon color to match the button text */
}

</style>

    <div class="container-fluid dashboard-inner-body-container">
        <div class="row">
            <div class="col-lg-12">
                <div class="block-card dashboard-card mb-4 px-0">
                    <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">

                        @foreach ($types_G as $type_G)
                            @if ($type_G->id_type == $tp)
                                <h2 class="widget-title pb-0">{{ $type_G->titre }}</h2>
                                <a class="btn btn-success font-weight-medium"
                                    href="{{ route('ajouteguideform', ['tp' => $tp]) }}">
                                    <i class="la la-plus mr-1"> إضافة </i>
                                </a>
                            @break
                        @endif
                    @endforeach


                </div>
                <!-- Filter Form -->
                <div class="block-card-header px-4 border-bottom-0 pb-0">
                    <form method="GET" action="{{ route('guides.index1') }}">
                        <div class="form-row">
                            <div class="col">
                                <select name="language_id" class="form-control">
                                    <option value="">اختر اللغة</option>
                                    @foreach (\App\Models\Language::all() as $language)
                                        <option value="{{ $language->id_L }}">{{ $language->nom_L }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col">
                                <input type="text" name="title" class="form-control" placeholder="اسم الدليل">
                            </div>
                            <div class="col">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">تصفية</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- End Filter Form -->
                <div class="block-card-body">
                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>العنوان</th>
                                    <th>اللغة</th>
                                    <th>الترتيب</th>

                                    <th></th>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($guides as $guide)
                                    <tr>
                                        <td>{{ $guide->titre_G }}</td>
                                        <td>{{ $guide->language->nom_L }}</td>
                                        <td>{{ $guide->order }}</td>

                                        @if (auth()->user()->hasAnyRole(['super-admin', 'editeur']))
                                            <td class="btn-group">
                                                <a class="btn btn-orange btn-sm mr-2"
                                                    onclick="return confirmAction('هل تريد حقًا تعديل هذا الدليل؟', '{{ route('guides.edit', ['id' => $guide->id_G]) }}' , null)">
                                                    <i class="la la-edit mr-1"> تعديل</i>
                                                </a>
                                           
                                                <form action="{{ route('guide.delete', ['id' => $guide->id_G]) }}"
                                                    method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button
                                                        onclick="return confirmAction('هل تريد حقًا حذف هذا الدليل؟', null, this.closest('form'))"
                                                        type="button" class="btn bg-rgb-primary1 font-weight-medium mr-2">
                                                        <i class="la la-trash mr-1"> حذف</i>
                                                    </button>
                                                </form>
                                            
                                        @endif

                                        
                                        <a class="btn bg-primary text-white btn-sm" href="{{ route('guides.listepages', ['id' => $guide->id_G]) }}">
                                            <i class="la la-file-text mr-1"> الصفحات</i>
                                        </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><!-- end table -->
<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>
@endsection
