@extends('BackOfficeAR.dashboardAR')
@section('content') 
<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>

<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                
                
                <form action="{{ route('sections.update', ['id' => $section->id_S]) }}" method="POST" onsubmit="return validateRecaptcha()">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="page_id" value="{{ $section->page->id_P }}">
                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">تعديل القسم : {{$section->titre_S}}</h2>
                            <div class="stroke-shape"></div>
                        </div><!-- end block-card-header -->
                        <div class="block-card-body">
   
                            <div class="col-lg-10">
                                <div class="input-box">
                                <label for="titre_S" class="label-text">عنوان القسم</label>
                                    <div class="form-group">
                                        <input type="text" class="form-control pl-3 @error('titre_S') is-invalid @enderror"  id="titre_S" name="titre_S" placeholder="العنوان"  value="{{ $section->titre_S }}" required autofocus>
                                        @error('titre_S')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                            </div><!-- end titre guide -->

                            <div class="col-lg-10">
                                <div class="input-box">
                                    <label for="ordre_S" class="label-text">الترتيب</label>
                                    <input id="ordre_S" type="number" class="form-control @error('ordre_S') is-invalid @enderror" name="ordre_S" value="{{ $section->ordre_S }}"  required>
                                    @error('ordre_S')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div><!-- end ordre -->
                            <div class="col-lg-10">
                                <div class="input-box">
                                    <label for="contenue_S" class="label-text">المحتوى</label>
                                    <div class="linha">
                                        <br>
                                        <div class="col">
                                            <textarea id="contenue_S" name="contenue_S" placeholder="..." required>{{ $section->contenue_S }}</textarea>
                                            @error('contenue_S')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <script>
                                        CKEDITOR.replace('contenue_S');
                                    </script>
                                </div>
                            </div>
                            


                        </div><!-- end guide -->
                        <br>
<div class="form-group row">            
            <div class="form-group mt-3">
                  <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                  <span id="recaptcha-error" class="invalid-feedback" style="display: block;"></span>
                </div>
            </div>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
    function validateRecaptcha() {
        const response = grecaptcha.getResponse();
        const errorMessageElement = document.getElementById('recaptcha-error');

        // Clear existing error message
        if (errorMessageElement) {
            errorMessageElement.innerText = '';
        }

        if (!response) {
            // Display the error message
            if (errorMessageElement) {
                errorMessageElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
            } else {
                // If the error message element doesn't exist, create it
                const recaptchaContainer = document.querySelector('.g-recaptcha');
                const errorElement = document.createElement('span');
                errorElement.id = 'recaptcha-error';
                errorElement.className = 'invalid-feedback';
                errorElement.style.display = 'block';
                errorElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
                recaptchaContainer.parentNode.appendChild(errorElement);
            }
            return false;
        }
        return true;
    }
</script>

                        <button type="submit" class="btn btn-success font-weight-medium"> <i class="la la-save mr-1">حفظ</i></button>
                        <button onclick="history.back()" class="btn bg-rgb-primary1 font-weight-medium"><i class="la la-times mr-1">الغاء</i></button>

                        <a class="btn bg-primary text-white btn-sm mr-2" href="{{ route('listesinfosuppsS', ['id' => $section->id_S]) }}"><i class="la la-plus-square mr-1">الملاحق</i></a>

                    </div><!-- end  -->
   
                    
                </form>
   
            </div>
        </div>
    </div>
</section>



@endsection