@extends('BackOfficeAR.dashboardAR')
@section('content') 
<<script>
    function previewImage(event) {
        const preview = document.getElementById('preview');
        const file = event.target.files[0];
        const reader = new FileReader();

        reader.onload = function() {
            preview.src = reader.result;
            preview.style.display = 'block';
        }

        if (file) {
            reader.readAsDataURL(file);
        }
    }
</script>

<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">  
                <form action="{{ route('pages.update', ['id' => $page->id_P]) }}" method="POST" enctype="multipart/form-data" onsubmit="return validateRecaptcha()">
                    @csrf
                    @method('PUT')

                    <input type="hidden" name="guide_id" value="{{ $page->guide->id_G }}">
                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">تعديل الصفحة : {{ $page->titre_P }}</h2>
                            <div class="stroke-shape"></div>
                        </div><!-- end block-card-header -->
                        <div class="block-card-body">
                            <div class="col-lg-10">
                                <div class="input-box">
                                <label for="titre_P" class="form-label">العنوان</label>
                                    <div class="form-group">
                                        <input type="text" class="form-control pl-3 @error('titre_P') is-invalid @enderror"  id="titre_P" name="titre_P" placeholder="العنوان"  value="{{ $page->titre_P }}" required autofocus>
                                        @error('titre')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                            </div><!-- end titre guide -->
                            <div class="col-lg-10">
                                <div class="input-box">
                                    <label for="ordre_P">الترتيب</label>
                                    <input id="ordre_P" type="number" class="form-control @error('ordre_P') is-invalid @enderror" name="ordre_P" value="{{ $page->ordre_P }}"  required>
                                    @error('ordre')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div><!-- end ordre -->
                            <div class="block-card-body">
                             <label class="label-text">تغيير الصورة</label>
                                <div class="file-upload-wrap">
                                     <input type="file" id="image_titre" name="image_titre" class="file-upload-input" onchange="previewImage(event)">

                                    <span class="file-upload-text"><i class="la la-upload mr-2"></i>اسحب الصورة هنا أو انقر لتحميل</span>   

                                    <!-- Affichage de l'ancienne image si elle existe -->
                                    @if($page->image_titre)
                                        <div class="existing-images mt-2">
                                            <img src="{{ asset('uploads/' . $page->image_titre) }}" alt="Existing Image" class="img-thumbnail" width="150">
                                        </div>
                                    @endif

                                    <div id="image-preview" class="mt-2">
                                        <img id="preview" src="" alt="image Preview" class="img-thumbnail" width="150" style="display: none;">
                                    </div>
                                </div>
                            </div><!-- end gallery images -->

                        </div><!-- end guide -->
                    
                        <br>
<div class="form-group row">            
            <div class="form-group mt-3">
                  <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                  <span id="recaptcha-error" class="invalid-feedback" style="display: block;"></span>
                </div>
            </div>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
    function validateRecaptcha() {
        const response = grecaptcha.getResponse();
        const errorMessageElement = document.getElementById('recaptcha-error');

        // Clear existing error message
        if (errorMessageElement) {
            errorMessageElement.innerText = '';
        }

        if (!response) {
            // Display the error message
            if (errorMessageElement) {
                errorMessageElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
            } else {
                // If the error message element doesn't exist, create it
                const recaptchaContainer = document.querySelector('.g-recaptcha');
                const errorElement = document.createElement('span');
                errorElement.id = 'recaptcha-error';
                errorElement.className = 'invalid-feedback';
                errorElement.style.display = 'block';
                errorElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
                recaptchaContainer.parentNode.appendChild(errorElement);
            }
            return false;
        }
        return true;
    }
</script>

                        <button type="submit" class="btn btn-success font-weight-medium"> <i class="la la-save mr-1">حفظ</i></button>
                        <a href="{{ route('guides.listepages', ['id' => $page->id_G]) }}"
                            class="btn bg-rgb-primary1 font-weight-medium"><i class="la la-times mr-1">الغاء</i></a>
                        <a class="btn bg-primary text-white btn-sm mr-2" href="{{ route('pages.listesections', ['id' => $page->id_P]) }}"><i class="la la-list-alt mr-1">الأقسام</i></a>
                        <a class="btn bg-primary text-white btn-sm mr-2" href="{{ route('listesinfosuppsP', ['id' => $page->id_P]) }}"><i class="la la-plus-square mr-1">الملاحق</i></a>
                    </div><!-- end  -->
                </form>     
            </div>
        </div>
    </div>
</section>




@endsection