@extends('BackOfficeAR.dashboardAR')
@section('content')
    
    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    

                    <form method="POST" action="{{ route('infosupps.update', ['id' => $infosupp->id_I]) }}" enctype="multipart/form-data" onsubmit="return validateRecaptcha()">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="id_ob" value="{{ $infosupp->id_G ?? $infosupp->id_P ?? $infosupp->id_S }}">
                        <input type="hidden" name="nbtype" value="{{ $nbtype }}">

                        <div class="block-card mb-4">
                            <div class="block-card-header">
                                <h2 class="widget-title">تعديل معلومات إضافية </h2>
                                <div class="stroke-shape"></div>
                            </div>

                            <div class="col-lg-10">
                                <div class="input-box">
                                    <label class="label-text" for="link">الرابط</label>
                                    <div class="form-group">
                                        <input id="link" type="text" placeholder="الرابط"
                                            class="form-control pl-3 @error('link') is-invalid @enderror" name="link"
                                            value="{{ old('link', $infosupp->link) }}" autofocus>
                                        @error('link')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div><!-- end link -->

                            <div class="col-lg-10">
                                <div class="input-box">
                                    <label for="ordre_I" class="label-text">الترتيب</label>
                                    <input id="ordre_I" type="number"
                                        class="form-control @error('ordre') is-invalid @enderror" name="ordre_I"
                                        value="{{ old('ordre_I', $infosupp->ordre_I) }}" required>
                                    @error('ordre_I')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div><!-- end ordre -->

                            <div class="block-card-body">
                                <label class="label-text">تغيير الصورة</label>
                                <div class="file-upload-wrap">
                                    <input type="file" for="images" name="images[]"
                                        class="multi file-upload-input with-preview" multiple>
                                    <span class="file-upload-text"><i class="la la-upload mr-2"></i>اسحب الملف هنا أو انقر لتحميل</span>
                                    <!-- Display existing images if any -->
                                    @if($infosupp->image)
                                        <div class="existing-images mt-2">
                                            <img src="{{ asset('uploads/' . $infosupp->image) }}" alt="Existing Image" class="img-thumbnail" width="150">
                                        </div>
                                    @endif
                                </div>
                            </div><!-- end gallery images -->
                            @if($nbtype == 2 )
                            <div class="block-card-body">
                                <label class="label-text">تحميل ملف</label>
                                <div class="file-upload-wrap file-upload-wrap-2">
                                    <input type="file" name="pdf" class="multi file-upload-input with-preview" >
                                    <span class="file-upload-text"><i class="la la-photo mr-2"></i>اختر ملفًا</span>
                                    @if($infosupp->pdf)
                                        <div>الملف الحالي: <a href="{{ asset('uploads/' . $infosupp->pdf) }}" target="_blank">{{ $infosupp->pdf }}</a></div>
                                    @endif
                                </div>
                            </div>
                            @endif

                        
                            <br>
                        <div class="form-group row">            
            <div class="form-group mt-3">
                  <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                  <span id="recaptcha-error" class="invalid-feedback" style="display: block;"></span>
                </div>
            </div>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
    function validateRecaptcha() {
        const response = grecaptcha.getResponse();
        const errorMessageElement = document.getElementById('recaptcha-error');

        // Clear existing error message
        if (errorMessageElement) {
            errorMessageElement.innerText = '';
        }

        if (!response) {
            // Display the error message
            if (errorMessageElement) {
                errorMessageElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
            } else {
                // If the error message element doesn't exist, create it
                const recaptchaContainer = document.querySelector('.g-recaptcha');
                const errorElement = document.createElement('span');
                errorElement.id = 'recaptcha-error';
                errorElement.className = 'invalid-feedback';
                errorElement.style.display = 'block';
                errorElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
                recaptchaContainer.parentNode.appendChild(errorElement);
            }
            return false;
        }
        return true;
    }
</script>
                            <button type="submit" class="btn btn-success font-weight-medium"> <i class="la la-save mr-1">حفظ</i></button>

                            @if ($nbtype == 1)
                                
                                <a href="{{ route('listesinfosuppsP', ['id' => $infosupp->page->id_P]) }}"
                                    class="btn bg-rgb-primary1 font-weight-medium"><i class="la la-times mr-1">الغاء</i></a>
                            @elseif($nbtype == 2)
                                <a href="{{ route('listesinfosuppsS', ['id' => $infosupp->section->id_S]) }}"
                                    class="btn bg-rgb-primary1 font-weight-medium"><i class="la la-times mr-1">الغاء</i></a>
                            @endif

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <div id="back-to-top">
        <i class="la la-arrow-up" title="Go top"></i>
    </div>
@endsection
