@extends('BackOfficeAR.dashboardAR')
@section('content') 


<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">                
                <form action="{{ route('guides.update', ['id' => $guide->id_G]) }}" method="POST" onsubmit="return validateRecaptcha()">
                    @csrf
                    @method('PUT')

                    
                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">تعديل : {{ $guide->titre_G}}</h2>
                            <div class="stroke-shape"></div>
                        </div><!-- end block-card-header -->
                        <div class="block-card-body">
   
                            <div class="col-lg-10">
                                <div class="input-box">
                                <label for="titre_G" class="label-text">العنوان</label>
                                    <div class="form-group">
                                        <input type="text" class="form-control pl-3 @error('titre_G') is-invalid @enderror"  id="titre_G" name="titre_G" placeholder="العنوان"  value="{{ $guide->titre_G }}" required autofocus>
                                        @error('titre')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                            </div><!-- end titre guide -->                       
                            <div class="col-lg-10">
                                <div class="input-box">
                                    <label for="ordre" class="label-text">الترتيب</label>
                                    <input id="ordre" type="number" class="form-control @error('ordre_G') is-invalid @enderror" name="ordre_G" value="{{ $guide->order }}"  required>
                                    @error('ordre')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div><!-- end ordre -->

                            
                        </div><!-- end guide -->
                        <br>
<div class="form-group row">            
            <div class="form-group mt-3">
                  <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                  <span id="recaptcha-error" class="invalid-feedback" style="display: block;"></span>
                </div>
            </div>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
    function validateRecaptcha() {
        const response = grecaptcha.getResponse();
        const errorMessageElement = document.getElementById('recaptcha-error');

        // Clear existing error message
        if (errorMessageElement) {
            errorMessageElement.innerText = '';
        }

        if (!response) {
            // Display the error message
            if (errorMessageElement) {
                errorMessageElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
            } else {
                // If the error message element doesn't exist, create it
                const recaptchaContainer = document.querySelector('.g-recaptcha');
                const errorElement = document.createElement('span');
                errorElement.id = 'recaptcha-error';
                errorElement.className = 'invalid-feedback';
                errorElement.style.display = 'block';
                errorElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
                recaptchaContainer.parentNode.appendChild(errorElement);
            }
            return false;
        }
        return true;
    }
</script>

                        <button type="submit" class="btn btn-success font-weight-medium"> <i class="la la-save mr-1">حفظ</i></button>                    
                        <button onclick="history.back()" class="btn bg-rgb-primary1 font-weight-medium"><i class="la la-times mr-1">الغاء</i></button>
                        <a class="btn bg-primary text-white btn-sm mr-2" href="{{ route('guides.listepages', ['id' => $guide->id_G]) }}"><i class="la la-file-text mr-1">صفحات </i></a>
                    </div><!-- end  -->                    
                    
                </form>                
            </div>
        </div>
    </div>
</section>



@endsection