@extends('BackOfficeAR.dashboardAR')
@section('content')

    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>

    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <form method="POST" action="{{ route('ajoutersection') }}" enctype="multipart/form-data" onsubmit="return validateRecaptcha()">
                        @csrf
                        <input type="hidden" name="page_id" value="{{ $page->id_P }}">

                        <div class="block-card mb-4">
                            <div class="block-card-header">
                                <h2 class="widget-title"> أضف قسما في: {{ $page->titre_P }}</h2>
                                <div class="stroke-shape"></div>
                            </div><!-- end block-card-header -->
                            <div class="block-card-body">

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="input-box">
                                            <label class="label-text" for="titre">العنوان</label>
                                            <div class="form-group">
                                                <input id="titre" type="text" placeholder="العنوان"
                                                    class="form-control pl-3 @error('titre') is-invalid @enderror"
                                                    name="titre" value="{{ old('titre') }}" required autofocus>
                                                @error('titre')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div><!-- end titre section -->

                                    <div class="col-lg-6">
                                        <div class="input-box">
                                            <label class="label-text" for="ordre">الترتيب</label>
                                            <div class="form-group">
                                                <input id="ordre" type="number"
                                                    class="form-control @error('ordre') is-invalid @enderror" name="ordre"
                                                    value="{{ old('ordre') }}" required>
                                                @error('ordre')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div><!-- end ordre section -->
                                </div><!-- end row -->

                                <label for="contenu" class="label-text">المحتوى</label>
                                <div class="linha">

                                    <br>
                                    <div class="col">
                                        <textarea id="contenu" name="contenu" placeholder="..." required>{{ old('contenu') }}</textarea>
                                        @error('contenu')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <script>
                                    CKEDITOR.replace('contenu');
                                </script>

                            </div><!-- end section -->
                            <br>

<div class="form-group row">            
            <div class="form-group mt-3">
                  <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                  <span id="recaptcha-error" class="invalid-feedback" style="display: block;"></span>
                </div>
            </div>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
    function validateRecaptcha() {
        const response = grecaptcha.getResponse();
        const errorMessageElement = document.getElementById('recaptcha-error');

        // Clear existing error message
        if (errorMessageElement) {
            errorMessageElement.innerText = '';
        }

        if (!response) {
            // Display the error message
            if (errorMessageElement) {
                errorMessageElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
            } else {
                // If the error message element doesn't exist, create it
                const recaptchaContainer = document.querySelector('.g-recaptcha');
                const errorElement = document.createElement('span');
                errorElement.id = 'recaptcha-error';
                errorElement.className = 'invalid-feedback';
                errorElement.style.display = 'block';
                errorElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
                recaptchaContainer.parentNode.appendChild(errorElement);
            }
            return false;
        }
        return true;
    }
</script>

                            <button type="submit" class="btn btn-success font-weight-medium"><i
                                class="la la-save mr-1">حفظ</i></button>
                             <a href="{{ route('pages.listesections', ['id' => $page->id_P]) }}"
                            class="btn bg-rgb-primary1 font-weight-medium"><i class="la la-times mr-1">الغاء</i></a>
                    
                        </div><!-- end block-card -->

                        
                            
                    </form>
                </div>
            </div>
        </div>
    </section>

    <div id="back-to-top">
        <i class="la la-arrow-up" title="Go top"></i>
    </div>
@endsection


