@extends('BackOfficeAR.dashboardAR')
@section('content')
    

    
    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    

                    <form method="POST" action="{{ route('ajoutinfosupp') }}" enctype="multipart/form-data" onsubmit="return validateRecaptcha()">
                        @csrf
                        <input type="hidden" name="id_ob" value="{{ $id_ob }}">
                        <input type="hidden" name="nbtype" value="{{ $nbtype }}">


                        <div class="block-card mb-4">
                            <div class="block-card-header">
                                <h2 class="widget-title">
                                    @if($nbtype == 1)
                                        لإضافة ملحق إلى : {{ $ob->titre_P }}
                                    @elseif($nbtype== 2)
                                        لإضافة ملحق إلى : {{ $ob->titre_S }}
                                    @endif
                                </h2>
                                <div class="stroke-shape"></div>
                            </div>

                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="input-box">
                                        <label class="label-text" for="link">الرابط</label>
                                        <div class="form-group">
                                            <input id="link" type="text" placeholder="رابط"
                                                class="form-control pl-3 @error('link') is-invalid @enderror" name="link"
                                                value="{{ old('link') }}" autofocus>
                                            @error('link')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div><!-- end link -->
                            
                                <div class="col-lg-6">
                                    <div class="input-box">
                                        <label class="label-text" for="ordre">الترتيب</label>
                                        <input id="ordre" type="number"
                                            class="form-control @error('ordre') is-invalid @enderror" name="ordre"
                                            value="{{ old('ordre') }}" required>
                                        @error('ordre')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div><!-- end ordre -->
                            </div><!-- end row -->
                            


                            <div class="block-card-body">
                                <label class="label-text">إضافة صورة</label>
                                <div class="file-upload-wrap">
                                    <input type="file" for="images" name="images[]"
                                        class="multi file-upload-input with-preview" multiple>
                                    <span class="file-upload-text"><i class="la la-upload mr-2"></i>اسحب الملف هنا أو انقر لتحميل</span>

                                </div>
                            </div>
                            @if($nbtype == 2 )
                            <div class="block-card-body">
                                <label class="label-text">تحميل ملف</label>
                                <div class="file-upload-wrap file-upload-wrap-2">
                                    <input type="file" for="pdf"name="pdf" class="multi file-upload-input with-preview" >
                                    <span class="file-upload-text"><i class="la la-photo mr-2"></i>اختر ملفًا</span>
                                </div>
                            </div>
                            
                            @endif
                            

                        <div class="form-group row">            
            <div class="form-group mt-3">
                  <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                  <span id="recaptcha-error" class="invalid-feedback" style="display: block;"></span>
                </div>
            </div>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
    function validateRecaptcha() {
        const response = grecaptcha.getResponse();
        const errorMessageElement = document.getElementById('recaptcha-error');

        // Clear existing error message
        if (errorMessageElement) {
            errorMessageElement.innerText = '';
        }

        if (!response) {
            // Display the error message
            if (errorMessageElement) {
                errorMessageElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
            } else {
                // If the error message element doesn't exist, create it
                const recaptchaContainer = document.querySelector('.g-recaptcha');
                const errorElement = document.createElement('span');
                errorElement.id = 'recaptcha-error';
                errorElement.className = 'invalid-feedback';
                errorElement.style.display = 'block';
                errorElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
                recaptchaContainer.parentNode.appendChild(errorElement);
            }
            return false;
        }
        return true;
    }
</script>

                        
                            <button type="submit" class="btn btn-success font-weight-medium"><i class="la la-save mr-1">حفظ</i></button>

                            @if ($nbtype == 1)                               
                                <a href="{{ route('listesinfosuppsP', ['id' => $ob->id_P]) }}"
                                    class="btn bg-rgb-primary1 font-weight-medium"><i class="la la-times mr-1">الغاء</i></a>
                            @elseif($nbtype == 2)
                                <a href="{{ route('listesinfosuppsS', ['id' => $ob->id_S]) }}"
                                    class="btn bg-rgb-primary1 font-weight-medium"><i class="la la-times mr-1">الغاء</i></a>
                            @endif

                        </div>


                    </form>

                </div>
            </div>
        </div>
    </section>



    <div id="back-to-top">
        <i class="la la-arrow-up" title="Go top"></i>
    </div>
@endsection
