@extends('BackOfficeAR.dashboardAR')
@section('content')

    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    

                    <form method="POST" action="{{ route('ajoutguide') }}" enctype="multipart/form-data" onsubmit="return validateRecaptcha()">
                        @csrf
                        
                        <input type="hidden" name="tp" value="{{ $tp }}">

                        <div class="block-card mb-4">
                            <div class="block-card-header">
                                <h2 class="widget-title">إضف:</h2>
                                <div class="stroke-shape"></div>
                            </div>
                            <div class="block-card-body">

                                <div class="row">
                                    <div class="col-lg-10">
                                        <div class="input-box">
                                            <label class="label-text" for="titre">العنوان</label>
                                            <div class="form-group">
                                                <input id="titre" type="text" placeholder="العنوان"
                                                    class="form-control pl-3 @error('titre') is-invalid @enderror"
                                                    name="titre" value="{{ old('titre') }}" required autofocus>
                                                @error('titre')
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div> 
                                
                                    <div class="col-lg-4">
                                        <div class="input-box">
                                            <label class="label-text" for="langue_id">اللغة</label>
                                            <div class="form-group user-chosen-select-container">
                                                <select id="langue_id" data-placeholder="اللغة"
                                                    class="user-chosen-select @error('langue_id') is-invalid @enderror"
                                                    name="langue_id" required>
                                                    <option></option>
                                                    @foreach ($langues as $langue)
                                                        <option value="{{ $langue->id_L }}"
                                                            {{ old('langue_id') == $langue->id_L ? 'selected' : '' }}>
                                                            {{ $langue->nom_L }}</option>
                                                    @endforeach
                                                </select>
                                                @error('langue_id')
                                                    <div class="alert alert-danger">
                                                        {{ $message }}
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div> 
                                
                                    <div class="col-lg-6">
                                        <div class="input-box">
                                            <label class="label-text" for="ordre">الترتيب</label>
                                            <input id="ordre" type="number"
                                                class="form-control @error('ordre') is-invalid @enderror" name="ordre"
                                                value="{{ old('ordre') }}" required>
                                            @error('ordre')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div> 
                                </div> 
                                
                            </div>

<div class="form-group row">            
            <div class="form-group mt-3">
                  <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                  <span id="recaptcha-error" class="invalid-feedback" style="display: block;"></span>
                </div>
            </div>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
    function validateRecaptcha() {
        const response = grecaptcha.getResponse();
        const errorMessageElement = document.getElementById('recaptcha-error');

         if (errorMessageElement) {
            errorMessageElement.innerText = '';
        }

        if (!response) {
             if (errorMessageElement) {
                errorMessageElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
            } else {
                 const recaptchaContainer = document.querySelector('.g-recaptcha');
                const errorElement = document.createElement('span');
                errorElement.id = 'recaptcha-error';
                errorElement.className = 'invalid-feedback';
                errorElement.style.display = 'block';
                errorElement.innerText = 'يرجى تأكيد أنك لست روبوتًا.';
                recaptchaContainer.parentNode.appendChild(errorElement);
            }
            return false;
        }
        return true;
    }
</script>

                            <button type="submit" class="btn btn-success font-weight-medium"> <i class="la la-save mr-1">حفظ</i></button>
                            <a href="{{ route('guides.index' , ['tp' => $tp]) }}" class="btn bg-rgb-primary1 font-weight-medium"><i class="la la-times mr-1">الغاء</i></a>
                        </div>               
                        

                    </form>

                </div>
            </div>
        </div>
    </section>

    <div id="back-to-top">
        <i class="la la-arrow-up" title="Go top"></i>
    </div>
@endsection
