@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
<style>
    /* Taille des boutons réduite */
    .form-group button,
    .form-group a {
        min-width: 140px;
        font-weight: bold;
        border: none;
        border-radius: 8px;
        font-size: 14px;
        padding: 6px 10px;
        box-shadow: 0 3px 6px rgba(0,0,0,0.1);
        transition: all 0.2s ease-in-out;
    }

    .form-group button:hover,
    .form-group a:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    /* Dégradé orange pour "حفظ كمسودة" */
    .btn-orange-gradient {
        background: linear-gradient(135deg, #ff9f43, #e96b05);
        color: #fff;
    }
    .btn-orange-gradient:hover {
        background: linear-gradient(135deg, #ffa94d, #ff7b1a);
    }

    /* Bouton Retour bleu */
    .btn-primary {
        background-color: #007bff;
    }
    .btn-primary:hover {
        background-color: #0069d9;
    }

    /* Responsive - garder même ligne si possible */
    @media (max-width: 768px) {
        .form-group .d-flex {
            flex-wrap: wrap;
            justify-content: center;
        }
        .form-group button,
        .form-group a {
            min-width: 120px;
            font-size: 13px;
            padding: 5px 8px;
        }
    }
</style>
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit">
<div class="container">
<form action="{{ route('doc_fin.update', $docList->id_doc_list) }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
    @method('PUT')


    <!-- Formulaire 1 -->
                <div class="container" lang="ar" dir="rtl">
                        <input type="hidden" name="id_association" value="{{ $association->id_association ?? '' }}">
                        <input type="hidden" name="id_demande" value="{{ $demande_id ?? '' }}">
                        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
                        <input type="hidden" name="id_projet" value="{{ $id_projet ?? '' }}">

                        <h2 class="text-center">الجمهورية التونسية</h2>
                        <h3 class="text-center">وزارة شؤون الشباب و الرياضة</h3>
                        <h4 class="text-center mt-4">اللجنة الفنية للنظر في مطالب التمويل العمومي</h4>

                        <div class="card mt-4 shadow-sm">
                            <div class="card-header text-center bg-white">
                                <div class="row mb-3 align-items-center">
                                    <label  style="color:black;"    class="col-sm-3 col-form-label">إسم الجمعية</label>
                                    <div class="col-sm-9">
                                        <input type="text" name="nom_association" class="form-control" value="{{ old('nom_association', $docList->projet->demande->association->nom_association ?? '') }}">    
                                    </div>
                                </div>
                            </div>
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0">{{ $formulaire->type_ar }}</h5>
                                
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    @foreach($type_financement as $type)
                                        <div class="col-md-4 col-sm-6 mb-2 text-center">
                                            <div class="form-check d-flex justify-content-start" dir="rtl">
                                                    <input class="form-check-input me-2 text-center" type="checkbox" name="types_financement[]" value="{{ $type->id_type_fin }}"
                                                        @if( (old('types_financement') && in_array($type->id_type_fin, old('types_financement'))) || (!old('types_financement') && in_array($type->id_type_fin, $selectedTypes)) ) checked @endif>
                                                    <label class="col-sm-12 col-form-label" style="color:black;">{{ $type->type_ar }}</label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div class="card mt-4 shadow-sm">
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0">المعطيات الخاصة بالجمعية</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label"> عنوان الجمعية</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="adresse" class="form-control" value="{{ old('adresse', $docList->projet->demande->association->adresse ?? '') }}" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">الترقيم البريدي</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="code_postal" class="form-control" value="{{ old('code_postal', $docList->projet->demande->association->code_postal ?? '') }}" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">الهاتف</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="tel" class="form-control" value="{{ old('tel', $docList->projet->demande->association->tel ?? '') }}" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">الفاكس</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="fax" class="form-control" value="{{ old('fax', $docList->projet->demande->association->fax ?? '') }}" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">تاريخ التأسيس</label>
                                    <div class="col-sm-4">
                                        <input type="date" name="date_creation" class="form-control" value="{{ old('date_creation', $docList->projet->demande->association->date_creation ?? '') }}" >
                                    </div>
                                    
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">رقم التأشيرة</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_visa" class="form-control" value="{{ old('num_visa', $docList->projet->demande->association->num_visa ?? '') }}" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">تاريخ التأشيرة</label>
                                    <div class="col-sm-4">
                                        <input type="date" name="date_visa" class="form-control" value="{{ old('date_visa', $docList->projet->demande->association->date_visa ?? '') }}" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">رقم المعرف الجبائي</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="num_identification_fiscale" class="form-control" value="{{ old('num_identification_fiscale', $docList->projet->demande->association->num_identification_fiscale ?? '') }}" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">رقم الحساب الجاري</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_compte_courant" class="form-control" value="{{ old('num_compte_courant', $docList->projet->demande->association->num_compte_courant ?? '') }}" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">  البنك</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="banque" class="form-control" value="{{ old('banque', $docList->projet->demande->association->banque ?? '') }}" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">البريد الإلكتروني</label>
                                    <div class="col-sm-4">
                                        <input type="email" name="adresse_mail" class="form-control" value="{{ old('adresse_mail', $docList->projet->demande->association->adresse_mail ?? '') }}" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">  عنوان موقع الواب</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="adresse_site_internet" class="form-control" value="{{ old('adresse_site_internet', $docList->projet->demande->association->adresse_site_internet ?? '') }}" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label"> إسم رئيس الجمعية</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="nom_president_association" class="form-control" value="{{ old('nom_president_association', $docList->projet->demande->association->nom_president_association ?? '') }}" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">  الهاتف الشخصي </label>
                                    <div class="col-sm-4">
                                        <input type="text" name="tel_personnel" class="form-control" value="{{ old('tel_personnel', $docList->projet->demande->association->tel_personnel ?? '') }}" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">عدد أعضاء المكتب الوطني للجمعية</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_membre_bureau_national_a" class="form-control" value="{{ old('num_membre_bureau_national_a', $docList->projet->demande->association->num_membre_bureau_national_a ?? '') }}" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">عدد المكاتب الجهوية ان وجدت</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_bureaux_regionaux" class="form-control" value="{{ old('num_bureaux_regionaux', $docList->projet->demande->association->num_bureaux_regionaux ?? '') }}" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">عدد المنخرطين الاجمالي</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_total_membre" class="form-control" value="{{ old('num_total_membre', $docList->projet->demande->association->num_total_membre ?? '') }}" >
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            

        <!-- Formulaire 2 -->
            <div class="container">
                    <input type="hidden" name="id_formulaire" value="{{ $formulaire2->id_type }}">
                    <input type="hidden" name="id_demande" value="{{ $demande_id }}">
                    <h2 class="text-center">الجمهورية التونسية</h2>
                    <h2 class="text-center">وزارة الشباب و الرياضة</h2>
                    <h3 class="text-center" style="font-size:25px;">{{ $formulaire2->type_ar }}</h3>
                    <h4 class="text-center pt-3">جذاذة فنية</h4>
                    <br>

                    <div class="form-section">
                       <!--div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">إسم الجمعية</label>
                            <div class="col-sm-10">
                                <input type="hidden" name="id_association" value="{{ $selectedAssociationId }}">
                                <input type="text" name="nom_association_display" class="form-control bg-white" readonly>
                            </div>
                        </!--div-->

                        
                        <h4>  المعطيات البيداغوجية</h4>
                        <div class="form-group row mb-3"  style="padding-top:20px;">
                            <label class="col-sm-2 col-form-label"> اسم و لقب المشرف على التنفيذ </label>
                            <div class="col-sm-4">
                                <input  type="text" class="form-control" name="nom_prenom_sup" placeholder="الاسم و اللقب" value="{{ old('nom_prenom_sup', $docList->projet->superviseur->nom_prenom_sup ?? '') }}" maxlength="100">
                            </div>
                            <label class="col-sm-2 col-form-label">  المهنة </label>
                            <div class="col-sm-4">
                                <input  type="text" class="form-control" name="profession_sup" placeholder=" المهنة  " value="{{ old('profession_sup', $docList->projet->superviseur->profession_sup ?? '') }}" maxlength="100" >
                            </div>
                        </div>
                        <div class="form-group row align-items-center">
                            <label class="col-sm-2 col-form-label"> الصفة في الجمعية</label>  
                            <div class="col-sm-4">
                                <input  type="text" class="form-control" name="role_sup" value="{{ old('role_sup', $docList->projet->superviseur->role_sup ?? '') }}" placeholder=" الصفة  " maxlength="100" >
                            </div>
                            <label class="col-sm-2 col-form-label">  الهاتف </label>
                            <div class="col-sm-4">
                                <input  type="text" class="form-control" name="tel_sup" value="{{ old('tel_sup', $docList->projet->superviseur->tel_sup ?? '') }}" max=12 >
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">  البريد الالكتروني </label>
                            <div class="col-sm-4">
                                <input  type="email" class="form-control" name="email_sup" value="{{ old('email_sup', $docList->projet->superviseur->email_sup ?? '') }}">
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label"> اسم المشروع / التظاهرة / النشاط </label>
                            <div class="col-sm-10">
                                <input  type="text" class="form-control" name="nom_projet" maxlength="255" value="{{ old('nom_projet', $docList->projet->nom_projet ?? '') }}">
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label"> مبررات الانجاز </label>
                            <div class="col-sm-10">
                                <textarea  class="form-control" name="justification_realisation" maxlength="255" rows="4" placeholder="ادخل مبررات الانجاز">{{ old('justification_realisation', $docList->projet->justification_realisation ?? '') }}</textarea>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">الأهداف</label>
                            <div class="col-sm-10">
                                <textarea class="form-control" 
                                        name="objectives" 
                                        rows="4" 
                                        placeholder="أدخل الأهداف">{{ old('objectives', $docList->projet->objectives ?? '') }}</textarea>

                                {{-- Affichage du message d'erreur Laravel --}}
                                @error('objectives')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label">  وصف الفقرات او المراحل </label>
                        </div>

                        <div class="form-group row">
                            <table id="phase-table" class="custom-table">
                                <thead>
                                    <tr>
                                        <th> </th> 
                                        <th>اهم الفقرات او المراحل</th>
                                        <th>تاريخ الانجاز</th>
                                        <th>مكان الإنجاز</th>
                                        <th> </th>
                                    </tr>
                                </thead>
                                <tbody id="phase-body">
                                    @if(!empty($docList->projet->activites) && $docList->projet->activites->count() > 0)
                                        @foreach($docList->projet->activites as $index => $phase)
                                            <tr>
                                                <td class="row-number">{{ $index + 1 }}</td>
                                                <td data-label="اهم الفقرات او المراحل">
                                                    <input type="text" 
                                                        name="phases[{{ $index }}][description]" 
                                                        class="form-control" 
                                                        maxlength="200"
                                                        value="{{ old('phases.' . $index . '.description', $phase->description) }}">
                                                </td>
                                                <td data-label="تاريخ الانجاز">
                                                    <input type="date" 
                                                        name="phases[{{ $index }}][completion_date]" 
                                                        class="form-control"
                                                        value="{{ old('phases.' . $index . '.completion_date', $phase->completion_date) }}">
                                                </td>
                                                <td data-label="مكان الإنجاز">
                                                    <input type="text" 
                                                        name="phases[{{ $index }}][completion_location]" 
                                                        class="form-control" 
                                                        maxlength="100"
                                                        value="{{ old('phases.' . $index . '.completion_location', $phase->completion_location) }}">
                                                </td>
                                                <td class="action-buttons">
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="removePhaseRow(this)">حذف</button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td class="row-number">1</td> 
                                            <td data-label="اهم الفقرات او المراحل">
                                                <input type="text" name="phases[0][description]" class="form-control"  maxlength="200">
                                            </td>
                                            <td data-label="تاريخ الانجاز">
                                                <input type="date" name="phases[0][completion_date]" class="form-control">
                                            </td>
                                            <td data-label="مكان الإنجاز">
                                                <input type="text" name="phases[0][completion_location]" class="form-control" maxlength="100">
                                            </td>
                                            <td class="action-buttons">
                                                <button type="button" class="btn btn-danger btn-sm" onclick="removePhaseRow(this)">حذف</button>
                                            </td>
                                        </tr>
                                    @endif
                                </tbody>

                            </table>
                            <button type="button" class="btn btn-primary mt-2" onclick="addPhaseRow()" style="background-color: #28a745; border-color: #28a745;">
                                إضافة صف
                            </button>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">  الجمهور المستفيد  </label>
                            <div class="col-sm-10">
                                <input  type="text" class="form-control" value="{{ old('public', $docList->projet->public ?? '') }}" name="public" maxlength="255">
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">العدد التقريبي للجمهور</label>
                            <div class="col-sm-10">
                                <input  type="number" class="form-control" name="nombre_spectateur" value="{{ old('nombre_spectateur', $docList->projet->nombre_spectateur ?? '') }}">
                            </div>
                        </div>

                        <div class="form-group row mb-3 align-items-center">
                            <label class="col-sm-2 col-form-label">الشريحة العمرية المستهدفة</label>

                            <div class="col-sm-5 d-flex align-items-center">
                                <label class="col-form-label mb-0 me-3">من</label>
                                <input  type="number" class="form-control" name="tranch_age_min" value="{{ old('tranch_age_min', $docList->projet->tranch_age_min ?? '') }}">
                            </div>

                            <div class="col-sm-5 d-flex align-items-center">
                                <label class="col-form-label mb-0 me-3">الى</label> 
                                <input  type="number" class="form-control" name="tranch_age_max" value="{{ old('tranch_age_max', $docList->projet->tranch_age_max ?? '') }}">
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label">  الاطراف المشاركة في الانجاز </label>
                            <div class="col-sm-12">
                                <textarea  class="form-control" name="parties_realisation" rows="4">{{ old('parties_realisation', $docList->projet->parties_realisation ?? '') }}</textarea>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label"> النتائج المرتقب تحقيقها </label>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label"> 1- النتائج الكمية  </label>
                            <div class="col-sm-12">
                                <textarea  class="form-control" name="resultat_quantitatif" rows="4">{{ old('resultat_quantitatif', $docList->projet->resultat_quantitatif ?? '') }}</textarea>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label"> 2- النتائج النوعية  </label>
                            <div class="col-sm-12">
                                <textarea  class="form-control" name="resultat_qualitatif" rows="4">{{ old('resultat_qualitatif', $docList->projet->resultat_qualitatif ?? '') }}</textarea>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label"> الافاق المنتضرة </label>
                            <div class="col-sm-12">
                                <textarea  class="form-control" name="perspectives" rows="4">{{ old('perspectives', $docList->projet->perspectives ?? '') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-section">
                        <h4>الموازنة المالية</h4>
                        <label class="col-sm-6 col-form-label">الميزانية التقديرية</label>

                        <div class="form-group row">
                            <table class="custom-table table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th rowspan="2">الكلفة الجملية التقديرية<br>(المبلغ بالدينار التونسي)</th>
                                        <th colspan="2">حجم التمويل الذاتي</th>
                                        <th colspan="2">حجم الدعم المطلوب من الوزارة</th>
                                    </tr>
                                    <tr>
                                        <th>النسبة المائوية</th>
                                        <th>المبلغ بالدينار</th>
                                        <th>المبلغ بالدينار</th>
                                        <th>النسبة المائوية</th>
                                    </tr>
                                </thead>
                                <tbody id="budget-body">
                                    @if(!empty($docList->projet->estimationBudget) && $docList->projet->estimationBudget->count() > 0)
                                        @foreach($docList->projet->estimationBudget as $index => $budget)
                                            <tr>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[{{ $index }}][total_cost]" 
                                                        class="form-control"
                                                        value="{{ old('budget.' . $index . '.total_cost', $budget->cout_total_estime) }}">
                                                </td>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[{{ $index }}][self_percent]" 
                                                        class="form-control"
                                                        value="{{ old('budget.' . $index . '.self_percent', $budget->financement_propre_pourcentage) }}">
                                                </td>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[{{ $index }}][self_amount]" 
                                                        class="form-control"
                                                        value="{{ old('budget.' . $index . '.self_amount', $budget->financement_propre_montant) }}">
                                                </td>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[{{ $index }}][ministry_amount]" 
                                                        class="form-control"
                                                        value="{{ old('budget.' . $index . '.ministry_amount', $budget->aide_ministere_montant) }}">
                                                </td>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[{{ $index }}][ministry_percent]" 
                                                        class="form-control"
                                                        value="{{ old('budget.' . $index . '.ministry_percent', $budget->aide_ministere_pourcentage) }}">
                                                </td>
                                                <td class="action-buttons">
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeBudgetRow(this)">حذف</button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td><input type="number" name="budget[0][total_cost]" class="form-control"></td>
                                            <td><input type="number" name="budget[0][self_percent]" class="form-control"></td>
                                            <td><input type="number" name="budget[0][self_amount]" class="form-control"></td>
                                            <td><input type="number" name="budget[0][ministry_amount]" class="form-control"></td>
                                            <td><input type="number" name="budget[0][ministry_percent]" class="form-control"></td>
                                            <td class="action-buttons">
                                                <button type="button" class="btn btn-danger btn-sm" onclick="removeBudgetRow(this)">حذف</button>
                                            </td>
                                        </tr>
                                    @endif
                                </tbody>

                            </table>
                        </div>

                        <div class="form-group row">
                            <table id="supporters-table" class="custom-table table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th colspan="5">الأطراف المساهمة في الدعم</th>
                                    </tr>
                                    <tr>
                                        <th>ع/ر</th>
                                        <th>الطرف المساهم</th>
                                        <th>المبلغ بالدينار</th>
                                        <th>النسبة المائوية</th>
                                        <th>إجراء</th>
                                    </tr>
                                </thead>
                                <tbody id="supporters-body">
                                    @foreach($docList->projet->estimationBudget as $budgetIndex => $budget)
                                        @if(!empty($budget->contributeurs) && $budget->contributeurs->count() > 0)
                                            @foreach($budget->contributeurs as $supporterIndex => $supporter)
                                                <tr>
                                                    <td class="row-number">{{ $supporterIndex + 1 }}</td>
                                                    <td>
                                                        <input type="text" 
                                                            name="budget[{{ $budgetIndex }}][supporters][{{ $supporterIndex }}][name]" 
                                                            class="form-control"
                                                            value="{{ old('budget.' . $budgetIndex . '.supporters.' . $supporterIndex . '.name', $supporter->nom) }}">
                                                    </td>
                                                    <td>
                                                        <input type="number" 
                                                            name="budget[{{ $budgetIndex }}][supporters][{{ $supporterIndex }}][amount]" 
                                                            class="form-control"
                                                            value="{{ old('budget.' . $budgetIndex . '.supporters.' . $supporterIndex . '.amount', $supporter->montant) }}">
                                                    </td>
                                                    <td>
                                                        <input type="number" 
                                                            name="budget[{{ $budgetIndex }}][supporters][{{ $supporterIndex }}][percent]" 
                                                            class="form-control"
                                                            value="{{ old('budget.' . $budgetIndex . '.supporters.' . $supporterIndex . '.percent', $supporter->pourcentage) }}">
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeSupporterRow(this)">حذف</button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td class="row-number">1</td>
                                                <td><input type="text" name="budget[{{ $budgetIndex }}][supporters][0][name]" class="form-control"></td>
                                                <td><input type="number" name="budget[{{ $budgetIndex }}][supporters][0][amount]" class="form-control"></td>
                                                <td><input type="number" name="budget[{{ $budgetIndex }}][supporters][0][percent]" class="form-control"></td>
                                                <td>
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeSupporterRow(this)">حذف</button>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>

                            </table>
                            <button type="button" class="btn btn-success mt-2" onclick="addSupporterRow(0)">إضافة صف</button>
                        </div>

                        <label class="col-sm-6 col-form-label"> ابواب صرف الميزانية </label>
                        <div class="form-group row">
                            <table id="depenses-table" class="custom-table">
                                <thead>
                                    <tr>
                                        <th> </th> 
                                        <th> الفقرات </th>
                                        <th>مستلزمات الفقرات (1)</th>
                                        <th>التكلفة (د) </th>
                                        <th> </th>
                                    </tr>
                                </thead>
                                <tbody id="depenses-body">
                                    @foreach($docList->projet->estimationBudget as $budgetIndex => $budget)
                                        @if(!empty($budget->postesDepense) && $budget->postesDepense->count() > 0)
                                            @foreach($budget->postesDepense as $depenseIndex => $depense)
                                                <tr>
                                                    <td class="row-number">{{ $depenseIndex + 1 }}</td>
                                                    <td data-label="الفقرات">
                                                        <input type="text" 
                                                            name="depenses[{{ $budgetIndex }}][{{ $depenseIndex }}][libelle_depense]" 
                                                            class="form-control" 
                                                            maxlength="200"
                                                            value="{{ old('depenses.' . $budgetIndex . '.' . $depenseIndex . '.libelle_depense', $depense->libelle_depense) }}">
                                                    </td>
                                                    <td data-label="مستلزمات الفقرات">
                                                        <input type="text" 
                                                            name="depenses[{{ $budgetIndex }}][{{ $depenseIndex }}][description]" 
                                                            class="form-control"
                                                            value="{{ old('depenses.' . $budgetIndex . '.' . $depenseIndex . '.description', $depense->description) }}">
                                                    </td>
                                                    <td data-label="التكلفة (د)">
                                                        <input type="number" 
                                                            name="depenses[{{ $budgetIndex }}][{{ $depenseIndex }}][cout]" 
                                                            class="form-control"
                                                            value="{{ old('depenses.' . $budgetIndex . '.' . $depenseIndex . '.cout', $depense->cout) }}">
                                                    </td>
                                                    <td class="action-buttons">
                                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeDepensesRow(this)">حذف</button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td class="row-number">1</td>
                                                <td data-label="الفقرات">
                                                    <input type="text" name="depenses[{{ $budgetIndex }}][0][libelle_depense]" class="form-control" maxlength="200">
                                                </td>
                                                <td data-label="مستلزمات الفقرات">
                                                    <input type="text" name="depenses[{{ $budgetIndex }}][0][description]" class="form-control">
                                                </td>
                                                <td data-label="التكلفة (د)">
                                                    <input type="number" name="depenses[{{ $budgetIndex }}][0][cout]" class="form-control">
                                                </td>
                                                <td class="action-buttons">
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeDepensesRow(this)">حذف</button>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>

                            </table>
                            <button type="button" class="btn btn-primary mt-2" onclick="addDepensesRow()" style="background-color: #28a745; border-color: #28a745;">
                                    إضافة صف
                            </button>
                        </div>
                        <span>
                            (1) :  مستلزمات كل فقرة على حدة مثلا / مستلزمات الندوة او المعرض او الورشة او العرض 
                        </span>
                    </div>
            </div>
     

<!-- Formulaire 3 -->
    <div class="container">

        <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">
        <input type="hidden" name="id_projet" value="{{ $id_projet }}">
        <h2>الجمهورية التونسية</h2>
        <h2>وزارة الشباب و الرياضة</h2>
        <h3 style="font-size:25px;">{{ $formulaire3->type_ar }}</h3>
        <br>
        <div class="form-section">
            <div class="form-group row">
                <table id="phase-table" class="custom-table table table-bordered text-center">
                    <thead>
                        <tr>
                            <th>#</th> 
                            <th> الوثائق حسب الامر عدد 5183 </th>
                            <th> الوثائق </th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($typedocum as $index => $doc)
                        @php
                            $existing = $documents->firstWhere('id_doc', $doc->id_type_doc);
                        @endphp
                        <tr>
                            <td>{{ $index + 1 }}</td>

                            <td>
                                {{ $doc->type_ar }}
                                <input type="hidden" name="doc_fin[{{ $index }}][id_doc]" value="{{ $doc->id_type_doc }}">
                            </td>

                            <td>
                                @if(in_array($doc->id_type_doc, [15, 17]))
                                    ✅ هذا الملف متوفر بالفعل
                                @else
                                    @if($existing && $existing->file)
                                        <a href="{{ asset('storage/'.$existing->file) }}" 
                                        target="_blank" 
                                        class="btn btn-sm btn-info" 
                                        title="عرض الملف">
                                            📂 عرض الملف
                                        </a>
                                    @else
                                        <span class="text-muted">لا يوجد ملف</span>
                                    @endif
                                @endif
                            </td>

                            <td>
                                @if(!in_array($doc->id_type_doc, [15, 17]))
                                    <input type="file" name="doc_fin[{{ $index }}][file]" class="form-control">
                                @endif
                            </td>

                           
                        </tr>
                    @endforeach
                    </tbody>

                </table>
            </div>
        </div>

    </div>
    <div class="form-group text-center mt-5">
    <input type="hidden" id="brouillon" name="brouillon" value="0">

    <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
        <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill"
                onclick="document.getElementById('brouillon').value = 0;">
            <i class="bx bx-save"></i> حفظ
        </button>

        

        <a href="{{ route('doc_fin.index') }}"
           class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
            <i class="bx bx-arrow-back"></i> رجوع
        </a>
    </div>
</div>

<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

   <div id="global-block-msg" class="alert alert-danger" style="display:none">
        يوجد مستندات مفقودة أو يلزم تعبئة خطوات سابقة — لن يتم حفظ الطلب حتى تكتمل الشروط.
    </div>
    
</div>  


</form>
</div>
<script src="{{ asset('BackOfficeAR/js/salle_sport_form.js') }}"></script>
<script src="{{ asset('BackOfficeAR/js/script.js') }}"></script>
<script>
    let phaseIndex = 1;

    function addPhaseRow() {
        let tableBody = document.getElementById('phase-body');
        let newRow = document.createElement('tr');
        newRow.innerHTML = `
            <td class="row-number">${tableBody.rows.length + 1}</td>
            <td data-label="اهم الفقرات او المراحل">
                <input type="text" name="phases[${phaseIndex}][description]" class="form-control" maxlength="200">
            </td>
            <td data-label="تاريخ الانجاز">
                <input type="date" name="phases[${phaseIndex}][completion_date]" class="form-control">
            </td>
            <td data-label="مكان الإنجاز">
                <input type="text" name="phases[${phaseIndex}][completion_location]" class="form-control">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn btn-danger btn-sm" onclick="removePhaseRow(this)">حذف</button>
            </td>
        `;
        tableBody.appendChild(newRow);
        phaseIndex++;
        updateRowNumbers();
    }

    function removePhaseRow(button) {
        let row = button.closest('tr');
        row.remove();
        updateRowNumbers();
    }

    function updateRowNumbers() {
        let tableBody = document.getElementById('phase-body');
        Array.from(tableBody.rows).forEach((row, index) => {
            row.querySelector('.row-number').textContent = index + 1;
        });
    }
</script>

<script>
    let supporterCounts = {0: 1};

    function addSupporterRow(rowIndex) {
        let tbody = document.getElementById('supporters-body');
        let supporterIndex = supporterCounts[rowIndex]++;

        let newRow = document.createElement('tr');
        newRow.innerHTML = `
            <td class="row-number"></td>
            <td><input type="text" name="budget[${rowIndex}][supporters][${supporterIndex}][name]" class="form-control"></td>
            <td><input type="number" name="budget[${rowIndex}][supporters][${supporterIndex}][amount]" class="form-control"></td>
            <td><input type="number" name="budget[${rowIndex}][supporters][${supporterIndex}][percent]" class="form-control"></td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeSupporterRow(this)">حذف</button>
            </td>
        `;

        tbody.appendChild(newRow);
        updateSupporterRowNumbers();
    }

    function removeSupporterRow(button) {
        button.closest('tr').remove();
        updateSupporterRowNumbers();
    }

    function updateSupporterRowNumbers() {
        let rows = document.querySelectorAll('#supporters-body tr');
        rows.forEach((row, index) => {
            row.querySelector('.row-number').textContent = index + 1;
        });
    }
</script>


<script>
    let depenseIndex = 1; 
    function addDepensesRow() {
        let tableBody = document.getElementById('depenses-body');
        let newRow = document.createElement('tr');

        newRow.innerHTML = `
            <td class="row-number">${tableBody.rows.length + 1}</td> 
            <td data-label="الفقرات">
                <input type="text" name="depenses[${depenseIndex}][libelle_depense]" class="form-control" maxlength="200">
            </td>
            <td data-label="مستلزمات الفقرات">
                <input type="text" name="depenses[${depenseIndex}][description]" class="form-control">
            </td>
            <td data-label="التكلفة (د)">
                <input type="number" name="depenses[${depenseIndex}][cout]" class="form-control" maxlength="100">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeDepensesRow(this)">حذف</button>
            </td>
        `;

        tableBody.appendChild(newRow);
        depenseIndex++;
        updateDepensesRowNumbers();
    }

    function removeDepensesRow(button) {
        let row = button.closest('tr');
        row.remove();
        updateDepensesRowNumbers();
    }

    function updateDepensesRowNumbers() {
        let tableBody = document.getElementById('depenses-body');
        Array.from(tableBody.rows).forEach((row, index) => {
            row.querySelector('.row-number').textContent = index + 1;
        });
    }
</script>

@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif

