@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
<style>
    /* Styles pour le stepper */
    .stepper-wrapper {
        margin-top: 20px;
        margin-bottom: 20px;
    }
    
    .step-content {
        display: none;
    }
    
    .step-content.active {
        display: block;
    }
    
    .stepper-nav {
        display: flex;
        justify-content: space-between;
        margin-top: 20px;
        padding: 10px;
    }
    
    .step-indicator {
        text-align: center;
        margin-bottom: 20px;
        direction: rtl;
    }
    
    .step-indicator span {
        display: inline-block;
        margin: 0 10px;
        padding: 5px 15px;
        background-color: #f8f9fa;
        border-radius: 15px;
    }
    
    .step-indicator span.active {
        background-color: #007bff;
        color: white;
    }
    /* Taille des boutons réduite */
    .form-group button,
    .form-group a {
        min-width: 140px;
        font-weight: bold;
        border: none;
        border-radius: 8px;
        font-size: 14px;
        padding: 6px 10px;
        box-shadow: 0 3px 6px rgba(0,0,0,0.1);
        transition: all 0.2s ease-in-out;
    }

    .form-group button:hover,
    .form-group a:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    /* Dégradé orange pour "حفظ كمسودة" */
    .btn-orange-gradient {
        background: linear-gradient(135deg, #ff9f43, #e96b05);
        color: #fff;
    }
    .btn-orange-gradient:hover {
        background: linear-gradient(135deg, #ffa94d, #ff7b1a);
    }

    /* Bouton Retour bleu */
    .btn-primary {
        background-color: #007bff;
    }
    .btn-primary:hover {
        background-color: #0069d9;
    }

    /* Responsive - garder même ligne si possible */
    @media (max-width: 768px) {
        .form-group .d-flex {
            flex-wrap: wrap;
            justify-content: center;
        }
        .form-group button,
        .form-group a {
            min-width: 120px;
            font-size: 13px;
            padding: 5px 8px;
        }
    }
	
	    .text-danger2 {
    color: #dc3545;
    font-size: 15px;
    margin-top: 4px;
    display: block;
    font-weight: 600;
}

.is-invalid {
    border-color: #dc3545 !important;
    background-color: #fff5f5 !important;
}

.is-invalid:hover {
    border-color: #ff0000 !important;
    background-color: #ffe8e8 !important;
}
</style>
@endsection

@section('content')
<script>
let currentStep = 1;
const totalSteps = 3;

function showStep(step) {
    // Cacher tous les contenus
    document.querySelectorAll('.step-content').forEach(content => {
        content.classList.remove('active');
    });
    
    // Afficher le contenu actuel
    document.querySelector(`#step${step}`).classList.add('active');
    
    // Mettre à jour les indicateurs
    document.querySelectorAll('.step-indicator span').forEach(indicator => {
        indicator.classList.remove('active');
    });
    document.querySelector(`#step${step}-indicator`).classList.add('active');
    
    // Gérer l'affichage des boutons
    document.getElementById('prevBtn').style.display = step === 1 ? 'none' : 'block';
    document.getElementById('nextBtn').textContent = step === totalSteps ? 'إنهاء' : 'التالي';
}

function nextStep() {
    if (currentStep < totalSteps) {
        currentStep++;
        showStep(currentStep);
    } else {
        // Si on est à la dernière étape, soumettre le formulaire
        document.querySelector('form').submit();
    }
}

function prevStep() {
    if (currentStep > 1) {
        currentStep--;
        showStep(currentStep);
    }
}

// Initialiser le stepper
document.addEventListener('DOMContentLoaded', () => {
    showStep(1);
});
</script>

@if(Auth::check())
<div class="salle-sport-edit">


<div class="it-about-3-area p-relative pt-30 pb-125">
                <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
                <div class="container">
				 <nav class="breadcrumb-nav" aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('dashboard') }}">
                                <i class="bi bi-house-fill"></i>
                                <span>الرئيسية</span>
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('doc_fin.index') }}">
                                
                                <span>تمويل الجمعيات </span>
                            </a>
                        </li>
                        
                        <li class="breadcrumb-item active" aria-current="page">   استمارة تمويل الجمعيات  </li>
                    </ol>
                </nav>
                 
            <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">



<form action="{{ route('financement.storeAll') }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
    <div class="stepper-wrapper">
        <div class="step-indicator">
            <span class="active" id="step1-indicator">الخطوة 1</span>
            <span id="step2-indicator">الخطوة 2</span>
            <span id="step3-indicator">الخطوة 3</span>
        </div>

    <div id="step1" class="step-content active">
        <div class="container" lang="ar" dir="rtl">
                        <input type="hidden" name="id_association" value="{{ $association->id_association ?? '' }}">
                        <input type="hidden" name="id_demande" value="{{ $demande_id ?? '' }}">
                        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">

                        <h2 class="text-center">الجمهورية التونسية</h2>
                        <h3 class="text-center">وزارة شؤون الشباب و الرياضة</h3>
                        <h4 class="text-center mt-4">اللجنة الفنية للنظر في مطالب التمويل العمومي</h4>

                        <div class="card mt-4 shadow-sm">
                            <div class="card-header text-center bg-white">
                                <div class="row mb-3 align-items-center">
                                    <label  style="color:black;"    class="col-sm-3 col-form-label">إسم الجمعية</label>
                                    <div class="col-sm-9">
<input type="text" name="nom_association"
                                            class="form-control step1-field @error('nom_association') is-invalid @enderror"
                                            value="{{ old('nom_association', $association->nom_association ?? '') }}">
                                        @error('nom_association')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror                                    </div>
                                </div>
                            </div>
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0">{{ $formulaire->type_ar }}</h5>
                                
                            </div>
                            <div class="card-body">
                                <div class="row">

                                 @php
        // valeurs précédentes : priorise old(), sinon selectedTypes fourni par le contrôleur
        $oldTypes = old('types_financement', $selectedTypes ?? []);
        if (!is_array($oldTypes)) {
            $oldTypes = [];
        }
        $hasTypesError = $errors->has('types_financement');
    @endphp


                                    @foreach($type_financement as $type)
        <div class="col-md-4 col-sm-6 mb-2 text-center">
            <div class="form-check d-flex justify-content-start" dir="rtl">
                <input
                    class="form-check-input me-2 text-center step1-field {{ $hasTypesError ? 'is-invalid' : '' }}"
                    type="checkbox" require
                    name="types_financement[]"
                    value="{{ $type->id_type_fin }}"
                    {{ in_array($type->id_type_fin, $oldTypes) ? 'checked' : '' }}>
                <label class="col-sm-12 col-form-label" style="color:black;">
                    {{ $type->type_ar }}
                </label>
            </div>
        </div>
    @endforeach
                                </div>

                                @if($errors->has('types_financement'))
    <small class="text-danger2 d-block mt-1">{{ $errors->first('types_financement') }}</small>
@endif

                            </div>
                        </div>

                        <div class="card mt-4 shadow-sm">
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0">المعطيات الخاصة بالجمعية</h5>
                            </div>
                            <div class="card-body">
                                <div class="row mb-3 align-items-center">
                                    <label style="color:black;" class="col-sm-3 col-form-label">عنوان الجمعية</label>
                                    <div class="col-sm-9">
                                        <input type="text" name="adresse"
                                            class="form-control step1-field @error('adresse') is-invalid @enderror"
                                            value="{{ old('adresse', $association->adresse ?? '') }}">
                                        @error('adresse')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">الترقيم البريدي</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="code_postal"
                                            class="form-control step1-field @error('code_postal') is-invalid @enderror"
                                            value="{{ old('code_postal', $association->code_postal ?? '') }}">
                                        @error('code_postal')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">الهاتف</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="tel"
                                            class="form-control step1-field @error('tel') is-invalid @enderror"
                                            value="{{ old('tel', $association->tel ?? '') }}">
                                        @error('tel')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">الفاكس</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="fax" class="form-control step1-field" value="{{ old('fax', $association->fax ?? '') }}" >
                                    @error('fax')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">تاريخ التأسيس</label>
                                    <div class="col-sm-4">
                                        <input type="date" name="date_creation" class="form-control step1-field" value="{{ old('date_creation', $association->date_creation ?? '') }}" >
                                     @error('date_creation')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                    
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">رقم التأشيرة</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_visa" class="form-control step1-field" value="{{ old('num_visa', $association->num_visa ?? '') }}" >
                                    @error('num_visa')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">تاريخ التأشيرة</label>
                                    <div class="col-sm-4">
                                        <input type="date" name="date_visa" class="form-control step1-field" value="{{ old('date_visa', $association->date_visa ?? '') }}" >
                                    @error('date_visa')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">رقم المعرف الجبائي</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="num_identification_fiscale"
                                            class="form-control step1-field @error('num_identification_fiscale') is-invalid @enderror"
                                            value="{{ old('num_identification_fiscale', $association->num_identification_fiscale ?? '') }}">
                                        @error('num_identification_fiscale')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">رقم الحساب الجاري</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_compte_courant"
                                            class="form-control step1-field @error('num_compte_courant') is-invalid @enderror"
                                            value="{{ old('num_compte_courant', $association->num_compte_courant ?? '') }}">
                                        @error('num_compte_courant')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">البنك</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="banque"
                                            class="form-control step1-field @error('banque') is-invalid @enderror"
                                            value="{{ old('banque', $association->banque ?? '') }}">
                                        @error('banque')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">البريد الإلكتروني</label>
                                    <div class="col-sm-4">
                                        <input type="email" name="adresse_mail"
                                            class="form-control step1-field @error('adresse_mail') is-invalid @enderror"
                                            value="{{ old('adresse_mail', $association->adresse_mail ?? '') }}">
                                        @error('adresse_mail')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">عنوان موقع الواب</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="adresse_site_internet"
                                            class="form-control step1-field @error('adresse_site_internet') is-invalid @enderror"
                                            value="{{ old('adresse_site_internet', $association->adresse_site_internet ?? '') }}">
                                        @error('adresse_site_internet')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">إسم رئيس الجمعية</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="nom_president_association"
                                            class="form-control step1-field @error('nom_president_association') is-invalid @enderror"
                                            value="{{ old('nom_president_association', $association->nom_president_association ?? '') }}">
                                        @error('nom_president_association')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">الهاتف الشخصي</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="tel_personnel"
                                            class="form-control step1-field @error('tel_personnel') is-invalid @enderror"
                                            value="{{ old('tel_personnel', $association->tel_personnel ?? '') }}">
                                        @error('tel_personnel')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">عدد أعضاء المكتب الوطني للجمعية</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_membre_bureau_national_a"
                                            class="form-control step1-field @error('num_membre_bureau_national_a') is-invalid @enderror"
                                            value="{{ old('num_membre_bureau_national_a', $association->num_membre_bureau_national_a ?? '') }}">
                                        @error('num_membre_bureau_national_a')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">عدد المكاتب الجهوية ان وجدت</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_bureaux_regionaux"
                                            class="form-control step1-field @error('num_bureaux_regionaux') is-invalid @enderror"
                                            value="{{ old('num_bureaux_regionaux', $association->num_bureaux_regionaux ?? '') }}">
                                        @error('num_bureaux_regionaux')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">عدد المنخرطين الاجمالي</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_total_membre"
                                            class="form-control step1-field @error('num_total_membre') is-invalid @enderror"
                                            value="{{ old('num_total_membre', $association->num_total_membre ?? '') }}">
                                        @error('num_total_membre')
                                            <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            
        </div>
    <div id="step2" class="step-content">
        <div class="container" lang="ar" dir="rtl">
                    <input type="hidden" name="id_formulaire" value="{{ $formulaire2->id_type }}">
                    <input type="hidden" name="id_demande" value="{{ $demande_id }}">
                    <h2 class="text-center">الجمهورية التونسية</h2>
                    <h2 class="text-center">وزارة الشباب و الرياضة</h2>
                    <h3 class="text-center" style="font-size:25px;">{{ $formulaire2->type_ar }}</h3>
                    <h4 class="text-center pt-3">جذاذة فنية</h4>
                    <br>

                    <div class="form-section">
                        <h4>  المعطيات البيداغوجية</h4>
                        <div class="form-group row mb-3"  style="padding-top:20px;">
                            <label class="col-sm-2 col-form-label"> اسم و لقب المشرف على التنفيذ </label>
                            <div class="col-sm-4">
                                <input type="text"
                                    class="form-control step2-field @error('nom_prenom_sup') is-invalid @enderror"
                                    name="nom_prenom_sup"
                                    placeholder="الاسم و اللقب"
                                    maxlength="100"
                                    value="{{ old('nom_prenom_sup') }}">
                                @error('nom_prenom_sup')
                                    <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                @enderror
                            </div>
                            <label class="col-sm-2 col-form-label">  المهنة </label>
                            <div class="col-sm-4">
                                <input type="text"
                                    class="form-control step2-field @error('profession_sup') is-invalid @enderror"
                                    name="profession_sup"
                                    placeholder="المهنة"
                                    maxlength="100"
                                    value="{{ old('profession_sup') }}">
                                @error('profession_sup')
                                    <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row align-items-center">
                            <label class="col-sm-2 col-form-label"> الصفة في الجمعية</label>  
                            <div class="col-sm-4">
                                <input type="text"
                                    class="form-control step2-field @error('role_sup') is-invalid @enderror"
                                    name="role_sup"
                                    placeholder="الصفة"
                                    maxlength="100"
                                    value="{{ old('role_sup') }}">
                                @error('role_sup')
                                    <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                @enderror
                            </div>
                            <label class="col-sm-2 col-form-label">  الهاتف </label>
                            <div class="col-sm-4">
                                <input type="text"
                                    class="form-control step2-field @error('tel_sup') is-invalid @enderror"
                                    name="tel_sup"
                                    maxlength="12"
                                    value="{{ old('tel_sup') }}">
                                @error('tel_sup')
                                    <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">  البريد الالكتروني </label>
                            <div class="col-sm-4">
                                <input type="email"
                                    class="form-control step2-field @error('email_sup') is-invalid @enderror"
                                    name="email_sup"
                                    value="{{ old('email_sup') }}">
                                @error('email_sup')
                                    <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label"> اسم المشروع / التظاهرة / النشاط </label>
                            <div class="col-sm-10">
                                <input type="text"
                                    class="form-control step2-field @error('nom_projet') is-invalid @enderror"
                                    name="nom_projet"
                                    maxlength="255"
                                    value="{{ old('nom_projet') }}">
                                @error('nom_projet')
                                    <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">مبررات الانجاز</label>
                            <div class="col-sm-10">
                                <textarea class="form-control step2-field @error('justification_realisation') is-invalid @enderror"
                                        name="justification_realisation"
                                        maxlength="255"
                                        rows="4"
                                        placeholder="ادخل مبررات الانجاز">{{ old('justification_realisation') }}</textarea>
                                @error('justification_realisation')
                                    <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">الاهداف</label>
                            <div class="col-sm-10">
                                <textarea class="form-control step2-field @error('objectives') is-invalid @enderror"
                                        name="objectives"
                                        rows="4"
                                        placeholder="ادخل الاهداف">{{ old('objectives') }}</textarea>
                                @error('objectives')
                                    <small class="text-danger2 d-block mb-1">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">وصف الفقرات أو المراحل</label>
</div>

<div class="form-group row" style="direction: rtl; text-align: right;">
    <table id="phase-table" class="table table-bordered text-center align-middle shadow-sm">
        <thead class="table-success">
            <tr>
                <th style="width:5%">#</th>
                <th style="width:35%">أهم الفقرات أو المراحل</th>
                <th style="width:20%">تاريخ الإنجاز</th>
                <th style="width:30%">مكان الإنجاز</th>
                <th style="width:10%">إجراء</th>
            </tr>
        </thead>

        @php
$oldPhases = old('phases', []);

// Si oldPhases est vide ou toutes les lignes sont vides, alors on initialise avec une ligne vide
$allEmpty = true;
if (is_array($oldPhases) && count($oldPhases) > 0) {
    foreach($oldPhases as $phase) {
        if (!empty($phase['description']) || !empty($phase['completion_date']) || !empty($phase['completion_location'])) {
            $allEmpty = false;
            break;
        }
    }
}

if (!is_array($oldPhases) || count($oldPhases) === 0 || $allEmpty) {
    $oldPhases = [
        ['description' => '', 'completion_date' => '', 'completion_location' => '']
    ];
}
@endphp
        <tbody id="phase-body">
            @foreach($oldPhases as $i => $p)
                <tr>
                    
<td class="row-number fw-bold">{{ (int)$i + 1 }}</td>
                    <td>
                        <input type="text"
                               name="phases[{{ $i }}][description]"
                               class="form-control step2-field @error("phases.{$i}.description") is-invalid @enderror"
                               placeholder="أدخل الفقرة"
                               maxlength="200"
                               value="{{ old("phases.{$i}.description", $p['description'] ?? '') }}">
                        @if($errors->has("phases.{$i}.description"))
                            <small class="text-danger2 d-block mt-1">{{ $errors->first("phases.{$i}.description") }}</small>
                        @endif
                    </td>

                    <td>
                        <input type="date"
                               name="phases[{{ $i }}][completion_date]"
                               class="form-control step2-field @error("phases.{$i}.completion_date") is-invalid @enderror"
                               value="{{ old("phases.{$i}.completion_date", $p['completion_date'] ?? '') }}">
                        @if($errors->has("phases.{$i}.completion_date"))
                            <small class="text-danger2 d-block mt-1">{{ $errors->first("phases.{$i}.completion_date") }}</small>
                        @endif
                    </td>

                    <td>
                        <input type="text"
                               name="phases[{{ $i }}][completion_location]"
                               class="form-control step2-field @error("phases.{$i}.completion_location") is-invalid @enderror"
                               placeholder="أدخل المكان"
                               maxlength="100"
                               value="{{ old("phases.{$i}.completion_location", $p['completion_location'] ?? '') }}">
                        @if($errors->has("phases.{$i}.completion_location"))
                            <small class="text-danger2 d-block mt-1">{{ $errors->first("phases.{$i}.completion_location") }}</small>
                        @endif
                    </td>

                    <td class="text-center action-buttons" style="white-space: nowrap;">
                        <div class="d-flex gap-2 justify-content-center align-items-center">
                            <button type="button" class="btn btn-outline-danger btn-circle" onclick="removePhaseRow(this)" title="حذف">
                                <i class="bx bx-trash fs-5"></i>
                            </button>
                            <button type="button" class="btn btn-outline-success btn-circle" onclick="addPhaseRow()" title="إضافة">
                                <i class="bx bx-plus fs-5"></i>
                            </button>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
<script>
function addPhaseRow() {
    const tbody = document.getElementById('phase-body');
    const rowCount = tbody.rows.length;

    const newRow = document.createElement('tr');
    newRow.innerHTML = `
        <td class="row-number fw-bold">${rowCount + 1}</td>
        <td><input type="text" name="phases[${rowCount}][description]" class="form-control step2-field" placeholder="أدخل الفقرة" maxlength="200"></td>
        <td><input type="date" name="phases[${rowCount}][completion_date]" class="form-control step2-field"></td>
        <td><input type="text" name="phases[${rowCount}][completion_location]" class="form-control step2-field" placeholder="أدخل المكان" maxlength="100"></td>
        <td class="text-center action-buttons" style="white-space: nowrap;">
            <div class="d-flex gap-2 justify-content-center align-items-center">
                <button type="button" class="btn btn-outline-danger btn-circle" onclick="removePhaseRow(this)" title="حذف">
                    <i class="bx bx-trash fs-5"></i>
                </button>
                <button type="button" class="btn btn-outline-success btn-circle" onclick="addPhaseRow()" title="إضافة">
                    <i class="bx bx-plus fs-5"></i>
                </button>
            </div>
        </td>
    `;
    tbody.appendChild(newRow);
}


function removePhaseRow(button) {
    const row = button.closest('tr');
    const tbody = row.closest('tbody');
    row.remove();
    updatePhaseRowNumbers();
}

function updatePhaseRowNumbers() {
    const tbody = document.getElementById('phase-body');
    // mettre à jour les numéros visibles
    [...tbody.querySelectorAll('.row-number')].forEach((cell, i) => {
        cell.textContent = i + 1;
    });

    // renommer les name pour indices consécutifs (important pour la validation)
    [...tbody.querySelectorAll('tr')].forEach((tr, i) => {
        const desc = tr.querySelector('input[name*="[description]"]');
        if (desc) desc.name = `phases[${i}][description]`;
        const date = tr.querySelector('input[name*="[completion_date]"]');
        if (date) date.name = `phases[${i}][completion_date]`;
        const loc = tr.querySelector('input[name*="[completion_location]"]');
        if (loc) loc.name = `phases[${i}][completion_location]`;
    });
}

document.addEventListener('DOMContentLoaded', updatePhaseRowNumbers);
</script>






                        <div class="form-group row mb-3">
    <label class="col-sm-2 col-form-label">الجمهور المستفيد</label>
    <div class="col-sm-10">
        <input type="text" class="form-control step2-field @error('public') is-invalid @enderror"
               name="public"
               maxlength="255"
               value="{{ old('public', $association->public ?? '') }}">
        @error('public')
            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
        @enderror
    </div>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-2 col-form-label">العدد التقريبي للجمهور</label>
    <div class="col-sm-10">
        <input type="number" class="form-control step2-field @error('nombre_spectateur') is-invalid @enderror"
               name="nombre_spectateur"
               value="{{ old('nombre_spectateur', $association->nombre_spectateur ?? '') }}">
        @error('nombre_spectateur')
            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
        @enderror
    </div>
</div>

<div class="form-group row mb-3 align-items-center">
    <label class="col-sm-2 col-form-label">الشريحة العمرية المستهدفة</label>
    <div class="col-sm-5 d-flex align-items-center">
        <label class="col-form-label mb-0 me-3">من</label>
        <input type="number" class="form-control step2-field @error('tranch_age_min') is-invalid @enderror"
               name="tranch_age_min"
               value="{{ old('tranch_age_min', $association->tranch_age_min ?? '') }}">
        @error('tranch_age_min')
            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
        @enderror
    </div>

    <div class="col-sm-5 d-flex align-items-center">
        <label class="col-form-label mb-0 me-3">الى</label>
        <input type="number" class="form-control step2-field @error('tranch_age_max') is-invalid @enderror"
               name="tranch_age_max"
               value="{{ old('tranch_age_max', $association->tranch_age_max ?? '') }}">
        @error('tranch_age_max')
            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
        @enderror
    </div>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">الأطراف المشاركة في الإنجاز</label>
    <div class="col-sm-12">
        <textarea class="form-control step2-field @error('parties_realisation') is-invalid @enderror"
                  name="parties_realisation"
                  rows="4">{{ old('parties_realisation', $association->parties_realisation ?? '') }}</textarea>
        @error('parties_realisation')
            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
        @enderror
    </div>
</div>
                        <div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">النتائج المرتقب تحقيقها</label>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">1- النتائج الكمية</label>
    <div class="col-sm-12">
        <textarea class="form-control step2-field @error('resultat_quantitatif') is-invalid @enderror"
                  name="resultat_quantitatif"
                  rows="4">{{ old('resultat_quantitatif', $association->resultat_quantitatif ?? '') }}</textarea>
        @error('resultat_quantitatif')
            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
        @enderror
    </div>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">2- النتائج النوعية</label>
    <div class="col-sm-12">
        <textarea class="form-control step2-field @error('resultat_qualitatif') is-invalid @enderror"
                  name="resultat_qualitatif"
                  rows="4">{{ old('resultat_qualitatif', $association->resultat_qualitatif ?? '') }}</textarea>
        @error('resultat_qualitatif')
            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
        @enderror
    </div>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">الآفاق المنتظرة</label>
    <div class="col-sm-12">
        <textarea class="form-control step2-field @error('perspectives') is-invalid @enderror"
                  name="perspectives"
                  rows="4">{{ old('perspectives', $association->perspectives ?? '') }}</textarea>
        @error('perspectives')
            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
        @enderror
    </div>
</div>

                    </div>

<div class="form-section">
    <h4>الموازنة المالية</h4>
    <label class="col-sm-6 col-form-label">الميزانية التقديرية</label>

    <div class="form-group row">
        <table class="table table-bordered text-center align-middle shadow-sm">
            <thead class="table-success">
                <tr>
                    <th rowspan="2">الكلفة الجملية التقديرية<br>(المبلغ بالدينار التونسي)</th>
                    <th colspan="2">حجم التمويل الذاتي</th>
                    <th colspan="2">حجم الدعم المطلوب من الوزارة</th>
                </tr>
                <tr>
                    <th>النسبة المائوية</th>
                    <th>المبلغ بالدينار</th>
                    <th>المبلغ بالدينار</th>
                    <th>النسبة المائوية</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <input type="number" name="budget[0][total_cost]" 
                            class="form-control step2-field @error('budget.0.total_cost') is-invalid @enderror"
                            value="{{ old('budget.0.total_cost') }}">
                        @error('budget.0.total_cost')
                            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
                        @enderror
                    </td>
                    <td>
                        <input type="number" name="budget[0][self_percent]" 
                            class="form-control step2-field @error('budget.0.self_percent') is-invalid @enderror"
                            value="{{ old('budget.0.self_percent') }}">
                        @error('budget.0.self_percent')
                            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
                        @enderror
                    </td>
                    <td>
                        <input type="number" name="budget[0][self_amount]" 
                            class="form-control step2-field @error('budget.0.self_amount') is-invalid @enderror"
                            value="{{ old('budget.0.self_amount') }}">
                        @error('budget.0.self_amount')
                            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
                        @enderror
                    </td>
                    <td>
                        <input type="number" name="budget[0][ministry_amount]" 
                            class="form-control step2-field @error('budget.0.ministry_amount') is-invalid @enderror"
                            value="{{ old('budget.0.ministry_amount') }}">
                        @error('budget.0.ministry_amount')
                            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
                        @enderror
                    </td>
                    <td>
                        <input type="number" name="budget[0][ministry_percent]" 
                            class="form-control step2-field @error('budget.0.ministry_percent') is-invalid @enderror"
                            value="{{ old('budget.0.ministry_percent') }}">
                        @error('budget.0.ministry_percent')
                            <small class="text-danger2 d-block mt-1">{{ $message }}</small>
                        @enderror
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

     <label class="col-sm-6 col-form-label fw-bold">الأطراف المساهمة في الدعم</label>
    <div class="form-group row" style="direction: rtl; text-align: right;">
    <table id="supporters-table" class="table table-bordered align-middle text-center shadow-sm">
        <thead class="table-success">
            <tr>
                <th style="width: 5%">ع/ر</th>
                <th style="width: 35%">الطرف المساهم</th>
                <th style="width: 20%">المبلغ بالدينار</th>
                <th style="width: 20%">النسبة المائوية</th>
                <th style="width: 10%">إجراء</th>
            </tr>
        </thead>

        @php
        $oldSupporters = old('budget.0.supporters', []);
        if (!is_array($oldSupporters) || count($oldSupporters) === 0) {
            $oldSupporters = [
                ['name' => '', 'amount' => '', 'percent' => '']
            ];
        }
        @endphp

        <tbody id="supporters-body">
            @foreach($oldSupporters as $i => $s)
            <tr>
                <td class="row-number fw-bold">{{ $i + 1 }}</td>
                <td>
                    <input type="text" 
                           name="budget[0][supporters][{{ $i }}][name]" 
                           class="form-control step2-field @error("budget.0.supporters.$i.name") is-invalid @enderror" 
                           placeholder="اسم الطرف"
                           value="{{ old("budget.0.supporters.$i.name", $s['name'] ?? '') }}">
                    @if($errors->has("budget.0.supporters.$i.name"))
                        <small class="text-danger2 d-block mt-1">{{ $errors->first("budget.0.supporters.$i.name") }}</small>
                    @endif
                </td>
                <td>
                    <input type="number" 
                           name="budget[0][supporters][{{ $i }}][amount]" 
                           class="form-control step2-field @error("budget.0.supporters.$i.amount") is-invalid @enderror" 
                           placeholder="0.000"
                           value="{{ old("budget.0.supporters.$i.amount", $s['amount'] ?? '') }}">
                    @if($errors->has("budget.0.supporters.$i.amount"))
                        <small class="text-danger2 d-block mt-1">{{ $errors->first("budget.0.supporters.$i.amount") }}</small>
                    @endif
                </td>
                <td>
                    <input type="number" 
                           name="budget[0][supporters][{{ $i }}][percent]" 
                           class="form-control step2-field @error("budget.0.supporters.$i.percent") is-invalid @enderror" 
                           placeholder="%"
                           value="{{ old("budget.0.supporters.$i.percent", $s['percent'] ?? '') }}">
                    @if($errors->has("budget.0.supporters.$i.percent"))
                        <small class="text-danger2 d-block mt-1">{{ $errors->first("budget.0.supporters.$i.percent") }}</small>
                    @endif
                </td>
                <td class="text-center">
                    <div class="d-flex gap-2 justify-content-center align-items-center">
                        <button type="button" class="btn btn-outline-danger btn-circle" onclick="removeSupporter2Row(this)">
                            <i class="bx bx-x fs-5"></i>
                        </button>
                        <button type="button" class="btn btn-outline-success btn-circle" onclick="addSupporter2Row(0)">
                            <i class="bx bx-plus fs-5"></i>
                        </button>
                    </div>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<script>
function addSupporter2Row(index) {
    const tbody = document.getElementById('supporters-body');
    const rowCount = tbody.rows.length;
    const newRow = document.createElement('tr');

    newRow.innerHTML = `
        <td class="row-number fw-bold">${rowCount + 1}</td>
        <td><input type="text" name="budget[${index}][supporters][${rowCount}][name]" class="form-control step2-field" placeholder="اسم الطرف"></td>
        <td><input type="number" name="budget[${index}][supporters][${rowCount}][amount]" class="form-control step2-field" placeholder="0.000"></td>
        <td><input type="number" name="budget[${index}][supporters][${rowCount}][percent]" class="form-control step2-field" placeholder="%"></td>
        <td class="text-center">
            <div class="d-flex gap-2 justify-content-center align-items-center">
                <button type="button" class="btn btn-outline-danger btn-circle" onclick="removeSupporter2Row(this)">
                    <i class="bx bx-x fs-5"></i>
                </button>
                <button type="button" class="btn btn-outline-success btn-circle" onclick="addSupporter2Row(${index})">
                    <i class="bx bx-plus fs-5"></i>
                </button>
            </div>
        </td>
    `;
    tbody.appendChild(newRow);
}

function removeSupporter2Row(button) {
    const row = button.closest('tr');
    const tbody = row.closest('tbody');
    row.remove();

    // Mise à jour des numéros visibles et des indices
    [...tbody.querySelectorAll('tr')].forEach((tr, i) => {
        tr.querySelector('.row-number').textContent = i + 1;
        tr.querySelector('input[name*="[name]"]').name = `budget[0][supporters][${i}][name]`;
        tr.querySelector('input[name*="[amount]"]').name = `budget[0][supporters][${i}][amount]`;
        tr.querySelector('input[name*="[percent]"]').name = `budget[0][supporters][${i}][percent]`;
    });
}
</script>

</div>

                        <label class="col-sm-6 col-form-label fw-bold">أبواب صرف الميزانية</label>

<div class="form-group row" style="direction: rtl; text-align: right;">
    <table id="depenses-table" class="table table-bordered text-center align-middle shadow-sm">
        <thead class="table-success">
            <tr>
                <th style="width:5%">#</th>
                <th style="width:30%">الفقرات</th>
                <th style="width:30%">مستلزمات الفقرات</th>
                <th style="width:20%">التكلفة (د)</th>
                <th style="width:5%">إجراء</th>
            </tr>
        </thead>

        @php
        $oldDepenses = old('depenses', []);
        if (!is_array($oldDepenses) || count($oldDepenses) === 0) {
            $oldDepenses = [
                ['libelle_depense' => '', 'description' => '', 'cout' => '']
            ];
        }
        @endphp

        <tbody id="depenses-body">
            @foreach($oldDepenses as $i => $d)
            <tr>
                <td class="row-number fw-bold">{{ $i + 1 }}</td>

                <td>
                    <input type="text" 
                           name="depenses[{{ $i }}][libelle_depense]" 
                           class="form-control step2-field @error("depenses.$i.libelle_depense") is-invalid @enderror" 
                           placeholder="أدخل الفقرة" 
                           value="{{ old("depenses.$i.libelle_depense", $d['libelle_depense'] ?? '') }}">
                    @if($errors->has("depenses.$i.libelle_depense"))
                        <small class="text-danger2 d-block mt-1">{{ $errors->first("depenses.$i.libelle_depense") }}</small>
                    @endif
                </td>

                <td>
                    <input type="text" 
                           name="depenses[{{ $i }}][description]" 
                           class="form-control step2-field @error("depenses.$i.description") is-invalid @enderror" 
                           placeholder="أدخل المستلزمات"
                           value="{{ old("depenses.$i.description", $d['description'] ?? '') }}">
                    @if($errors->has("depenses.$i.description"))
                        <small class="text-danger2 d-block mt-1">{{ $errors->first("depenses.$i.description") }}</small>
                    @endif
                </td>

                <td>
                    <input type="number" 
                           name="depenses[{{ $i }}][cout]" 
                           class="form-control step2-field @error("depenses.$i.cout") is-invalid @enderror" 
                           placeholder="0.000"
                           value="{{ old("depenses.$i.cout", $d['cout'] ?? '') }}">
                    @if($errors->has("depenses.$i.cout"))
                        <small class="text-danger2 d-block mt-1">{{ $errors->first("depenses.$i.cout") }}</small>
                    @endif
                </td>

                <td style="white-space: nowrap;">
                    <div class="d-flex gap-2 justify-content-center align-items-center">
                        <button type="button" class="btn btn-outline-danger btn-circle" onclick="removeDepenses2Row(this)">
                            <i class="bx bx-trash fs-5"></i>
                        </button>
                        <button type="button" class="btn btn-outline-success btn-circle" onclick="addDepenses2Row()">
                            <i class="bx bx-plus fs-5"></i>
                        </button>
                    </div>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<script>
function addDepenses2Row() {
    const tbody = document.getElementById('depenses-body');
    const rowCount = tbody.rows.length;
    const newRow = document.createElement('tr');

    newRow.innerHTML = `
        <td class="row-number fw-bold">${rowCount + 1}</td>
        <td><input type="text" name="depenses[${rowCount}][libelle_depense]" class="form-control step2-field" placeholder="أدخل الفقرة"></td>
        <td><input type="text" name="depenses[${rowCount}][description]" class="form-control step2-field" placeholder="أدخل المستلزمات"></td>
        <td><input type="number" name="depenses[${rowCount}][cout]" class="form-control step2-field" placeholder="0.000"></td>
        <td class="text-center action-buttons">
            <div class="d-flex gap-2 justify-content-center align-items-center">
                <button type="button" class="btn btn-outline-danger btn-circle" onclick="removeDepenses2Row(this)">
                    <i class="bx bx-x fs-5"></i>
                </button>
                <button type="button" class="btn btn-outline-success btn-circle" onclick="addDepenses2Row()">
                    <i class="bx bx-plus fs-5"></i>
                </button>
            </div>
        </td>
    `;
    tbody.appendChild(newRow);
}

function removeDepenses2Row(button) {
    const row = button.closest('tr');
    const tbody = row.closest('tbody');
    row.remove();

    [...tbody.querySelectorAll('.row-number')].forEach((cell, i) => {
        cell.textContent = i + 1;
    });

    // Renommer les inputs pour garder les indices consécutifs
    [...tbody.querySelectorAll('tr')].forEach((tr, i) => {
        tr.querySelector('input[name*="[libelle_depense]"]').name = `depenses[${i}][libelle_depense]`;
        tr.querySelector('input[name*="[description]"]').name = `depenses[${i}][description]`;
        tr.querySelector('input[name*="[cout]"]').name = `depenses[${i}][cout]`;
    });
}
</script>
<style>
    /* Table design */
#depenses-table {
    background: #fff;
    border-radius: 10px;
    overflow: hidden;
}
#depenses-table th {
    background: #e9f7ef;
    font-weight: 600;
    color: #333;
    vertical-align: middle;
}
#depenses-table td {
    vertical-align: middle;
}

/* Boutons circulaires */
.btn-circle {
    border-radius: 50%;
    width: 36px;
    height: 36px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    margin: 0 3px;
    transition: all 0.2s ease-in-out;
}

/* Supprimer : rouge */
.btn-outline-danger.btn-circle {
    color: #fff;
    border-color: #dc3545;
}
.btn-outline-danger.btn-circle:hover {
    background-color: #dc3545;
    color: #fff;
}

/* Ajouter : vert */
.btn-outline-success.btn-circle {
    color: #fff;
    border-color: #28a745;
}
.btn-outline-success.btn-circle:hover {
    background-color: #28a745;
    color: #fff;
}

/* Inputs */
#depenses-table input {
    border-radius: 8px;
}

</style>
                        <span>
                            (1) :  مستلزمات كل فقرة على حدة مثلا / مستلزمات الندوة او المعرض او الورشة او العرض 
                        </span>
                    </div>
            </div>
     


   
    <div id="step3" class="step-content">
        <div class="container" lang="ar" dir="rtl">
            @php
                $form1_complete = $form1_complete ?? false;
                $form2_complete = $form2_complete ?? false;
            @endphp

            <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">
            <input type="hidden" name="id_projet" value="{{ $id_projet }}">
            <h2 class="text-center">الجمهورية التونسية</h2>
            <h2 class="text-center">وزارة الشباب و الرياضة</h2>
            <h3 class="text-center" style="font-size:25px;">{{ $formulaire3->type_ar }}</h3>
            <br>
            <div class="form-section">
                <div class="form-group row">
                    <table id="phase-table" class="custom-table table table-bordered text-center">
                        <thead>
                            <tr>
                                <th>#</th> 
                                <th> الوثائق حسب الامر عدد 5183 </th>
                                <th> الوثائق </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($typedocum as $index => $doc)
                            <tr>
                                <td class="row-number">{{ $index + 1 }}</td>
                                
                                <td data-label="الوثائق حسب الامر عدد 5183">
                                    {{ $doc->type_ar }}
                                    <input type="hidden" name="doc_fin[{{ $index }}][id_doc]" value="{{ $doc->id_type_doc }}">
                                </td>

                                <td data-label="الوثائق">
                                    @php
                                        $docExist = $documents->where('id_doc', $doc->id_type_doc)->first();
                                    @endphp

                                    @if($doc->id_type_doc == 15)
                                        <span class="doc-status" data-step="2">⚠️ يجب إتمام تعبئة الخطوة الثانية أولاً</span>
                                    
                                    @elseif($doc->id_type_doc == 16)
                                        <div style="display:flex; align-items:center; gap:10px;">
                                            <a href="{{ asset('storage/documents_financement/التزام_وتصريح_على_الشرف.pdf') }}" 
                                            target="_blank" 
                                            class="btn btn-sm btn-secondary" 
                                            title="Télécharger le document">
                                                📤
                                            </a>
                                            

                                            <input type="file" 
                                            name="doc_fin[{{ $index }}][file]" 
                                            class="form-control @error("doc_fin.$index.file") is-invalid @enderror" style="flex:1">

                                            @error("doc_fin.$index.file")
                                                <small class="text-danger d-block mt-1">{{ $message }}</small>
                                            @enderror
                                        </div>

                                    @elseif($doc->id_type_doc == 17)
                                        <span class="doc-status" data-step="1">⚠️ يجب إتمام تعبئة الخطوة الأولى أولاً</span>

                                    @else
                                        <input type="file" 
                                            name="doc_fin[{{ $index }}][file]" 
                                            class="form-control @error("doc_fin.$index.file") is-invalid @enderror">

                                        @error("doc_fin.$index.file")
                                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                                        @enderror
                                    @endif

                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="stepper-nav">
        <button type="button" class="btn btn-primary" id="prevBtn" style="display: none;" onclick="prevStep()">السابق</button>
        <button type="button" class="btn btn-primary" id="nextBtn" onclick="nextStep()">التالي</button>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    function checkStepComplete(stepClass) {
        let allFilled = true;
        document.querySelectorAll(stepClass).forEach(input => {
            if (input.value.trim() === '') {
                allFilled = false;
            }
        });
        return allFilled;
    }

    function updateDocMessages() {
        document.querySelectorAll('.doc-status').forEach(el => {
            const step = el.getAttribute('data-step');
            if (step === '1' && checkStepComplete('.step1-field')) {
                el.textContent = '✅ هذا الملف متوفر بالفعل';
                el.style.color = 'green';
            } 
            else if (step === '2' && checkStepComplete('.step2-field')) {
                el.textContent = '✅ هذا الملف متوفر بالفعل';
                el.style.color = 'green';
            } 
            else if (step === '1') {
                el.textContent = '⚠️ يجب إتمام الخطوة الأولى أولاً';
                el.style.color = 'red';
            } 
            else if (step === '2') {
                el.textContent = '⚠️ يجب إتمام الخطوة الثانية أولاً';
                el.style.color = 'red';
            }
        });
    }

    document.querySelectorAll('.step1-field, .step2-field').forEach(input => {
        input.addEventListener('input', updateDocMessages);
    });

    updateDocMessages();
});
</script>


    
    <div class="form-group text-center mt-5">
        <input type="hidden" id="brouillon" name="brouillon" value="0">

        <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
            <!-- Enregistrer -->
            <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill"
                    onclick="document.getElementById('brouillon').value = 0;">
                <i class="bx bx-save"></i> حفظ
            </button>

            <!-- Enregistrer comme brouillon -->
            <button type="submit" class="btn btn-orange-gradient text-white d-flex align-items-center justify-content-center gap-1 flex-fill"
                    onclick="document.getElementById('brouillon').value = 1;">
                <i class="bx bx-edit-alt"></i> حفظ كمسودة
            </button>

            
        </div>
    </div>

<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

   <div id="global-block-msg" class="alert alert-danger" style="display:none">
        يوجد مستندات مفقودة أو يلزم تعبئة خطوات سابقة — لن يتم حفظ الطلب حتى تكتمل الشروط.
    </div>   
</div>  
</form>
</div>
</div>
@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif

