@extends('layouts.app')

@section('content')


            <div class="it-about-3-area p-relative pt-30 pb-125">
                <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
                <div class="container">
                    <nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('doc_fin.index') }}">
                <span>تمويل الجمعيات</span>
            </a>
        </li>
       
        <li class="breadcrumb-item active" aria-current="page">المسوّدات</li>
    </ol>
</nav>
            <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">


                    <div class="row">
                        <div class="col-xl-12">
                            <div class="it-section-title-box text-center mb-30" style="padding-top:20px;">
                                <span class="it-section-subtitle">وثائق التمويل العمومي</span>
                                <h4 class="it-section-title it-split-in-right mb-0"> المسوّدات </h4>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-10">
                            <div class="card shadow-sm p-4">

                                


                                @if(session('success'))
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        {{ session('success') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @endif

                                   <div class="my-table table-responsive">
                                     <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                                        <thead class="thead-light">
                                           <tr>
                                                <th>المعرف</th>
                                                <th>إسم المشروع</th>
                                                <th>إسم المشرف</th>
                                                <th>إجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($documents as $index => $doc)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $doc->projet?->nom_projet ?? '---' }}</td>
                                                <td>{{ $doc->projet?->superviseur?->nom_prenom_sup ?? '---' }}</td>
                                                @php $s1 = $doc->id_statut1 ?? 2; @endphp
                                                

                                                <td style="white-space: nowrap; vertical-align: middle;">
                                                    <div class="d-flex gap-2 justify-content-center align-items-center">
                                                        <a href="{{ route('doc_fin.brouillons.show', $doc->id_doc_list) }}"
                                                        class="btn-icon btn-icon--info"
                                                        title="عرض" aria-label="عرض">
                                                            <i class="la la-eye"></i>
                                                        </a>

                                                        @if($doc->id_statut1 == 2)
                                                            <button type="button" 
                                                                    class="btn-icon btn-icon--warning"
																	onclick="window.location='{{ route('doc_fin.brouillons.edit', $doc->id_doc_list) }}'"
                                                                    title="تعديل" aria-label="تعديل">
                                                                <i class="la la-edit"></i>
                                                            </button>

                                                            <form action="" method="POST" class="d-inline m-0 p-0">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="button"
                                                                        onclick="confirmDelete(this.closest('form'))"
                                                                        class="btn-icon btn-icon--danger"
                                                                        title="حذف" aria-label="حذف">
                                                                    <i class="la la-trash"></i>
                                                                </button>
                                                            </form>
                                                        @endif
                                                    </div>
                                                </td>

                                            </tr>
                                            @empty
                                            <tr>
                                                <td colspan="5" class="text-center">لا توجد وثائق حالياً</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>


                                <div class="mt-3">
                                    {{ $documents->links('pagination::bootstrap-5') }}
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
 

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function confirmEdit(url) {
        Swal.fire({
            title: 'هل تريد حقًا تعديل هذه الوثيقة ؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    }

    function confirmDelete(form) {
        Swal.fire({
            title: 'هل تريد حذف هذه الوثيقة؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }
</script>
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

<script src="{{ asset('assets/js/index.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
@endsection
