<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Éditeur GrapesJS - {{ $pageTitle ?? 'Page' }}</title>

  <link href="https://unpkg.com/grapesjs/dist/css/grapes.min.css" rel="stylesheet"/>
  <style>
    body, html {height:100%; margin:0; font-family: Arial, sans-serif;}
    .topbar { padding:10px; background:#f5f5f5; display:flex; gap:10px; align-items:center; }
    #gjs { height: calc(100vh - 64px); border-top: 1px solid #ddd; }
    select, button { padding:6px 10px; }
  </style>
</head>
<body>
  <div class="topbar">
    <strong>Édition : </strong> <span style="margin-right:10px">{{ $pageTitle ?? '' }}</span>

    <select id="sections-list" style="min-width:220px;">
      <option value="">-- Choisir une section --</option>
    </select>

    <button id="btn-new">Nouvelle section</button>
    <button id="btn-load">Charger</button>
    <button id="btn-save">Sauver</button>

    <span id="status" style="margin-left:10px;color:green"></span>
  </div>

  <div id="gjs"></div>

  <!-- GrapesJS JS -->
  <script src="https://unpkg.com/grapesjs"></script>
  <script src="https://unpkg.com/grapesjs-preset-webpage"></script>

  <script>
    (function(){
      const apiBase = '/api';
      const pageId = {{ json_encode($pageId) }};
      const token = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
      let editor = grapesjs.init({
        container: '#gjs',
        height: '100%',
        fromElement: false,
        storageManager: { autoload: 0, autosave: 0 },
        plugins: ['gjs-preset-webpage'],
        pluginsOpts: {
          'gjs-preset-webpage': {}
        }
      });

      // Add simple blocks
      const bm = editor.BlockManager;
      bm.add('title', { label: 'Titre', content: '<h1>Mon titre</h1>' });
      bm.add('text', { label: 'Paragraphe', content: '<p>Paragraphe...</p>' });
      bm.add('image', { label: 'Image', content: '<img src="https://via.placeholder.com/300" />' });

      // Asset manager configure upload endpoint (server-side needed)
      editor.on('asset:upload:start', () => { console.log('upload started'); });
      editor.on('asset:upload:end', () => { console.log('upload finished'); });

      // Fill sections list for this page
      async function loadSectionsList() {
        if (!pageId) return;
        const res = await fetch(`${apiBase}/pages/${pageId}/sections`);
        if (!res.ok) return console.error('Erreur chargement sections');
        const sections = await res.json();
        const sel = document.getElementById('sections-list');
        sel.innerHTML = '<option value="">-- Choisir une section --</option>';
        sections.forEach(s => {
          const o = document.createElement('option');
          o.value = s.id_S;
          o.textContent = s.titre_S;
          sel.appendChild(o);
        });
      }

      // Charger une section dans l'éditeur
      document.getElementById('btn-load').addEventListener('click', async () => {
        const idS = document.getElementById('sections-list').value;
        if (!idS) return alert('Choisir une section');
        setStatus('Chargement...');
        const res = await fetch(`${apiBase}/sections/${idS}`);
        if (!res.ok) { setStatus('Erreur chargement', true); return; }
        const sec = await res.json();
        editor.DomComponents.clear();
        editor.CssComposer.clear();
        const html = sec.contenue_S || '<div><p>Section vide</p></div>';
        editor.setComponents(html);
        // store current
        editor._currentSectionId = idS;
        setStatus('Section chargée');
      });

      // Sauver la section
      document.getElementById('btn-save').addEventListener('click', async () => {
        const idS = editor._currentSectionId;
        if (!idS) return alert('Aucune section chargée. Charger ou créer une section.');
        setStatus('Sauvegarde en cours...');
        const html = editor.getHtml();
        const css = editor.getCss();
        const payload = { contenue_S: '<style>' + css + '</style>' + html };
        const res = await fetch(`${apiBase}/sections/${idS}`, {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': token,
            'Accept': 'application/json'
          },
          body: JSON.stringify(payload)
        });
        if (res.ok) {
          setStatus('Sauvegarde OK ✅');
        } else {
          const err = await res.json();
          setStatus('Erreur: ' + (err.message || JSON.stringify(err)), true);
        }
      });

      // Créer nouvelle section
      document.getElementById('btn-new').addEventListener('click', async () => {
        const titre = prompt('Titre de la nouvelle section :');
        if (!titre) return;
        // create with id_P = pageId
        const res = await fetch(`${apiBase}/sections`, {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': token,
            'Accept': 'application/json'
          },
          body: JSON.stringify({ titre_S: titre, id_P: pageId, contenu_S: '<div><p>Section vide</p></div>' })
        });
        if (res.ok) {
          const newSec = await res.json();
          await loadSectionsList();
          document.getElementById('sections-list').value = newSec.id_S;
          editor.DomComponents.clear();
          editor.CssComposer.clear();
          editor.setComponents(newSec.contenue_S);
          editor._currentSectionId = newSec.id_S;
          setStatus('Nouvelle section créée et chargée');
        } else {
          setStatus('Erreur création', true);
        }
      });

      function setStatus(text, isErr = false) {
        const s = document.getElementById('status');
        s.textContent = text;
        s.style.color = isErr ? 'red' : 'green';
      }

      loadSectionsList();

      editor.AssetManager.addType('my-assets', {
        uploadFile: (e) => {
        }
      });
    })();
  </script>
</body>
</html>
