@extends('layouts.app')
@section('content')

         <div class="it-hero-2-area pt-0">
            <div class="it-hero-2-overlay fix gray-bg z-index-1" style="background-image: url('data:image/jpeg;base64,{{ base64_encode($gouv->image_gouv) }}');" alt="{{ trans_field($gouv->gouvernorat,'nom') ?? '' }}">
               <div class="container">
                  <div class="row align-items-center">
                     <div class="col-xl-6 col-lg-6">
                        <div class="it-hero-2-content">
                           <h4 class="it-hero-3-subtitle it-split-in-right">
                             <span>{{ __('site.republic') }}</span>
                           </h4>
                             							      
                              <h1 class="it-hero-2-title it-split-in-right"> {{ __('site.ministry_name') }} </h1>
							      <h4 class="it-hero-2-subtitle it-split-in-right" style="color:#fff;">
                                    {{ __('site.gouvernorat_title_prefix') }} {{ trans_field($gouv->gouvernorat,'nom') ?? '' }}
                              </h4>
                           <div class="it-hero-2-text  wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".5s">
                              <p class="mb-30"><br/></p>
                           </div>
                           <div class="it-hero-btn d-sm-flex align-items-center">
                              <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay=".8">
                                 <a href="contact.html" class="it-btn-orange mr-30  wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".7s">
                                 <span>
                                    <span class="text-1">{{ __('site.hero_contact') }}</span>
                                    <span class="text-2">{{ __('site.hero_contact') }}</span>
                                 </span>
                                 <i>
                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                       <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                          fill="white" />
                                    </svg>
                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                       <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                          fill="white" />
                                    </svg>
                                 </i>
                              </a>
                           </div>
                           <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay="1">
                              <a href="service.html" class="it-btn-border  wow itfadeUp"
                                 data-wow-duration=".9s" data-wow-delay=".9s">
                             <span>
                                <span class="text-1">{{ __('site.news_more_button') }}</span>
                                <span class="text-2">{{ __('site.news_more_button') }}</span>
                             </span>
                             <i>
                                          <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                fill="white" />
                                          </svg>
                                          <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                fill="white" />
                                          </svg>
                                       </i>
                                    </a>
                                 </div>
                              </div>
                           </div>
                        </div>

                        <div class="col-xl-6 col-lg-6">
                                       <form class="booking-form">
                             <h4 class="it-contact-form-title mb-10" style="color:#FFFFFF;">{{ __('site.booking_title') }}</h4>
                              <div class="row">
                                 <div class="col-md-6 mb-3">
                                    <label>{{ __('site.booking_choose_house') }}</label>
                                    <select class="form-select">
                                       <option selected>{{ __('site.booking_choose_house_option') }}</option>
                                       <option>{{ __('site.sample_house_1') }}</option>
                                       <option>{{ __('site.sample_house_2') }}</option>
                                       <option>{{ __('site.sample_house_3') }}</option>
                                    </select>
                                 </div>
                                 <div class="col-md-6 mb-3">
                                    <label>{{ __('site.booking_number_places') }}</label>
                                    <input type="number" class="form-control" min="1" max="10">
                                 </div>
                                 <div class="col-md-6 mb-3">
                                    <label>{{ __('site.booking_arrival') }}</label>
                                    <input type="date" class="form-control">
                                 </div>
                                 <div class="col-md-6 mb-3">
                                    <label>{{ __('site.booking_departure') }}</label>
                                    <input type="date" class="form-control">
                                 </div>
                                 <div class="col-12 mb-3">
                                    <label>{{ __('site.booking_type') }}</label>
                                    <select class="form-select">
                                       <option selected>{{ __('site.booking_type_option') }}</option>
                                       <option>{{ __('site.booking_type_full') }}</option>
                                       <option>{{ __('site.booking_type_half') }}</option>
                                       <option>{{ __('site.booking_type_no_meals') }}</option>
                                    </select>
                                 </div>
                                 <div class="col-12">
								  <button type="submit" class="it-btn-orange">{{ __('site.booking_submit') }}</button>
                                 </div>
                              </div>
                           </form>
              						  </div>
                     </div>
                  </div>
                             </div>
            </div>

            <div class="it-about-2-area p-relative pt-0 pb-45">
<div class="it-project-3-area pt-65 pb-45" style="background:white;">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="it-section-title-box text-center mb-65">
                    <span class="it-section-subtitle">{{ __('site.centers_overview') }}</span>
                    <h4 class="it-section-title it-split-in-right mb-0">{{ trans_field($gouv->gouvernorat,'nom') ?? '' }}</h4>
                </div>
            </div>
        </div>

        {{-- Description 1 --}}
        <div class="row align-items-center mb-50">
            <div class="col-xl-6 col-lg-6">
                <div class="it-project-2-item mb-30">
                    <div class="it-project-2-thumb fix it-img-anim-wrap p-relative">
                        <div class="it-about-thumb it-img-anim">
                            <img style="width:650px; height:300px;" src="data:image/jpeg;base64,{{ base64_encode($gouv->image1) }}"  alt="{{ trans_field($gouv->gouvernorat,'nom') ?? '' }}">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6">
                <div class="it-about-2-text">
                    <div class="mb-30">{!! trans_field($gouv, 'desc1') !!}</div>
                </div>
            </div>
        </div>

        {{-- Description 2 --}}
        <div class="row align-items-center mb-50">
            <div class="col-xl-6 col-lg-6 order-lg-2 order-xl-2">
                <div class="it-project-2-item mb-30">
                    <div class="it-project-2-thumb fix it-img-anim-wrap p-relative">
                        <div class="it-about-thumb it-img-anim">
                            <img style="width:650px; height:320px;" src="data:image/jpeg;base64,{{ base64_encode($gouv->image2) }}"  alt="{{ trans_field($gouv->gouvernorat,'nom') ?? '' }}">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6 order-lg-1 order-xl-1">
                <div class="it-about-2-text">
                    <div class="mb-30">{!! trans_field($gouv, 'desc2') !!}</div>
                </div>
            </div>
        </div>

        {{-- Description 3 --}}
        <div class="row align-items-center mb-50">
            <div class="col-xl-6 col-lg-6">
                <div class="it-project-2-item mb-30">
                    <div class="it-project-2-thumb fix it-img-anim-wrap p-relative">
                        <div class="it-about-thumb it-img-anim">
                            <img style="width:650px; height:350px;" src="data:image/jpeg;base64,{{ base64_encode($gouv->image3) }}"  alt="{{ trans_field($gouv->gouvernorat,'nom') ?? '' }}">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6">
                <div class="it-about-2-text">
                    <div class="mb-30">{!! trans_field($gouv, 'desc3') !!}</div>
                </div>
            </div>
        </div>
    </div>
</div>

</div>

     <!-- **************************************************************************************************** -->
        <div class="it-project-3-area pt-65 pb-45" style="background:ghostwhite;">
   <div class="container">
      {{-- Titre --}}
      <div class="row">
         <div class="col-xl-12">
            <div class="it-section-title-box text-center mb-65">
               <span class="it-section-subtitle">{{ __('site.centers_in_gouv_subtitle') }} {{ trans_field($gouv->gouvernorat,'nom') ?? '' }}</span>
               <h4 class="it-section-title it-split-in-right mb-0"> {{ __('site.centers_in_gouv_title') }} {{ trans_field($gouv->gouvernorat,'nom') ?? '' }} </h4>
            </div>
         </div>
      </div>

      {{-- Vérification --}}
      @if($auberges->isEmpty())
         <div class="alert alert-warning text-center" style="font-size:20px;">
            {{ __('site.no_centers_in_gouv') }}
         </div>
      @else

      <div class="row">
         <div class="col-12">
            <div class="it-project-3-wrapper p-relative">
                              <div class="swiper-container it-project-3-active">
                  <div class="swiper-wrapper">
                     @foreach($auberges as $auberge)
                     <div class="swiper-slide">
                        <div class="luxury-room-card p-relative">
                           <div class="room-thumb">
                              <img class="w-100 rounded"
                                   src="data:image/jpeg;base64,{{ base64_encode($auberge->image) }}"
                                   alt="{{ trans_field($auberge,'nom') ?? $auberge->nom }}"
                                   style="width:100%; height:260px; object-fit:cover; border-radius:8px;">
                           </div>
                           <div class="room-content">
                              <h4 class="room-title">
                                 <a href="{{ route('auberge.show', $auberge->id) }}">
                                    {{ trans_field($auberge,'nom') ?? $auberge->nom }}
                                 </a>
                              </h4>

                              {{-- Capacités --}}
                              <div class="room-meta">
                                 @if($auberge->nb_chambres > 0)
                                    <span><i class="fas fa-bed"></i> {{ $auberge->nb_chambres }} {{ __('site.beds_label') }}</span>
                                 @endif
                                 @if($auberge->capacite_tentes > 0)
                                    <span><i class="fas fa-campground"></i> {{ $auberge->capacite_tentes }} {{ __('site.tents_label') }}</span>
                                 @endif
                              </div>

                              {{-- Services --}}
                              <div class="room-features">
                                 @if($auberge->services_auberge->isNotEmpty())
                                    @foreach($auberge->services_auberge as $service)
                                       <div class="feature">
                                          <i class="fas fa-check"></i>
                                          <span>{{ trans_field($service,'nom') ?? $service->nom_ar }}</span>
                                       </div>
                                    @endforeach
                                 @else
                                    <div class="feature">
                                       <span>-</span>
                                    </div>
                                 @endif
                              </div>

                              {{-- Contact --}}
                              <div class="room-contact">
                                 @if($auberge->contact_tel)
                                    <i class="fas fa-phone"></i> {{ $auberge->contact_tel }}
                                 @endif
                                 @if($auberge->adresse)
                                    <i class="fas fa-map-marker-alt"></i> {{ $auberge->adresse }}
                                 @endif
                              </div>

                              {{-- Bouton --}}
                              <a class="book-now-btn" href="{{ route('auberge.show', $auberge->id) }}">
                                 {{ __('site.book_now') }} <i class="fas fa-arrow-right"></i>
                              </a>
                           </div>
                        </div>
                     </div>
                     @endforeach
                  </div>
               </div>

               {{-- Boutons de navigation --}}
               <div class="it-project-arrow-wrap d-none d-xl-block">
                  <button class="arrow-prev">
                     <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                           xmlns="http://www.w3.org/2000/svg">
                        <path
                           d="M0.292892 7.29289C-0.0976315 7.68342 -0.0976315 8.31658 0.292892 8.70711L6.65685 15.0711C7.04738 15.4616 7.68054 15.4616 8.07107 15.0711C8.46159 14.6805 8.46159 14.0474 8.07107 13.6569L2.41421 8L8.07107 2.34315C8.46159 1.95262 8.46159 1.31946 8.07107 0.928932C7.68054 0.538408 7.04738 0.538408 6.65685 0.928932L0.292892 7.29289ZM16 7H0.999999V9H16V7Z"
                           fill="currentColor"/>
                     </svg>
                  </button>
                  <button class="arrow-next">
                     <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                           xmlns="http://www.w3.org/2000/svg">
                        <path
                           d="M15.7071 8.70711C16.0976 8.31658 16.0976 7.68342 15.7071 7.29289L9.34315 0.928932C8.95262 0.538408 8.31946 0.538408 7.92893 0.928932C7.53841 1.31946 7.53841 1.95262 7.92893 2.34315L13.5858 8L7.92893 13.6569C7.53841 14.0474 7.53841 14.6805 7.92893 15.0711C8.31946 15.4616 8.95262 15.4616 9.34315 15.0711L15.7071 8.70711ZM0 9H15V7H0V9Z"
                           fill="currentColor"/>
                     </svg>
                  </button>
               </div>

               {{-- Dots --}}
               <div class="it-project-3-dots text-center mt-55"></div>
            </div>
         </div>
      </div>
      @endif

      {{-- Bouton Tous les centres (commenté) --}}
      <!--div class="row align-items-center">
         <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12">
            <div class="it-about-2-btn" style="padding-top: 25px;text-align: center;">
               <a href="" class="it-btn-orange">
                  <span>
                     <span class="text-1">{{ __('site.all_centers') }}</span>
                     <span class="text-2">{{ __('site.all_centers') }}</span>
                  </span>
                  <i>
                     <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                           fill="white" />
                     </svg>
                     <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                           fill="white" />
                     </svg>
                  </i>
               </a>
            </div>
         </div>
      </div-->   
   </div>
</div> 

      <section class="about-section pt-100 pb-70">
         <div class="container">
            <div class="row align-items-center">
               <div class="col-lg-6 mb-30">
                  <div class="about-content">
				    <div class="it-section-title-box mb-20">
                              <span class="it-section-subtitle">{{ __('site.about_service_title') }}</span>
                           
                           </div>
                     <div class="it-about-2-text">
                              <p class="mb-30">
                     {!! __('site.about_text') !!}
                     <p>{{ __('site.about_we_offer') }}</p>
                     <ul class="list-unstyled">
                        <li><i class="fas fa-check"></i> {{ __('site.about_feature_rooms') }}</li>
                        <li><i class="fas fa-check"></i> {{ __('site.about_feature_food') }}</li>
                        <li><i class="fas fa-check"></i> {{ __('site.about_feature_facilities') }}</li>
                        <li><i class="fas fa-check"></i> {{ __('site.about_feature_prices') }}</li>
                     </ul>
					 </p></div>
                  </div>
               </div>
               <div class="col-lg-6 mb-30">
                  <div class="map-container" style="position: relative;">
                    <img src="{{ asset('assets/img/faq/map.jpg') }}" alt="{{ __('site.map_alt') }}" class="img-fluid" style="width: 100%; height: auto;">

                    <div class="custom-map-points">
                        <!-- Points statiques sur la carte -->
                        <a href="#" class="custom-map-marker" style="left: 40%; top: 30%;" title="{{ __('site.marker_tunis') }}">
                            <i class="ri-home-4-fill"></i>
                        </a>
                        <a href="#" class="custom-map-marker" style="left: 45%; top: 50%;" title="{{ __('site.marker_sousse') }}">
                            <i class="ri-home-4-fill"></i>
                        </a>
                        <a href="#" class="custom-map-marker" style="left: 50%; top: 35%;" title="{{ __('site.marker_sfaxes') }}">
                            <i class="ri-home-4-fill"></i>
                        </a>
                        <a href="#" class="custom-map-marker" style="left: 65%; top: 65%;" title="{{ __('site.marker_mednine') }}">
                            <i class="ri-home-4-fill"></i>
                        </a>
                        <a href="#" class="custom-map-marker" style="left: 35%; top: 15%;" title="{{ __('site.marker_bizerte') }}">
                            <i class="ri-home-4-fill"></i>
                        </a>
                    </div>
                  </div>

                  <style>
                    .map-container {
                        position: relative;
                        overflow: hidden;
                    }
                    .custom-map-points {
                        position: absolute;
                        top: 0;
                        left: 0;
                        width: 100%;
                        height: 100%;
                        pointer-events: none;
                        z-index: 10;
                    }
                    .custom-map-marker {
                        position: absolute;
                        transform: translate(-50%, -50%);
                        width: 30px;
                        height: 30px;
                        background-color: rgba(26, 35, 126, 0.1);
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        color: #1a237e;
                        text-decoration: none;
                        transition: all 0.3s ease;
                        pointer-events: auto;
                        z-index: 11;
                    }
                    .custom-map-marker:hover {
                        background-color: #1a237e;
                        color: white;
                        transform: translate(-50%, -50%) scale(1.2);
                        text-decoration: none;
                    }
                    .custom-map-marker i {
                        font-size: 16px;
                    }
                    /* Styles pour les tooltips Bootstrap personnalisés */
                    .custom-tooltip {
                        --bs-tooltip-bg: white;
                        --bs-tooltip-color: #1a237e;
                        --bs-tooltip-opacity: 1;
                        font-family: inherit;
                        direction: rtl;
                    }
                    .custom-tooltip .tooltip-inner {
                        background-color: white;
                        color: #1a237e;
                        border-radius: 8px;
                        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                        padding: 8px 12px;
                        font-size: 14px;
                        max-width: 200px;
                    }
                    .custom-tooltip .tooltip-arrow::before {
                        border-top-color: white;
                    }
                  </style>

                  @push('scripts')
                  <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        // Initialiser les tooltips Bootstrap
                        var tooltipTriggerList = [].slice.call(document.querySelectorAll('.custom-map-marker'));
                        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                            return new bootstrap.Tooltip(tooltipTriggerEl, {
                                placement: 'top',
                                trigger: 'hover',
                                template: '<div class="tooltip custom-tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
                            });
                        });
                    });
                  </script>
                  @endpush
               </div>
            </div>
         </div>
      </section>

@endsection
