@extends('layouts.app')

@section('content')
<section class="it-about-3-area p-relative pt-30 pb-125" dir="rtl" lang="ar">
<img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
                <div class="container">
<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
           <a href="{{ url('/') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
      
        <li class="breadcrumb-item active" aria-current="page">{{ $builder->titre_ar }} </li>
    </ol>
</nav>
  <div class="container">
    <div class="row">
      <div class="col-12 text-center mb-4">
        <span class="it-section-subtitle"> {{ $builder->titre_ar }}</span>
        <!--h4 class="it-section-title it-split-in-right mb-0">مناظرات وإنتدابات</!--h4-->
        <!--p class="text-muted mt-2">قائمة المناظرات المتاحة حالياً. انقر على "التسجيل" لفتح صفحة التسجيل</!--p-->
      </div>
    </div>

    <div class="it-about-2-area p-relative pt-0 pb-45">
    <div class="it-project-3-area pt-65 pb-45" style="background:white;">
        <div class="container">
            <div class="row align-items-center mb-50">
    @foreach($builder->contenus as $contenu)
        @php
            // Transformer le lien YouTube pour iframe
            if ($contenu->nature == 'video') {
                preg_match("/v=([a-zA-Z0-9_-]+)/", $contenu->url_video, $matches);
                $videoId = $matches[1] ?? '';
                $videoEmbed = $videoId ? "https://www.youtube.com/embed/$videoId" : '';
            }
        @endphp

        <div class="{{ $contenu->col }} mb-30">
            @if($contenu->nature == 'image' && $contenu->image)
                <div class="it-project-2-item">
                    <div class="it-project-2-thumb fix it-img-anim-wrap p-relative">
                        <div class="it-about-thumb it-img-anim">
                            <img src="{{ asset('uploads/' . $contenu->image) }}" alt="" style="width:100%; height:auto;">
                        </div>
                    </div>
                </div>
            @elseif($contenu->nature == 'texte')
                <div class="it-about-2-text">
                    {!! $contenu->text_ar !!}
                </div>
            @elseif($contenu->nature == 'video' && $videoEmbed)
                <div class="it-about-2-text">
                    <iframe width="100%" height="315" src="{{ $videoEmbed }}" frameborder="0" allowfullscreen></iframe>
                </div>
            @endif
        </div>
    @endforeach
</div>

        </div>
    </div>
</div>

    

    
  </div>
</section>
@endsection

