@extends('layouts.app')

@section('content')
@php
    $locale = app()->getLocale();
    $dir = $locale === 'ar' ? 'rtl' : 'ltr';
@endphp

<section class="it-about-3-area p-relative pt-30 pb-125" dir="{{ $dir }}" lang="{{ $locale }}">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="{{ __('site.map_alt') }}">

    <div class="container">
        <nav class="breadcrumb-nav" aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item">
                    <a href="{{ url('/') }}">
                        <i class="bi bi-house-fill"></i>
                        <span>{{ __('site.breadcrumb_home') }}</span>
                    </a>
                </li>

                <li class="breadcrumb-item">
                    <a href="{{ route('concours.available') }}">
                        <span>{{ __('site.concours_page_title') }}</span>
                    </a>
                </li>

                <li class="breadcrumb-item active" aria-current="page">{{ __('site.concours_results_title') }}</li>
            </ol>
        </nav>

        <div class="row">
            <div class="col-12 text-center mb-4">
                <span class="it-section-subtitle">{{ __('site.concours_results_title') }}</span>

                {{-- dynamic title: try trans_field then fallback to common columns --}}
                <h4 class="it-section-title it-split-in-right mb-0">
                    {{ function_exists('trans_field') ? trans_field($concours, 'titre') : ($concours->titre ?? $concours->titre_G ?? '') }}
                </h4>

                <p class="text-muted mt-2">
                    {{ __('site.registration_ends') }}:
                    {{ optional($concours->date_fin)->format('Y-m-d') ?? '—' }}
                </p>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-lg-8 mx-auto">
                <form method="GET" action="{{ route('concours.results', $concours) }}" class="d-flex gap-2 align-items-center">
                    <input
                        name="q"
                        value="{{ old('q', $q ?? '') }}"
                        class="conc-input form-control form-control-sm"
                        placeholder="{{ __('site.results_search_placeholder') }}"
                    />
                    <div class="d-flex gap-2">
                        <button class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                            {{ __('site.search_button') }}
                        </button>

                        <a href="{{ route('concours.results', $concours) }}" style="width: 105px;" class="btn bg-rgb-primary1 font-weight-medium">
                            {{ __('site.reset_button') }}
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card shadow-sm p-4">
                    <div class="form-section">
                        {{-- Show a prompt if user didn't search yet --}}
                        @if(! ($searchRan ?? false) )
                          <div class="py-5 text-center">
                            <p class="h6 text-muted mb-2">{{ __('site.results_prompt') }}</p>
                            <small class="text-muted">{{ __('site.results_prompt_note') }}</small>
                          </div>

                        @else
                          {{-- search was run: show table (may be empty if no matches) --}}
                          <div class="table-responsive">
                            <table class="table table-hover mb-0 align-middle {{ $dir === 'rtl' ? 'text-end' : '' }}">
                              <thead class="table-light">
                                <tr>
                                  <th style="width:30%;">{{ __('site.table_name') }}</th>
                                  <th style="width:15%;">{{ __('site.table_cin') }}</th>
                                  <th style="width:25%;">{{ __('site.table_email') }}</th>
                                  <th style="width:15%;">{{ __('site.table_status') }}</th>
                                  <th style="width:15%;">{{ __('site.table_created_at') }}</th>
                                </tr>
                              </thead>

                              <tbody>
                                @forelse($candidates as $cand)
                                  <tr>
                                    <td>
                                      <div><strong>{{ $cand->nom }} {{ $cand->prenom }}</strong></div>
                                      <div class="text-muted small">{{ $cand->gouvernorat ?? '—' }}</div>
                                    </td>
                                    <td>{{ $cand->cin ?? '—' }}</td>
                                    <td>
                                      @if($cand->email)
                                        <a href="mailto:{{ $cand->email }}" class="text-decoration-none">{{ $cand->email }}</a>
                                      @else
                                        —
                                      @endif
                                    </td>
                                    <td>
                                      <span class="badge
                                        {{ $cand->etat === 'acceptation_definitif' ? 'bg-success' : ($cand->etat === 'acceptation_primaire' ? 'bg-info text-dark' : ($cand->etat === 'refuse' ? 'bg-danger' : 'bg-warning text-dark')) }}">
                                        {{-- try explicit label, else translation by key --}}
                                        {{ $cand->etat_label ?? __('site.status_'.$cand->etat) }}
                                      </span>
                                    </td>
                                    <td><small class="text-muted">{{ optional($cand->created_at)->format('Y-m-d') }}</small></td>
                                  </tr>
                                @empty
                                  <tr>
                                    <td colspan="5" class="text-center py-4 text-muted">{{ __('site.no_results') }}</td>
                                  </tr>
                                @endforelse
                              </tbody>
                            </table>
                          </div>

                          <div class="mt-3 d-flex justify-content-center">
                            {{ $candidates->appends(request()->except('page'))->links('pagination::bootstrap-5') }}
                          </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
