@extends('layouts.app')

@section('content')
@php
    $locale = app()->getLocale();
    $dir = $locale === 'ar' ? 'rtl' : 'ltr';
@endphp

<section class="it-about-3-area p-relative pt-30 pb-125" dir="{{ $dir }}" lang="{{ $locale }}">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="{{ __('site.map_alt') }}">

    <div class="container">
        <nav class="breadcrumb-nav" aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item">
                    <a href="{{ url('/') }}">
                        <i class="bi bi-house-fill"></i>
                        <span>{{ __('site.breadcrumb_home') }}</span>
                    </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">{{ __('site.concours_page_title') }}</li>
            </ol>
        </nav>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-4">
                <span class="it-section-subtitle">{{ __('site.services_subtitle') }}</span>
                <h4 class="it-section-title it-split-in-right mb-0">{{ __('site.concours_page_title') }}</h4>
                <p class="text-muted mt-2">{{ __('site.concours_page_description') }}</p>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-lg-8 mx-auto">
                <form method="GET" action="{{ route('concours.available') }}" class="d-flex gap-2 align-items-center">
                    <input
                        name="q"
                        value="{{ old('q', $q ?? '') }}"
                        class="conc-input form-control form-control-sm"
                        placeholder="{{ __('site.concours_search_placeholder') }}"
                    />
                    <div class="d-flex gap-2">
                        <button class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                            {{ __('site.search_button') }}
                        </button>

                        <a href="{{ route('concours.available') }}" style="width: 105px;" class="btn bg-rgb-primary1 font-weight-medium">
                            {{ __('site.reset_button') }}
                        </a>
                    </div>
                </form>
            </div>
        </div>

        {{-- Grid of concours --}}
        <div class="services-grid">
            @forelse($concours as $c)
                <div class="service-card">
                    <div class="service-iconn">
                        <i class="ri-file-list-line"></i>
                    </div>

                    {{-- dynamic title: try localized column first --}}
                    <h3 class="service-title">
                        {{ function_exists('trans_field') ? trans_field($c, 'titre') : ($c->titre ?? '') }}
                    </h3>

                    <p class="text-muted mb-3">
                        {{ __('site.registration_ends') }}:
                        @if(!empty($c->date_fin))
                            {{ \Carbon\Carbon::parse($c->date_fin)->format('Y-m-d') }}
                        @else
                            —
                        @endif
                    </p>

                    @php
                        // try localized description (use trans_field if available)
                        $shortDesc = null;
                        if (function_exists('trans_field')) {
                            $raw = trans_field($c, 'description') ?? trans_field($c, 'resume') ?? ($c->description ?? null);
                        } else {
                            $raw = $c->description ?? null;
                        }
                        if ($raw) {
                            $shortDesc = \Illuminate\Support\Str::limit(strip_tags($raw), 120);
                        }
                    @endphp

                    @if($shortDesc)
                        <p class="text-muted mb-3">{{ $shortDesc }}</p>
                    @endif

                    <div class="service-actions">
                        <a href="{{ route('concours.show', $c) }}" class="service-link">
                            {{ __('site.register_button') }} <i class="{{ $dir === 'rtl' ? 'ri-arrow-left-line' : 'ri-arrow-right-line' }}"></i>
                        </a>
                        <a href="{{ route('concours.results', $c) }}" class="service-link">
                            {{ __('site.results_button') }} <i class="{{ $dir === 'rtl' ? 'ri-arrow-left-line' : 'ri-arrow-right-line' }}"></i>
                        </a>
                    </div>
                </div>
            @empty
                <div class="col-12 text-center py-5">
                    <p class="mb-0 text-muted">{{ __('site.no_concours') }}</p>
                </div>
            @endforelse
        </div>

        <div class="row mt-4">
            <div class="col-12 d-flex justify-content-center">
                {{ $concours->appends(request()->except('page'))->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</section>
@endsection
