@extends('layouts.app')

@section('content')
<div class="container py-4" dir="rtl" lang="ar">
  <div class="row justify-content-center">
    <div class="col-xl-8">
      <div class="card shadow-sm">
        <div class="card-header">
          <h4 class="mb-0 text-end">إضافة حقل جديد للنموذج</h4>
        </div>

        <div class="card-body">
          @if($errors->any())
            <div class="alert alert-danger text-end">
              <ul class="mb-0">
                @foreach($errors->all() as $err)
                  <li>{{ $err }}</li>
                @endforeach
              </ul>
            </div>
          @endif

          <form action="{{ route('field_definitions.store') }}" method="POST" novalidate>
            @csrf

            <div class="mb-3 text-end">
              <label class="form-label">المفتاح (key) — مثال: diplome</label>
              <input name="key" value="{{ old('key') }}" class="form-control" required placeholder="letters_numbers_ -">
            </div>

            <div class="mb-3 text-end">
              <label class="form-label">التسمية (label)</label>
              <input name="label" value="{{ old('label') }}" class="form-control" required placeholder="التسمية الظاهرة للمستخدم">
            </div>

            <div class="row g-2">
              <div class="col-md-6 text-end mb-3">
                <label class="form-label">نوع الحقل (input_type)</label>
                <select name="input_type" class="form-select">
                  <option value="text" {{ old('input_type')==='text' ? 'selected' : '' }}>نص</option>
                  <option value="textarea" {{ old('input_type')==='textarea' ? 'selected' : '' }}>منطقة نص</option>
                  <option value="date" {{ old('input_type')==='date' ? 'selected' : '' }}>تاريخ</option>
                  <option value="number" {{ old('input_type')==='number' ? 'selected' : '' }}>رقم</option>
                  <option value="file" {{ old('input_type')==='file' ? 'selected' : '' }}>ملف</option>
                  <option value="email" {{ old('input_type')==='email' ? 'selected' : '' }}>بريد إلكتروني</option>
                </select>
              </div>

              <div class="col-md-6 text-end mb-3">
                <label class="form-label">نوع القيمة (value_type)</label>
                <select name="value_type" class="form-select">
                  <option value="string" {{ old('value_type')==='string' ? 'selected' : '' }}>سلسلة</option>
                  <option value="number" {{ old('value_type')==='number' ? 'selected' : '' }}>عدد</option>
                  <option value="date" {{ old('value_type')==='date' ? 'selected' : '' }}>تاريخ</option>
                  <option value="file" {{ old('value_type')==='file' ? 'selected' : '' }}>ملف</option>
                </select>
              </div>
            </div>

            <div class="mb-3 text-end">
              <label class="form-label">خيارات (select/radio) — كل خيار في سطر جديد أو مفصول بفاصلة</label>
              <textarea name="options_json" class="form-control" rows="3" placeholder="مثال: خيار1&#10;خيار2"></textarea>
            </div>

            <div class="row g-2 align-items-center mb-3">
              <div class="col-auto text-end">
                <div class="form-check form-switch">
                  <input class="form-check-input" name="is_visible" type="checkbox" value="1" {{ old('is_visible') ? 'checked' : '' }}>
                  <label class="form-check-label">مرئي في الاستمارة</label>
                </div>
              </div>

              <div class="col-auto text-end">
                <div class="form-check form-switch">
                  <input class="form-check-input" name="is_required" type="checkbox" value="1" {{ old('is_required') ? 'checked' : '' }}>
                  <label class="form-check-label">إلزامي</label>
                </div>
              </div>

              <div class="col text-end">
                <label class="form-label small">ترتيب العرض</label>
                <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', 100) }}">
              </div>
            </div>

            <div class="d-flex justify-content-between">
              <a href="{{ route('field_definitions.index') }}" class="btn btn-outline-secondary">العودة</a>
              <button type="submit" class="btn btn-primary">حفظ الحقل</button>
            </div>
          </form>
        </div>

      </div>
    </div>
  </div>
</div>
@endsection
