@extends('layouts.app')

@section('content')
<div class="container py-4" dir="rtl" lang="ar">
    <div class="row justify-content-center">
        <div class="col-xl-9 col-lg-10">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white text-center" dir="rtl">
                    <h3 class="mb-1">{{ $concours->titre }}</h3>
                    <small class="text-muted d-block">املأ الاستمارة أدناه للتسجيل في هذه المسابقة.</small>
                    <div class="mt-2">
                        {{-- <span class="badge {{ $concours->etat === 'published' ? 'bg-success' : ($concours->etat === 'closed' ? 'bg-secondary' : 'bg-warning text-dark') }}">
                            {{ $concours->etat_label }}
                        </span> --}}
                        <small class="text-muted ms-2">
                            @if($concours->date_debut) تاريخ البداية: {{ $concours->date_debut->format('Y-m-d') }} @endif
                            @if($concours->date_fin) — آخر أجل: {{ $concours->date_fin->format('Y-m-d') }} @endif
                        </small>
                    </div>
                </div>

                <div class="card-body" dir="rtl">
                    @if(session('success'))
                        <div class="alert alert-success text-end">{{ session('success') }}</div>
                    @endif

                    @if($errors->any())
                      <div class="alert alert-danger text-end">
                          <ul class="mb-0" style="direction: rtl; text-align: right;">
                              @foreach($errors->all() as $err)
                                  <li>{{ $err }}</li>
                              @endforeach
                          </ul>
                      </div>
                    @endif

                    <form id="concours-form" action="{{ route('concours.apply', $concours) }}" method="POST" enctype="multipart/form-data" novalidate dir="rtl">

                        @csrf

                        <div class="row g-3">
                           <div class="col-md-6">
  <label for="nom" class="form-label" style="color: black">اللقب / الاسم العائلي <span class="text-danger">*</span></label>
  <input id="nom" name="nom"
         class="form-control @error('nom') is-invalid @enderror"
         value="{{ old('nom') }}"
         required maxlength="100"
         title="الاسم محدّد بـ 100حرفاً كحد أقصى">
  @error('nom') <div class="invalid-feedback text-end">{{ $message }}</div> @enderror
</div>
                       <div class="col-md-6">
  <label for="prenom" class="form-label" style="color: black">الاسم الشخصي <span class="text-danger">*</span></label>
  <input id="prenom" name="prenom"
         class="form-control @error('prenom') is-invalid @enderror"
         value="{{ old('prenom') }}"
         required maxlength="100"
         title="الاسم محدّد بـ  100حرفاً كحد أقصى">
  @error('prenom') <div class="invalid-feedback text-end">{{ $message }}</div> @enderror
</div>

                         <div class="col-md-6">
  <label for="cin" class="form-label" style="color: black">رقم بطاقة التعريف الوطنية</label>
  <input id="cin" name="cin"
         class="form-control @error('cin') is-invalid @enderror"
         value="{{ old('cin') }}"
         inputmode="numeric" pattern="\d{8}" maxlength="8"
         title="يجب أن يحتوي على 8 أرقام (مثال: 12345678)">
  @error('cin') <div class="invalid-feedback text-end">{{ $message }}</div> @enderror
</div>
                            <div class="col-md-6">
                                <label for="date_naissance" class="form-label" style="color: black">تاريخ الولادة</label>
                                <input id="date_naissance" name="date_naissance" type="date" class="form-control @error('date_naissance') is-invalid @enderror" value="{{ old('date_naissance') }}">
                                @error('date_naissance') <div class="invalid-feedback text-end">{{ $message }}</div> @enderror
                            </div>

                       <div class="col-md-6">
  <label for="tel" class="form-label" style="color: black">الهاتف</label>
  <input id="tel" name="tel"
         class="form-control @error('tel') is-invalid @enderror"
         value="{{ old('tel') }}"
         inputmode="numeric" pattern="\d{8}" maxlength="8"
         title="يجب أن يحتوي على 8 أرقام (مثال: 98xxxxxx)">
  @error('tel') <div class="invalid-feedback text-end">{{ $message }}</div> @enderror
</div>
                            <div class="col-md-6">
                                <label for="email" class="form-label" style="color: black">البريد الإلكتروني</label>
                                <input id="email" name="email" type="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email') }}">
                                @error('email') <div class="invalid-feedback text-end">{{ $message }}</div> @enderror
                            </div>

                          <div class="col-md-6">
  <label for="adresse" class="form-label" style="color: black">العنوان</label>
  <input id="adresse" name="adresse" type="text"
         class="form-control @error('adresse') is-invalid @enderror"
         value="{{ old('adresse') }}"
         maxlength="255"
         title="العنوان محدّد بـ 255 حرفاً كحد أقصى">
  @error('adresse') <div class="invalid-feedback text-end">{{ $message }}</div> @enderror
</div>

                           <div class="col-md-3">
      <label class="form-label"> الولاية </label>
                <div class="col-md-10 postbox__select">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}">{{ $gouv->nom_ar }}</option>
                        @endforeach
                    </select>
                </div>

</div>

                         <div class="col-md-3">
  <label for="code_postale" class="form-label" style="color: black">الرمز البريدي</label>
   <div class="col-md-10 postbox__select">
  <input id="code_postale" name="code_postale"
         class="form-control @error('code_postale') is-invalid @enderror"
         value="{{ old('code_postale') }}"
         inputmode="numeric" pattern="\d{4}" maxlength="4"
         title="الرمز البريدي مكوّن من 4 أرقام">
  @error('code_postale') <div class="invalid-feedback text-end">{{ $message }}</div> @enderror
  </div>
</div>
                        </div>

                        {{-- dynamic optional fields from $fieldDefinitions --}}
                        <div id="optional-fields" class="row g-3 mt-3" dir="rtl">
                        @foreach($fieldDefinitions as $def)
                            @php
                                $inputName = 'field_'.$def->id;
                                $label = $def->label ?: $def->key;
                                $isRequired = (bool)$def->is_required;
                                $current = old($inputName, null);
                            @endphp
@php
  // normalize type (avoid trailing spaces / different casing)
  $type = trim(strtolower((string) $def->input_type));
  $opts = method_exists($def, 'options') ? $def->options() : (json_decode($def->options_json, true) ?: []);
  // for debugging: you can remove this later
  $debug = "type={$type}; opts_count=" . count($opts);
@endphp
                            <div class="col-md-6 optional-field" data-key="{{ $def->key }}">
                                <label for="{{ $inputName }}" style="color: black" class="form-label" style="display:block; text-align:right;">{{ $label }} @if($isRequired) <span class="text-danger">*</span> @endif</label>

                         @switch($type)

  {{-- single select / dropdown --}}
  @case('select')
  @case('dropdown')
    <select id="{{ $inputName }}" name="{{ $inputName }}" class="form-select @error($inputName) is-invalid @enderror" {{ $isRequired ? 'required' : '' }} dir="rtl">
      <option value="">{{ __('— اختر —') }}</option>
      @foreach($opts as $opt)
        <option value="{{ $opt }}" {{ (string)old($inputName, $current) === (string)$opt ? 'selected' : '' }}>{{ $opt }}</option>
      @endforeach
    </select>
    @break

  {{-- multiple select --}}
  @case('multiselect')
  @case('multi-select')
  @case('multiple')
    <select id="{{ $inputName }}" name="{{ $inputName }}[]" class="form-select @error($inputName) is-invalid @enderror" multiple {{ $isRequired ? 'required' : '' }} dir="rtl">
      @foreach($opts as $opt)
        <option value="{{ $opt }}" {{ (is_array(old($inputName)) && in_array($opt, old($inputName))) ? 'selected' : '' }}>{{ $opt }}</option>
      @endforeach
    </select>
    @break

  {{-- textarea --}}
  @case('textarea')
    <textarea id="{{ $inputName }}" name="{{ $inputName }}" class="form-control @error($inputName) is-invalid @enderror" {{ $isRequired ? 'required' : '' }}>{{ old($inputName, $current) }}</textarea>
    @break

  {{-- date --}}
  @case('date')
    <input id="{{ $inputName }}" type="date" name="{{ $inputName }}" class="form-control @error($inputName) is-invalid @enderror" value="{{ old($inputName, $current) }}" {{ $isRequired ? 'required' : '' }}>
    @break

  {{-- number --}}
  @case('number')
    <input id="{{ $inputName }}" type="number" step="any" name="{{ $inputName }}" class="form-control @error($inputName) is-invalid @enderror" value="{{ old($inputName, $current) }}" {{ $isRequired ? 'required' : '' }}>
    @break

  {{-- file --}}
  @case('file')
    <input id="{{ $inputName }}" type="file" name="{{ $inputName }}" class="form-control @error($inputName) is-invalid @enderror" {{ $isRequired ? 'required' : '' }}>
    @break

  {{-- email --}}
  @case('email')
    <input id="{{ $inputName }}" type="email" name="{{ $inputName }}" class="form-control @error($inputName) is-invalid @enderror" value="{{ old($inputName, $current) }}" {{ $isRequired ? 'required' : '' }}>
    @break

  {{-- radio --}}
  @case('radio')
    <div>
      @foreach($opts as $idx => $opt)
        @php $rid = $inputName . '_r_'.$idx; @endphp
        <div class="form-check form-check-inline">
          <input class="form-check-input @error($inputName) is-invalid @enderror" type="radio" name="{{ $inputName }}" id="{{ $rid }}" value="{{ $opt }}" {{ ((string)old($inputName, $current) === (string)$opt) ? 'checked' : '' }}>
          <label class="form-check-label" style="color: black" for="{{ $rid }}">{{ $opt }}</label>
        </div>
      @endforeach
    </div>
    @break

  {{-- checkbox group --}}
  @case('checkbox')
  @case('checkboxes')
    <div>
      @foreach($opts as $idx => $opt)
        @php $cid = $inputName . '_c_'.$idx; @endphp
        <div class="form-check">
          <input class="form-check-input @error($inputName) is-invalid @enderror" type="checkbox" name="{{ $inputName }}[]" id="{{ $cid }}" value="{{ $opt }}" {{ (is_array(old($inputName)) && in_array($opt, old($inputName))) ? 'checked' : '' }}>
          <label class="form-check-label" style="color: black" for="{{ $cid }}">{{ $opt }}</label>
        </div>
      @endforeach
    </div>
    @break

  {{-- fallback to text input --}}
  @default
    <input id="{{ $inputName }}" type="text" name="{{ $inputName }}" class="form-control @error($inputName) is-invalid @enderror" value="{{ old($inputName, $current) }}" {{ $isRequired ? 'required' : '' }}>
@endswitch

                                @error($inputName) <div class="invalid-feedback text-end">{{ $message }}</div> @enderror
                            </div>
                        @endforeach
                        </div>

                        <div class="mt-4 d-flex justify-content-start">
                            <button type="submit" class="btn btn-primary px-4">إرسال</button>
                        </div>
                    </form>
                </div>

                <div class="card-footer small text-muted text-center">
                    يتم تخزين المعلومات بشكل آمن. لأي استفسار تواصل مع المسؤول.
                </div>
            </div>
        </div>
    </div>
</div>

{{-- light view-level styling --}}
@push('styles')
<style>
    .form-label { display: block; text-align: right; font-weight: 500; color: #111; }
    .card-header { background-color: #fff; border-bottom: 1px solid rgba(0,0,0,.06); }
</style>
@endpush
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
  const form = document.getElementById('concours-form');
  if (!form) return;

  const messages = {
    required: 'هذا الحقل مطلوب.',
    email: 'الرجاء إدخال بريد إلكتروني صالح.',
    number: 'الرجاء إدخال رقم صالح.',
    file: 'الرجاء تحميل ملف.',
    minArray: 'الرجاء اختيار خيار واحد على الأقل.'
  };

  // Remove previous client-side feedback
  function clearClientErrors() {
    form.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
    form.querySelectorAll('.client-error-feedback').forEach(el => el.remove());
  }

  // Create/show feedback under element or container
  function showFeedback(target, msg) {
    // If target is an individual input/select
    if (target instanceof Element) {
      target.classList.add('is-invalid');
      // Avoid duplicating feedback
      let fb = target.parentElement.querySelector('.client-error-feedback');
      if (!fb) {
        fb = document.createElement('div');
        fb.className = 'invalid-feedback client-error-feedback text-end d-block';
        // insert after the input
        target.insertAdjacentElement('afterend', fb);
      }
      fb.textContent = msg;
      return fb;
    }
  }

  // Show feedback for radio/checkbox groups: find group container to attach message
  function showGroupFeedback(firstInputInGroup, msg) {
    const container = firstInputInGroup.closest('.optional-field') || firstInputInGroup.parentElement;
    // mark inputs visually
    const inputs = container.querySelectorAll('input[type="radio"], input[type="checkbox"]');
    inputs.forEach(i => i.classList.add('is-invalid'));
    // add feedback once
    let fb = container.querySelector('.client-error-feedback');
    if (!fb) {
      fb = document.createElement('div');
      fb.className = 'invalid-feedback client-error-feedback text-end d-block';
      container.appendChild(fb);
    }
    fb.textContent = msg;
    return fb;
  }

  // Basic email regex (sufficient for client-side check)
  function validEmail(v) {
    return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(v);
  }

  // Basic number check
  function validNumber(v) {
    return v !== '' && !isNaN(Number(v));
  }

  // On form submit: validate required fields
  form.addEventListener('submit', function (ev) {
    clearClientErrors();
    let invalid = false;
    let firstInvalidEl = null;

    // Handle grouped inputs (radio/checkbox) by name to avoid duplicate checks
    const handledGroups = new Set();

    // find all elements with required attribute inside the form
    const requiredEls = Array.from(form.querySelectorAll('[required]'));

    for (const el of requiredEls) {
      // skip disabled elements
      if (el.disabled) continue;

      const tag = el.tagName.toLowerCase();
      const type = (el.getAttribute('type') || '').toLowerCase();

      // radio/checkbox groups: validate once per name
      if ((type === 'radio' || type === 'checkbox')) {
        const name = el.getAttribute('name');
        if (!name) continue;
        if (handledGroups.has(name)) continue;
        handledGroups.add(name);

        const group = form.querySelectorAll(`[name="${name}"]`);
        const anyChecked = Array.from(group).some(i => i.checked);

        if (!anyChecked) {
          showGroupFeedback(el, messages.required);
          invalid = true;
          if (!firstInvalidEl) firstInvalidEl = el;
        }
        continue;
      }

      // select (multiple)
      if (tag === 'select') {
        if (el.multiple) {
          const selectedCount = Array.from(el.selectedOptions).filter(o => o.value !== '').length;
          if (selectedCount === 0) {
            showFeedback(el, messages.minArray);
            invalid = true;
            if (!firstInvalidEl) firstInvalidEl = el;
          }
        } else {
          if (!el.value || el.value === '') {
            showFeedback(el, messages.required);
            invalid = true;
            if (!firstInvalidEl) firstInvalidEl = el;
          }
        }
        continue;
      }

      // file
      if (type === 'file') {
        if (!el.files || el.files.length === 0) {
          showFeedback(el, messages.file);
          invalid = true;
          if (!firstInvalidEl) firstInvalidEl = el;
        }
        continue;
      }

      // email
      if (type === 'email') {
        const v = (el.value || '').trim();
        if (v === '') {
          showFeedback(el, messages.required);
          invalid = true;
          if (!firstInvalidEl) firstInvalidEl = el;
        } else if (!validEmail(v)) {
          showFeedback(el, messages.email);
          invalid = true;
          if (!firstInvalidEl) firstInvalidEl = el;
        }
        continue;
      }

      // number
      if (type === 'number') {
        const v = (el.value || '').trim();
        if (v === '') {
          showFeedback(el, messages.required);
          invalid = true;
          if (!firstInvalidEl) firstInvalidEl = el;
        } else if (!validNumber(v)) {
          showFeedback(el, messages.number);
          invalid = true;
          if (!firstInvalidEl) firstInvalidEl = el;
        }
        continue;
      }

      // other input types and textarea/date/text
      const value = (el.value || '').trim();
      if (value === '') {
        showFeedback(el, messages.required);
        invalid = true;
        if (!firstInvalidEl) firstInvalidEl = el;
      }
    } // end for

    if (invalid) {
      ev.preventDefault();
      // focus / scroll to first invalid element for UX
      if (firstInvalidEl) {
        try {
          firstInvalidEl.focus();
          const top = firstInvalidEl.getBoundingClientRect().top + window.scrollY - 120;
          window.scrollTo({ top, behavior: 'smooth' });
        } catch (e) { /* ignore */ }
      }
    } // otherwise allow submit (will go to controller)
  }); // submit

  // Remove client error when user edits value
  form.addEventListener('input', function (ev) {
    const el = ev.target;
    if (!el) return;
    if (el.classList.contains('is-invalid')) {
      el.classList.remove('is-invalid');
    }
    // remove feedback if exists
    const fb = el.parentElement ? el.parentElement.querySelector('.client-error-feedback') : null;
    if (fb) fb.remove();

    // For group inputs (radio/checkbox), remove group feedback when any change occurs
    if (el.type === 'radio' || el.type === 'checkbox') {
      const name = el.name;
      if (name) {
        const groupContainer = el.closest('.optional-field') || el.parentElement;
        const groupFb = groupContainer ? groupContainer.querySelector('.client-error-feedback') : null;
        if (groupFb) groupFb.remove();
        groupContainer && groupContainer.querySelectorAll('input.is-invalid').forEach(i => i.classList.remove('is-invalid'));
      }
    }
  });

  // Also clear server-side invalid-feedback when user changes fields (so messages don't stack)
  form.querySelectorAll('input, select, textarea').forEach(input => {
    input.addEventListener('change', function () {
      const serverFb = input.parentElement ? input.parentElement.querySelector('.invalid-feedback') : null;
      if (serverFb && serverFb.textContent.trim() === '') {
        serverFb.style.display = 'none';
      }
    });
  });

});
</script>
@endpush
@stack('styles')
@stack('scripts')
@endsection
