@extends('layouts.app')

@section('styles')
<style>
/* Styles de base améliorés */
/* Styles de base */
.form-control-lg {
    min-height: 50px;
    padding: 0.75rem 1rem;
    font-size: 1rem;
    border-radius: 0.5rem;
    border: 1px solid #dee2e6;
    background-color: #fff;
    transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
}

.form-control-lg:focus {
    border-color: #80bdff;
    box-shadow: 0 0 0 0.25rem rgba(13,110,253,.25);
    outline: 0;
}

/* Style spécifique pour le select */
select.no-nice-select {
    appearance: listbox !important;
    -webkit-appearance: listbox !important;
    -moz-appearance: listbox !important;
    background-image: none !important;
    padding-right: 0.75rem !important;
}

/* Masquer la flèche par défaut sur IE */
select.no-nice-select::-ms-expand {
    display: none;
}

/* Style des labels */
.form-label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #495057;
}

/* Labels et textes */
.form-label, .custom-select-container label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #495057;
}

/* Messages d'erreur */
.text-danger {
    display: block;
    margin-top: 0.25rem;
    font-size: 0.875rem;
    color: #dc3545;
}

/* Conteneurs et espacements */
.mb-20 {
    margin-bottom: 1.25rem;
}

.mb-25 {
    margin-bottom: 1.5rem;
}

.mb-30 {
    margin-bottom: 2rem;
}



/* Checkbox personnalisée */
.form-check-input {
    width: 1.25rem;
    height: 1.25rem;
    margin-top: 0.25rem;
    border-radius: 0.25rem;
    border: 1px solid #dee2e6;
    cursor: pointer;
}

/* Conteneur principal */
.signup-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    padding: 2rem 0;
}

.signup-card {
    background: white;
    border-radius: 1rem;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    overflow: hidden;
}

/* Image de fond */
.signup-image {
    background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0)), url('{{ asset('assets/img/hero/images.jpg') }}');
    background-size: cover;
    background-position: center;
    min-height: 100%;
    display: flex;
    align-items: flex-end;
    padding: 2rem;
    color: white;
}

/* Animations et transitions */
#cin_fields, #passport_field, #fiscal_field {
    transition: opacity 0.3s ease-in-out;
}

.rgpd-modal-panel {
    transform: translateY(20px);
    opacity: 0;
    transition: transform 0.3s ease-out, opacity 0.3s ease-out;
}

.rgpd-modal-panel.show {
    transform: translateY(0);
    opacity: 1;
}

.rgpd-modal-overlay {
    backdrop-filter: blur(0);
    transition: backdrop-filter 0.3s ease-out, background-color 0.3s ease-out;
}

.rgpd-modal.open .rgpd-modal-overlay {
    backdrop-filter: blur(4px);
}

/* Responsive */
@media (max-width: 991.98px) {
    .signup-image {
        min-height: 200px;
    }
}
</style>
@endsection

@section('content')
@php
    $locale = app()->getLocale();
    $dir = $locale === 'ar' ? 'rtl' : 'ltr';
@endphp

<div class="container my-5" dir="{{ $dir }}" lang="{{ $locale }}">
    <div class="container py-4">
        <div class="row g-0 signup-card" style="max-width: 1200px; margin: 0 auto;">
            <!-- Colonne de gauche avec l'image -->
            <div class="col-lg-5 d-none d-lg-block">
                <div class="signup-image h-100">
                  
                </div>
            </div>

            <!-- Colonne de droite avec le formulaire -->
            <div class="col-lg-7">
                <div class="p-4 p-md-5">
                    <div class="text-center mb-5">
                        
                        <h2 class="display-6 fw-bold mb-3" style="color: #d82b2a;">{{ __('site.register_title') }}</h2>
                        <p class="lead text-muted mb-0">
                            {{ __('site.register_description') }}
                        </p>
                    </div>
                    <form action="{{ route('register') }}" method="POST" novalidate>
                        @csrf
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('site.full_name_label') }}</label>
                                    <input type="text" name="nom_prenom"
                                        placeholder="{{ __('site.full_name_placeholder') }}"
                                        style="text-transform: none; direction: rtl;"
                                        class="form-control form-control-lg shadow-sm"
                                        value="{{ old('nom_prenom', request('nom_prenom')) }}">
                                    @error('nom_prenom')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="id_type_identite">{{ __('site.identity_type_label') }}</label>
                                    <select id="id_type_identite" name="id_type_identite" class="form-control form-control-lg shadow-sm no-nice-select" required style="-webkit-appearance: listbox !important; -moz-appearance: listbox !important; appearance: listbox !important;">
                                        <option value="">{{ __('site.choose_identity_placeholder') }}</option>
                                        @foreach($typesIdentite as $type_id)
                                            <option value="{{ $type_id->id_type }}" {{ old('id_type_identite') == $type_id->id_type ? 'selected' : '' }}>
                                                {{ trans_field($type_id, 'type') }}    
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('id_type_identite')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>



                            <!-- Champs CIN -->
                            <div class="col-12" id="cin_fields" style="display:none;">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">{{ __('site.cin_label') }}</label>
                                            <input type="text" name="cin" 
                                                class="form-control form-control-lg shadow-sm"
                                                value="{{ old('cin', request('cin')) }}"
                                                placeholder="{{ __('site.cin_placeholder') }}" 
                                                style="text-transform:none; direction:rtl;">
                                            @error('cin')
                                                <div class="text-danger mt-2 small">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">{{ __('site.cin_issue_date') }}</label>
                                            <input type="date" name="date_delivrance_cin" 
                                                class="form-control form-control-lg shadow-sm"
                                                value="{{ old('date_delivrance_cin', request('date_delivrance_cin')) }}"
                                                style="text-transform:none; direction:rtl;">
                                            @error('date_delivrance_cin')
                                                <div class="text-danger mt-2 small">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="mb-3">
                                            <label class="form-label">{{ __('site.cin_issue_place') }}</label>
                                            <input type="text" name="lieu_delivrance_cin" 
                                                class="form-control form-control-lg shadow-sm"
                                                value="{{ old('lieu_delivrance_cin', request('lieu_delivrance_cin')) }}"
                                                placeholder="{{ __('site.cin_issue_place_placeholder') }}" 
                                                style="text-transform:none; direction:rtl;">
                                            @error('lieu_delivrance_cin')
                                                <div class="text-danger mt-2 small">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Champs Passeport -->
                            <div class="col-12" id="passport_field" style="display:none;">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('site.passport_label') }}</label>
                                    <input type="text" name="passport" 
                                        class="form-control form-control-lg shadow-sm"
                                        value="{{ old('passport') }}"
                                        placeholder="{{ __('site.passport_placeholder') }}" 
                                        pattern="^\d{8,12}$" minlength="8" maxlength="12"
                                        style="text-transform:none; direction:rtl;">
                                    @error('passport')
                                        <div class="text-danger mt-2 small">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Champs Fiscal -->
                            <div class="col-12" id="fiscal_field" style="display:none;">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('site.fiscal_label') }}</label>
                                    <input type="text" name="num_fiscal" 
                                        class="form-control form-control-lg shadow-sm"
                                        value="{{ old('num_fiscal') }}"
                                        placeholder="{{ __('site.fiscal_placeholder') }}" 
                                        pattern="^\d{12}$" maxlength="12"
                                        style="text-transform:none; direction:rtl;">
                                    @error('num_fiscal')
                                        <div class="text-danger mt-2 small">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-12" id="passport_field" style="display:none;">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('site.passport_label') }}</label>
                                    <input type="text" name="passport" 
                                        class="form-control form-control-lg shadow-sm"
                                        value="{{ old('passport') }}"
                                        placeholder="{{ __('site.passport_placeholder') }}" 
                                        pattern="^\d{8,12}$" minlength="8" maxlength="12"
                                        style="text-transform:none; direction:rtl;">
                                    @error('passport')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-12" id="fiscal_field" style="display:none;">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('site.fiscal_label') }}</label>
                                    <input type="text" name="num_fiscal" 
                                        class="form-control form-control-lg shadow-sm"
                                        value="{{ old('num_fiscal') }}"
                                        placeholder="{{ __('site.fiscal_placeholder') }}" 
                                        pattern="^\d{12}$" maxlength="12"
                                        style="text-transform:none; direction:rtl;">
                                    @error('num_fiscal')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('site.email_label') }}</label>
                                    <input type="email" name="email" 
                                        class="form-control form-control-lg shadow-sm"
                                        placeholder="{{ __('site.email_placeholder') }}" 
                                        style="text-transform: none; direction: rtl;" 
                                        value="{{ old('email') }}">
                                    @error('email')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('site.password_label') }}</label>
                                    <div class="position-relative">
                                        <input type="password" id="password" name="mdp"
                                            class="form-control form-control-lg shadow-sm"
                                            style="text-transform: none; direction: rtl; padding-right: 45px;"
                                            placeholder="{{ __('site.password_placeholder') }}">
                                        <span onclick="togglePassword('password', this)" 
                                            class="position-absolute top-50 end-0 translate-middle-y pe-3"
                                            style="cursor: pointer; font-size: 1.2rem;">
                                            🔒
                                        </span>
                                    </div>
                                    @error('mdp')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="mb-4">
                                    <label class="form-label">{{ __('site.confirm_password_label') }}</label>
                                    <div class="position-relative">
                                        <input type="password" id="password_confirmation" name="mdp_confirmation"
                                            class="form-control form-control-lg shadow-sm"
                                            style="text-transform: none; direction: rtl; padding-right: 45px;"
                                            placeholder="{{ __('site.confirm_password_placeholder') }}">
                                        <span onclick="togglePassword('password_confirmation', this)" 
                                            class="position-absolute top-50 end-0 translate-middle-y pe-3"
                                            style="cursor: pointer; font-size: 1.2rem;">
                                            🔒
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12 mb-4">
                                <div class="form-check">
                                    <input type="checkbox" id="accept_terms" name="accept_terms" 
                                        class="form-check-input shadow-sm" 
                                        {{ old('accept_terms') ? 'checked' : '' }}>
                                    <label class="form-check-label text-dark" for="accept_terms" id="accept_terms_label" 
                                        style="cursor: pointer; font-size: 0.95rem;">
                                        {!! __('site.accept_terms_html') !!}
                                    </label>

                                                @error('accept_terms')
                                                    <div class="text-danger mt-2">{{ $message }}</div>
                                                @enderror

                                                <small class="form-text text-muted" id="rgpd-hint" style="display:block; margin-top:6px;">
                                                    {{ __('site.rgpd_hint') }}
                                                </small>
                                                </div>
                                            </div>

                                            <input type="hidden" name="accepted_at" id="accepted_at" value="{{ old('accepted_at','') }}">
                                            </div>

                                            <div id="rgpd-modal" class="rgpd-modal" aria-hidden="true" role="dialog" aria-labelledby="rgpd-title">
                                            <div class="rgpd-modal-overlay" id="rgpd-overlay"></div>
                                            <div class="rgpd-modal-panel" role="document" dir="rtl" aria-modal="true">
                                                <header class="rgpd-modal-header">
                                                <h2 id="rgpd-title">{{ __('site.rgpd_title') }}</h2>
                                                <button type="button" class="rgpd-close" id="rgpd-close" aria-label="{{ __('site.close') }}">×</button>
                                                </header>

                                                <div class="rgpd-modal-body">
                                                <h3>{{ __('site.rgpd_intro_title') }}</h3>
                                                <p>
                                                    {{ __('site.rgpd_intro_paragraph') }}
                                                </p>

                                                <h4>1. {{ __('site.rgpd_collect_title') }}</h4>
                                                <p>
                                                    {{ __('site.rgpd_collect_paragraph') }}
                                                </p>

                                                <h4>2. {{ __('site.rgpd_protect_title') }}</h4>
                                                <p>
                                                    {{ __('site.rgpd_protect_paragraph') }}
                                                </p>

                                                <h4>3. {{ __('site.rgpd_rights_title') }}</h4>
                                                <p>
                                                    {{ __('site.rgpd_rights_paragraph') }}
                                                </p>

                                                <h4>4. {{ __('site.rgpd_storage_title') }}</h4>
                                                <p>
                                                    {{ __('site.rgpd_storage_paragraph') }}
                                                </p>

                                                <h4>{{ __('site.rgpd_end_title') }}</h4>
                                                <p>{{ __('site.rgpd_end_paragraph') }}</p>

                                                </div>

                                                <footer class="rgpd-modal-footer">
                                                <button type="button" id="rgpd-decline" class="btn btn-secondary">{{ __('site.decline') }}</button>
                                                <button type="button" id="rgpd-accept" class="btn btn-primary">{{ __('site.accept_and_continue') }}</button>
                                                </footer>
                                            </div>
                                            </div>

                                            <style>
                                            .rgpd-modal { 
                                                display: none; 
                                                position: fixed; 
                                                inset: 0; 
                                                z-index: 1100; 
                                            }
                                            .rgpd-modal.open { 
                                                display: block; 
                                            }
                                            .rgpd-modal-overlay { 
                                                position: absolute; 
                                                inset: 0; 
                                                background: rgba(0,0,0,0.5); 
                                                backdrop-filter: blur(4px);
                                                transition: all 0.3s ease;
                                            }
                                            .rgpd-modal-panel { 
                                                position: relative; 
                                                max-width: 760px; 
                                                margin: 6% auto; 
                                                background: #fff; 
                                                border-radius: 1rem; 
                                                box-shadow: 0 1rem 3rem rgba(0,0,0,0.175); 
                                                overflow: hidden; 
                                                direction: rtl;
                                                transform: translateY(20px);
                                                opacity: 0;
                                                transition: all 0.3s ease;
                                            }
                                            .rgpd-modal.open .rgpd-modal-panel {
                                                transform: translateY(0);
                                                opacity: 1;
                                            }
                                            .rgpd-modal-header { 
                                                padding: 1.5rem; 
                                                border-bottom: 1px solid rgba(0,0,0,0.1); 
                                                display: flex; 
                                                justify-content: space-between; 
                                                align-items: center;
                                            }
                                            .rgpd-modal-header h2 {
                                                margin: 0;
                                                font-size: 1.5rem;
                                                color: var(--bs-primary, #0d6efd);
                                            }
                                            .rgpd-modal-body { 
                                                max-height: 60vh; 
                                                overflow: auto; 
                                                padding: 1.5rem; 
                                                text-align: right;
                                            }
                                            .rgpd-modal-body h3 {
                                                color: var(--bs-primary, #0d6efd);
                                                margin-bottom: 1rem;
                                            }
                                            .rgpd-modal-body h4 {
                                                color: var(--bs-gray-700, #495057);
                                                margin-top: 1.5rem;
                                                margin-bottom: 0.75rem;
                                            }
                                            .rgpd-modal-body p {
                                                color: var(--bs-gray-600, #6c757d);
                                                line-height: 1.6;
                                                margin-bottom: 1rem;
                                            }
                                            .rgpd-modal-footer { 
                                                padding: 1rem 1.5rem; 
                                                border-top: 1px solid rgba(0,0,0,0.1); 
                                                display: flex; 
                                                gap: 0.75rem; 
                                                justify-content: flex-end;
                                            }
                                            .rgpd-close { 
                                                background: transparent; 
                                                border: 0; 
                                                width: 2rem;
                                                height: 2rem;
                                                font-size: 1.5rem; 
                                                cursor: pointer;
                                                display: flex;
                                                align-items: center;
                                                justify-content: center;
                                                border-radius: 50%;
                                                transition: background-color 0.2s ease;
                                            }
                                            .rgpd-close:hover {
                                                background-color: rgba(0,0,0,0.1);
                                            }
                                            .btn { 
                                                padding: 0.75rem 1.5rem; 
                                                border-radius: 0.5rem; 
                                                border: 1px solid transparent; 
                                                cursor: pointer;
                                                font-size: 1rem;
                                                transition: all 0.2s ease;
                                            }
                                            .btn-primary { 
                                                background: var(--bs-primary, #0d6efd); 
                                                color: #fff; 
                                                border-color: var(--bs-primary, #0d6efd);
                                            }
                                            .btn-primary:hover {
                                                background: var(--bs-primary-dark, #0a58ca);
                                                border-color: var(--bs-primary-dark, #0a58ca);
                                            }
                                            .btn-secondary { 
                                                background: var(--bs-secondary, #6c757d); 
                                                color: #fff; 
                                                border-color: var(--bs-secondary, #6c757d);
                                            }
                                            .btn-secondary:hover {
                                                background: var(--bs-secondary-dark, #5c636a);
                                                border-color: var(--bs-secondary-dark, #5c636a);
                                            }
                                            </style>

                                        </div>
                            <div class="d-grid gap-2 mb-4">
                               <button class="btn btn-lg it-btn-orange rounded-3" type="submit">
                                    <span class="d-flex align-items-center justify-content-center">
                                        {{ __('site.create_account') }}
                                        <svg width="16" height="16" viewBox="0 0 12 13" fill="none" class="ms-2"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                fill="white" />
                                        </svg>
                                    </span>
                                </button>
                            </div>
                                    </form>

                            <div class="text-center" style="padding-bottom: 15px;">
                                <span>{{ __('site.already_have_account') }} <a href="{{ route('login') }}" class="text-decoration-none fw-bold">{{ __('site.login_button') }}</a></span>
                            </div>

                                </div>
                            </div>

                         

                        </div>
                    </div>
                </div>
   
      

<script>
document.addEventListener('DOMContentLoaded', function () {
    // Gestion Type Identité
    const select = document.getElementById('id_type_identite');
    const cinFields = document.getElementById('cin_fields');
    const passportField = document.getElementById('passport_field');
    const fiscalField = document.getElementById('fiscal_field');

    function hideAllFields() {
        cinFields.style.display = 'none';
        passportField.style.display = 'none';
        fiscalField.style.display = 'none';
    }

    function handleIdentityChange(value) {
        hideAllFields();
        if (value === '1') {
            cinFields.style.display = 'block';
        } else if (value === '2') {
            passportField.style.display = 'block';
        } else if (value === '3') {
            fiscalField.style.display = 'block';
        }
    }

    // Écouter les changements sur le select
    select.addEventListener('change', function() {
        handleIdentityChange(this.value);
    });

    // Initialisation au chargement
    if (select.value) {
        handleIdentityChange(select.value);
    }

    // Gestion RGPD
    const checkbox = document.getElementById('accept_terms');
    const modal = document.getElementById('rgpd-modal');
    const btnAccept = document.getElementById('rgpd-accept');
    const btnDecline = document.getElementById('rgpd-decline');
    const btnClose = document.getElementById('rgpd-close');
    const overlay = document.getElementById('rgpd-overlay');

    function openModal() {
        modal.classList.add('open');
        document.body.style.overflow = 'hidden';
    }

    function closeModal() {
        modal.classList.remove('open');
        document.body.style.overflow = '';
    }

    document.getElementById('accept_terms_label').addEventListener('click', function(e) {
        if (!checkbox.checked) {
            e.preventDefault();
            openModal();
        }
    });

    btnAccept.addEventListener('click', function() {
        checkbox.checked = true;
        closeModal();
    });

    btnDecline.addEventListener('click', function() {
        checkbox.checked = false;
        closeModal();
    });

    btnClose.addEventListener('click', closeModal);
    overlay.addEventListener('click', closeModal);
});
</script>

<script>
    function togglePassword(id, el) {
        const input = document.getElementById(id);
        if (input.type === "password") {
            input.type = "text";
            el.textContent = "🔓";
        } else {
            input.type = "password";
            el.textContent = "🔒"; 
        }
    }
</script>

@endsection
