@extends('layouts.app')

@section('content')

@php
    $locale = app()->getLocale();
    $dir = $locale === 'ar' ? 'rtl' : 'ltr';
@endphp

<div class="min-vh-100 d-flex align-items-center py-5" dir="{{ $dir }}" lang="{{ $locale }}" style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">

    <div class="container">

        <div class="row g-0 bg-white shadow-lg rounded-4 overflow-hidden" style="max-width: 1200px; margin: 0 auto;">

            <!-- Colonne de gauche avec l'image -->

            <div class="col-lg-6 d-none d-lg-block position-relative">

              <div class="h-100" style="background: linear-gradient(rgb(109 130 222 / 15%), rgb(109 130 222 / 15%)), url('{{ asset('assets/img/hero/images.jpg') }}'); background-size: cover; background-position: center; min-height: 600px;">

                    <div class="position-absolute bottom-0 start-0 p-5 text-white">

                        

                    </div>

                </div>

            </div>



            <!-- Colonne de droite avec le formulaire -->

            <div class="col-lg-6">

                <div class="p-4 p-md-5">

                    <div class="text-center mb-4">

                        <h2 class="h3 mb-3">{{ __('site.login_title') }}</h2>

                        <p class="text-muted">{{ __('site.login_description') }}</p>

                    </div>



                    @if(session('success'))

                        <div class="alert alert-success rounded-3 border-0 shadow-sm">

                            {{ session('success') }}

                        </div>

                    @endif



                    @if($errors->any())

                        <div class="alert alert-danger rounded-3 border-0 shadow-sm">

                            {{ $errors->first() }}

                        </div>

                    @endif



                    <form action="{{ route('login') }}" method="POST" novalidate>

                        @csrf

                        <input type="hidden" name="redirectTo" value="{{ request('redirectTo') }}">

                        <div class="mb-4">

                            <label class="form-label fw-bold">{{ __('site.email_label') }}</label>

                            <input type="email" name="email" class="form-control form-control-lg rounded-3 shadow-sm" 

                                style="direction: {{ $dir === 'rtl' ? 'rtl' : 'ltr' }};" placeholder="{{ __('site.email_placeholder') }}" value="{{ old('email') }}">

                        </div>



                        <div class="mb-4">

                            <label class="form-label fw-bold">{{ __('site.password_label') }}</label>

                            <div class="position-relative">

                                <input type="password" id="mdp" name="mdp" class="form-control form-control-lg rounded-3 shadow-sm"

                                    style="direction: {{ $dir === 'rtl' ? 'rtl' : 'ltr' }}; padding-right: 45px;" placeholder="{{ __('site.password_placeholder') }}">

                                <span onclick="togglePassword('mdp', this)" 

                                    class="position-absolute top-50 end-0 translate-middle-y pe-3" 

                                    style="cursor: pointer; font-size: 1.2rem;">

                                    🔒

                                </span>

                            </div>

                        </div>



                        <div class="d-flex justify-content-between align-items-center mb-4">

                            <div class="form-check">

                                <input class="form-check-input" type="checkbox" name="remember" id="flexCheckDefault">

                                <label class="form-check-label" for="flexCheckDefault">

                                    {{ __('site.remember_me') }}

                                </label>

                            </div>

                            <a href="{{ route('password.request')}}" class="text-decoration-none">{{ __('site.forgot_password') }}</a>

                        </div>



                        <div class="d-grid gap-2 mb-4">

                            <button class="btn btn-lg it-btn-orange rounded-3" type="submit">

                                <span class="d-flex align-items-center justify-content-center">

                                    {{ __('site.login_button') }}

                                    <svg width="16" height="16" viewBox="0 0 12 13" fill="none" class="ms-2"

                                        xmlns="http://www.w3.org/2000/svg">

                                        <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"

                                            fill="white" />

                                    </svg>

                                </span>

                            </button>

                        </div>



                        <div class="text-center">

                            <span>{{ __('site.no_account_text') }} <a href="{{ route('register') }}" class="text-decoration-none fw-bold">{{ __('site.create_account') }}</a></span>

                        </div>

                    </form>

                </div>

            </div>

        </div>

    </div>

</div>



<script>

    function togglePassword(id, el) {

        const input = document.getElementById(id);

        if (input.type === "password") {

            input.type = "text";

            el.textContent = "🔓";

        } else {

            input.type = "password";

            el.textContent = "🔒"; 

        }

    }

</script>



@endsection
