@extends('layouts.app')

@section('content')

 <div class="it-about-3-area p-relative pt-30 pb-125">   <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">                <div class="container"><nav class="breadcrumb-nav" aria-label="breadcrumb">    <ol class="breadcrumb mb-0">        <li class="breadcrumb-item">            <a href="{{ route('home') }}">                <i class="bi bi-house-fill"></i>                <span>الرئيسية</span>            </a>        </li>               <li class="breadcrumb-item active" aria-current="page">تأكيد حسابك</li>    </ol></nav>             <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
                        <div class="row">
                            <div class="col-xl-6 col-lg-6">
                                <div class="it-signup-wrap">
                                    <h4 class="it-signup-title">تأكيد حسابك</h4>
                                    <p class="mb-30">
                                        لقد أرسلنا رمز تأكيد إلى بريدك الإلكتروني <strong>{{ $utilisateur->email }}</strong>.
                                        الرجاء إدخال الرمز لاستكمال التسجيل.
                                    </p>

                                    @if(session('info'))
                                        <div class="alert alert-info">{{ session('info') }}</div>
                                    @endif

                                    @if(session('success'))
                                        <div class="alert alert-success">{{ session('success') }}</div>
                                    @endif

                                    @if($errors->any())
                                        <div class="alert alert-danger">
                                            {{ $errors->first() }}
                                        </div>
                                    @endif

                                    <form action="{{ route('register.confirm', $utilisateur->id) }}" method="POST" novalidate>
                                        @csrf
                                        <div class="it-signup-input-wrap">

                                            <div class="it-signup-input mb-20">
                                                <label>رمز التأكيد</label>
                                                <input type="text" name="confirmation_code" id="confirmation_code"
                                                       style="text-transform: none; direction: ltr; text-align:center;"
                                                       placeholder="أدخل رمز التأكيد" value="{{ old('confirmation_code') }}" required>
                                                @error('confirmation_code')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="it-signup-input mb-25">
                                                <small class="text-muted" style="display:block; direction:rtl;">
                                                    إذا لم تستلم الرسالة، اضغط على "إعادة إرسال الرمز".
                                                </small>
                                            </div>

                                        </div>

                                        <div class="it-signup-btn mb-25 d-flex gap-2">
                                            <button class="it-btn-orange w-50" type="submit">
                                                <span>
                                                    <span class="text-1">تأكيد</span>
                                                    <span class="text-2">تأكيد</span>
                                                </span>
                                                <i>
                                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                            fill="white" />
                                                    </svg>
                                                </i>
                                            </button>

                                            <div style="width:50%;">
                                                <form action="{{ route('register.confirm.resend', $utilisateur->id) }}" method="POST" id="resendForm">
                                                    @csrf
                                                    <button class="it-btn-orange it-btn-outline w-100" type="submit"
                                                            style="background:#fff; color:#333; border:1px solid #ddd;">
                                                       

                                                        <span>
                                                    <span class="text-1"> إعادة إرسال الرمز</span>
                                                    <span class="text-2"> إعادة إرسال الرمز</span>
                                                </span>
                                                <i>
                                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                            fill="white" />
                                                    </svg>
                                                </i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </form>

                                    <div class="it-signup-text text-center">
                                        <span>لديك حساب بالفعل؟ <a href="{{ route('login') }}">تسجيل الدخول</a></span>
                                    </div>

                                </div>
                            </div>

                            
                        </div>
                    </div>
            
    </div>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        const resendForm = document.getElementById('resendForm');
        if (resendForm) {
            resendForm.addEventListener('submit', function (e) {
                const btn = resendForm.querySelector('button[type="submit"]');
                if (btn) {
                    btn.disabled = true;
                    const originalText = btn.textContent;
                    btn.textContent = 'جاري الإرسال...';
                    setTimeout(() => {
                        btn.disabled = false;
                        btn.textContent = originalText;
                    }, 30000); 
                }
            });
        }
    });
</script>

@endsection
