@extends('layouts.app')

@section('content')
        
<div class="projects-container p-relative pt-30 pb-125">
   <img class="it-about-shape-1" src="assets/img/shape/about-1-1.png" alt="">
    <div class="container">
        <nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">معلوماتي الشخصية</li>
    </ol>
</nav>


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
        <div class="row">
            <div class="col-xl-12">
                 <div class="it-section-title-box text-center mb-30" style="padding-top:20px;">
                    <span class="it-section-subtitle">{{ __('site.profile_section_subtitle') }}</span>
                    <h4 class="it-section-title mb-0">{{ __('site.profile_section_title') }}</h4>
                </div>
            </div>
        </div>

        <div class="row justify-content-center">
           <div class="projects-grid">

                    {{-- Messages de succès et erreurs --}}
                    @if(session('success'))
                        <div class="alert alert-success mb-4">{{ session('success') }}</div>
                    @endif

                    @if($errors->any())
                        <div class="alert alert-danger mb-4">
                            <ul class="mb-0 list-unstyled">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {{-- Affichage des informations --}}
                    <div class="project-card" id="profile-info" class="row" style="padding: 40px;">
                        <div class="col-md-6 mb-3"><strong>{{ __('site.full_name_label') }} :</strong> {{ $user->nom_prenom }}</div>
                        <div class="col-md-6 mb-3"><strong>{{ __('site.email_label') }} :</strong> {{ $user->email }}</div>
                        <div class="col-md-6 mb-3"><strong>{{ __('site.cin_label') }} :</strong> {{ $user->cin }}</div>
                        <div class="col-md-6 mb-3"><strong>{{ __('site.cin_issue_date_label') }} :</strong> {{ $user->date_delivrance_cin ? \Carbon\Carbon::parse($user->date_delivrance_cin)->format('d-m-Y') : __('site.not_specified') }}</div>
                        <div class="col-md-6 mb-3"><strong>{{ __('site.cin_issue_place_label') }} :</strong> {{ $user->lieu_delivrance_cin ?? __('site.not_specified') }}</div>
                        <div class="col-md-6 mb-3"><strong>{{ __('site.contact_phone') }} :</strong> {{ $user->tel ?? __('site.not_specified') }}</div>
                        <div class="col-12 mb-3"><strong>{{ __('site.contact_address') }} :</strong> {{ $user->adresse ?? __('site.not_specified') }}</div>

                        <div class="col-12 mt-4 text-center">
                            <button type="button" class="btn btn-success toggle-edit-btn">
                                <i class="fa fa-edit me-2"></i> {{ __('site.profile_edit_button') }}
                            </button>
                        </div>
                    </div>

                    {{-- Formulaire de modification --}}
                    <form id="profile-edit" action="{{ route('profile.update') }}" method="POST" class="d-none">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('site.full_name_label') }}</label>
                                <input type="text" name="nom_prenom" class="form-control" value="{{ $user->nom_prenom }}" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('site.email_label') }}</label>
                                <input type="email" name="email" class="form-control" value="{{ $user->email }}" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('site.cin_label') }}</label>
                                <input type="text" name="cin" class="form-control" value="{{ $user->cin }}" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('site.cin_issue_date_label') }}</label>
                                <input type="date" name="date_delivrance_cin" class="form-control" value="{{ $user->date_delivrance_cin }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('site.cin_issue_place_label') }}</label>
                                <input type="text" name="lieu_delivrance_cin" class="form-control" value="{{ $user->lieu_delivrance_cin }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('site.contact_phone') }}</label>
                                <input type="tel" name="tel" class="form-control" value="{{ $user->tel }}">
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label">{{ __('site.contact_address') }}</label>
                                <textarea name="adresse" class="form-control" rows="3">{{ $user->adresse }}</textarea>
                            </div>

                            <div class="col-12 mt-4 text-center">
                                <button type="submit" class="btn btn-orange" style="display:inline !important;"><i class="fa fa-save me-2"></i> {{ __('site.profile_save_button') }}</button>
                                <button type="button" class="btn btn-secondary ms-2 toggle-edit-btn"><i class="fa fa-times me-2"></i> {{ __('site.profile_cancel_button') }}</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>

    </div>


@endsection

@section('scripts')

<script>
jQuery(document).ready(function($) {
    function toggleEditMode() {
        $('#profile-info, #profile-edit').toggleClass('d-none');
    }

    $(document).on('click', '.toggle-edit-btn', function(e) {
        e.preventDefault();
        toggleEditMode();
    });

    $('#profile-edit').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const formData = form.serialize();

        $.ajax({
            url: form.attr('action'),
            method: 'POST',
            data: formData,
            success: function(response) {
                const successMsg = `
                    <div class="alert alert-success mb-4 text-right">
                        ${response.message || '{{ __('site.profile_update_success') }}'}
                    </div>`;
                form.prepend(successMsg);
                setTimeout(() => window.location.reload(), 1000);
            },
            error: function(xhr) {
                let errorHtml = '<ul class="mb-0 list-unstyled">';
                if (xhr.status === 422) {
                    const errors = xhr.responseJSON.errors;
                    for (let field in errors) errorHtml += `<li>${errors[field][0]}</li>`;
                    errorHtml += '</ul>';
                    form.prepend(`<div class="alert alert-danger mb-4 text-right">${errorHtml}</div>`);
                } else {
                    form.prepend(`
                        <div class="alert alert-danger mb-4 text-right">
                            <ul class="mb-0 list-unstyled">
                                <li>{{ __('site.profile_update_error') }}</li>
                            </ul>
                        </div>
                    `);
                }
            }
        });
    });
});
</script>

@endsection
