@extends('layouts.app')

@section('styles')
<style>
.custom-select-container {
    position: relative;
}

.custom-select-container select {
    width: 100%;
    height: 50px;
    padding: 10px 15px;
    font-size: 14px;
    line-height: 1.5;
    color: #333;
    background-color: #fff;
    border: 1px solid #ddd;
    border-radius: 4px;
    -webkit-appearance: menulist !important;
    -moz-appearance: menulist !important;
    appearance: menulist !important;
    cursor: pointer;
}

.custom-select-container select:focus {
    border-color: #80bdff;
    outline: 0;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25);
}

.custom-select-container select:hover {
    border-color: #80bdff;
}

.custom-select-container label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #333;
}
</style>
@endsection

@section('content')

            <div class="it-signup-area pt-300 pb-0" dir="rtl">
                    <div class="it-signup-bg gray-bg fix p-relative">
                        <div class="row">
                            <div class="col-xl-6 col-lg-6">
                                <div class="it-signup-wrap">
                                    <h4 class="it-signup-title">إنشاء حساب جديد</h4>
                                    <p class="mb-30">
                                        الرجاء ملء البيانات التالية لإتمام عملية التسجيل.
                                    </p>
                                    <form action="{{ route('register') }}" method="POST" novalidate>
                                        @csrf
                                        <div class="row it-signup-input-wrap">
                                            <div class="col-md-6">
                                                <div class="it-signup-input mb-20">
                                                    <label>الاسم واللقب</label>
                                                    <input type="text" name="nom_prenom"
                                                        placeholder="أدخل الاسم واللقب"
                                                        style="text-transform: none; direction: rtl;"
                                                        class="form-control"
                                                        value="{{ old('nom_prenom', request('nom_prenom')) }}">
                                                    @error('nom_prenom')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="it-signup-input mb-20 custom-select-container">
                                                    <label for="id_type_identite">نوع الهوية الشخصية</label>
                                                    <select id="id_type_identite" name="id_type_identite" class="no-nice-select" required>
                                                        <option value="">-- اختر نوع الهوية --</option>
                                                        @foreach($typesIdentite as $type)
                                                            <option value="{{ $type->id_type }}" {{ old('id_type_identite') == $type->id_type ? 'selected' : '' }}>
                                                                {{ $type->type_ar }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    @error('id_type_identite')
                                                        <span class="text-danger mt-1 d-block">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>



                                            <div class="col-md-12" id="cin_fields" style="display:none;">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="it-signup-input mb-20">
                                                            <label>رقم بطاقة التعريف الوطنية</label>
                                                            <input type="text" name="cin" value="{{ old('cin', request('cin')) }}"
                                                                placeholder="أدخل رقم بطاقة التعريف" style="text-transform:none; direction:rtl;">
                                                            @error('cin')<span class="text-danger">{{ $message }}</span>@enderror
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="it-signup-input mb-20">
                                                            <label>تاريخ الإصدار</label>
                                                            <input type="date" name="date_delivrance_cin" value="{{ old('date_delivrance_cin', request('date_delivrance_cin')) }}"
                                                                style="text-transform:none; direction:rtl;">
                                                            @error('date_delivrance_cin')<span class="text-danger">{{ $message }}</span>@enderror
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="it-signup-input mb-20">
                                                            <label>مكان الإصدار</label>
                                                            <input type="text" name="lieu_delivrance_cin" value="{{ old('lieu_delivrance_cin', request('lieu_delivrance_cin')) }}"
                                                                placeholder="أدخل مكان الإصدار" style="text-transform:none; direction:rtl;">
                                                            @error('lieu_delivrance_cin')<span class="text-danger">{{ $message }}</span>@enderror
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-12" id="passport_field" style="display:none;">
                                                <div class="it-signup-input mb-20">
                                                    <label>رقم جواز السفر</label>
                                                    <input type="text" name="passport" value="{{ old('passport') }}"
                                                        placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12"
                                                        style="text-transform:none; direction:rtl;">
                                                    @error('passport')<span class="text-danger">{{ $message }}</span>@enderror
                                                </div>
                                            </div>

                                            <div class="col-md-12" id="fiscal_field" style="display:none;">
                                                <div class="it-signup-input mb-20">
                                                    <label>رقم المعرف الجبائي</label>
                                                    <input type="text" name="num_fiscal" value="{{ old('num_fiscal') }}"
                                                        placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12"
                                                        style="text-transform:none; direction:rtl;">
                                                    @error('num_fiscal')<span class="text-danger">{{ $message }}</span>@enderror
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="it-signup-input mb-20">
                                                    <label>البريد الإلكتروني</label>
                                                    <input type="email" name="email" placeholder="أدخل البريد الإلكتروني" style="text-transform: none; direction: rtl;" value="{{ old('email') }}">
                                                    @error('email')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="it-signup-input mb-20 position-relative">
                                                    <label>كلمة المرور</label>
                                                    <input type="password" id="password" name="mdp"
                                                        style="text-transform: none; direction: rtl; padding-right: 35px;"
                                                        placeholder="أدخل كلمة المرور">

                                                    <span onclick="togglePassword('password', this)" 
                                                        style="position:absolute; top:65%; right:10px; transform:translateY(-50%); cursor:pointer; font-size:18px;">
                                                        🔒
                                                    </span>

                                                    @error('mdp')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="it-signup-input mb-25 position-relative">
                                                    <label>تأكيد كلمة المرور</label>
                                                    <input type="password" id="password_confirmation" name="mdp_confirmation"
                                                        style="text-transform: none; direction: rtl; padding-right: 35px;"
                                                        placeholder="أعد إدخال كلمة المرور">

                                                    <span onclick="togglePassword('password_confirmation', this)" 
                                                        style="position:absolute; top:65%; right:10px; transform:translateY(-50%); cursor:pointer; font-size:18px;">
                                                        🔒
                                                    </span>
                                                </div>
                                            </div>

                                            <div class="col-md-12 mb-20">
                                            <div class="it-signup-input">
                                                <div class="form-group" style="direction: rtl;">
                                                <div style="display:flex; align-items:center; gap:8px;">
                                                    <input type="checkbox" id="accept_terms" name="accept_terms" class="custom-control-input" {{ old('accept_terms') ? 'checked' : '' }}>
                                                    <label for="accept_terms" id="accept_terms_label" style="cursor:pointer; line-height:1.6;">
                                                    أوافق على  <strong>سياسة الخصوصية</strong> و <strong>  الشروط العامة للاستخدام </strong> 
                                                    </label>
                                                </div>

                                                @error('accept_terms')
                                                    <div class="text-danger mt-2">{{ $message }}</div>
                                                @enderror

                                                <small class="form-text text-muted" id="rgpd-hint" style="display:block; margin-top:6px;">
                                                    يمكنك قراءة الشروط وسياسة الخصوصية قبل المتابعة. سيتم حفظ موافقتك بشكل آمن.
                                                </small>
                                                </div>
                                            </div>

                                            <input type="hidden" name="accepted_at" id="accepted_at" value="{{ old('accepted_at','') }}">
                                            </div>

                                            <div id="rgpd-modal" class="rgpd-modal" aria-hidden="true" role="dialog" aria-labelledby="rgpd-title">
                                            <div class="rgpd-modal-overlay" id="rgpd-overlay"></div>
                                            <div class="rgpd-modal-panel" role="document" dir="rtl" aria-modal="true">
                                                <header class="rgpd-modal-header">
                                                <h2 id="rgpd-title">الشروط والأحكام وسياسة الخصوصية</h2>
                                                <button type="button" class="rgpd-close" id="rgpd-close" aria-label="إغلاق">×</button>
                                                </header>

                                                <div class="rgpd-modal-body">
                                                <h3>مقدمة</h3>
                                                <p>
                                                    مرحبًا بكم. قبل إنشاء الحساب، يرجى قراءة الشروط والأحكام وسياسة الخصوصية بعناية. باستخدامك لهذا الموقع، فإنك توافق على شروط الاستخدام التالية:
                                                </p>

                                                <h4>1. جمع البيانات واستخدامها</h4>
                                                <p>
                                                    نقوم بجمع بعض المعلومات الشخصية مثل الاسم الكامل، البريد الإلكتروني، ورقم بطاقة التعريف الوطنية (CIN) بغرض التحقق من الهوية وتقديم الخدمات وتشغيل الحساب.
                                                </p>

                                                <h4>2. حماية البيانات</h4>
                                                <p>
                                                    نحرص على حماية بياناتك واتخاذ إجراءات تقنية وتنظيمية مناسبة لمنع الوصول غير المصرح به أو التسريب.
                                                </p>

                                                <h4>3. حقوقك</h4>
                                                <p>
                                                    لديك الحق في طلب الوصول إلى بياناتك، تصحيحها أو حذفها وفقًا للقوانين المعمول بها. لمزيد من المعلومات، تواصل معنا عبر البريد الإلكتروني.
                                                </p>

                                                <h4>4. حفظ الأدلة</h4>
                                                <p>
                                                    عند موافقتك، سيتم حفظ طابع زمني (timestamp) وعنوان IP كدليل على قبولك للشروط. قد نستخدم هذه البيانات للامتثال للالتزامات القانونية.
                                                </p>

                                                <h4>نهاية</h4>
                                                <p>إذا وافقت على المحتوى أعلاه اضغط "أوافق" لمتابعة إنشاء الحساب.</p>

                                                </div>

                                                <footer class="rgpd-modal-footer">
                                                <button type="button" id="rgpd-decline" class="btn btn-secondary">رفض</button>
                                                <button type="button" id="rgpd-accept" class="btn btn-primary">أوافق وأتابع</button>
                                                </footer>
                                            </div>
                                            </div>

                                            <style>
                                            .rgpd-modal { display: none; position: fixed; inset: 0; z-index: 1100; }
                                            .rgpd-modal.open { display: block; }
                                            .rgpd-modal-overlay { position: absolute; inset: 0; background: rgba(0,0,0,0.5); }
                                            .rgpd-modal-panel { position: relative; max-width: 760px; margin: 6% auto; background: #fff; border-radius: 8px; box-shadow: 0 8px 24px rgba(0,0,0,0.2); overflow: hidden; direction: rtl; }
                                            .rgpd-modal-header { padding: 16px 20px; border-bottom: 1px solid #eee; display:flex; justify-content:space-between; align-items:center; }
                                            .rgpd-modal-body { max-height: 60vh; overflow:auto; padding: 16px 20px; text-align: right; }
                                            .rgpd-modal-footer { padding: 12px 20px; border-top:1px solid #eee; display:flex; gap:10px; justify-content:flex-end; }
                                            .rgpd-close { background:transparent; border:0; font-size:22px; cursor:pointer; }
                                            .btn { padding: 8px 14px; border-radius:6px; border:1px solid transparent; cursor:pointer; }
                                            .btn-primary { background:#007bff; color:#fff; border-color:#007bff; }
                                            .btn-secondary { background:#6c757d; color:#fff; border-color:#6c757d; }
                                            </style>

                                        </div>
                                        <div class="it-signup-btn mb-25">
                                            <button class="it-btn-orange w-100" type="submit">
                                                <span>
                                                    <span class="text-1">إنشاء حساب</span>
                                                    <span class="text-2">إنشاء حساب</span>
                                                </span>
                                                <i>
                                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                            fill="white" />
                                                    </svg>
                                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                            fill="white" />
                                                    </svg>
                                                </i>
                                            </button>
                                        </div>
                                    </form>

                                    <div class="it-signup-text text-center">
                                        <span>لديك حساب بالفعل؟ <a href="{{ route('login') }}">تسجيل الدخول</a></span>
                                    </div>

                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-6">
                                <div class="it-signup-logo z-index-1">
                                    <img src="assets/img/logo/signup.png" alt="" style="width: 256px;">
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
   
      

<script>
document.addEventListener('DOMContentLoaded', function () {
    try {
        // ----------------------
        // Gestion RGPD / Modal
        // ----------------------
        const checkbox = document.getElementById('accept_terms');
        const label = document.getElementById('accept_terms_label');
        const modal = document.getElementById('rgpd-modal');
        const overlay = document.getElementById('rgpd-overlay');
        const btnAccept = document.getElementById('rgpd-accept');
        const btnDecline = document.getElementById('rgpd-decline');
        const btnClose = document.getElementById('rgpd-close');
        const acceptedAtInput = document.getElementById('accepted_at');
        const form = document.querySelector('form[action="{{ route('register') }}"]') || document.querySelector('form');

        function openModal() {
            modal.classList.add('open');
            modal.setAttribute('aria-hidden', 'false');
            document.body.style.overflow = 'hidden';
        }
        function closeModal() {
            modal.classList.remove('open');
            modal.setAttribute('aria-hidden', 'true');
            document.body.style.overflow = '';
        }

        if(label && checkbox) {
            label.addEventListener('click', function(e) {
                if (!checkbox.checked) {
                    e.preventDefault(); 
                    openModal();
                }
            });
        }

        if(btnAccept) btnAccept.addEventListener('click', function () {
            checkbox.checked = true;
            if(acceptedAtInput) acceptedAtInput.value = new Date().toISOString();
            closeModal();
        });

        if(btnDecline) btnDecline.addEventListener('click', function () {
            checkbox.checked = false;
            if(acceptedAtInput) acceptedAtInput.value = '';
            closeModal();
        });

        if(btnClose) btnClose.addEventListener('click', closeModal);
        if(overlay) overlay.addEventListener('click', closeModal);

        if(form) {
            form.addEventListener('submit', function(e) {
                if (!checkbox.checked) {
                    e.preventDefault();
                    const hint = document.getElementById('rgpd-hint');
                    if (hint) {
                        hint.textContent = 'الرجاء الموافقة على الشروط وسياسة الخصوصية لإتمام التسجيل.';
                        hint.style.color = 'red';
                    }
                    openModal();
                    return false;
                }
            });
        }

        // ----------------------
        // Gestion Type Identité
        // ----------------------
        const select = document.getElementById('id_type_identite');
        const cinSection = document.getElementById('cin_fields');
        const passportSection = document.getElementById('passport_field');
        const fiscalSection = document.getElementById('fiscal_field');

        function setRequired(names, required) {
            names.forEach(name => {
                document.querySelectorAll(`[name="${name}"]`).forEach(el => {
                    if (required) el.setAttribute('required','required');
                    else el.removeAttribute('required');
                });
            });
        }

        function hideAll() {
            [cinSection, passportSection, fiscalSection].forEach(el => { if(el) el.style.display='none'; });
            setRequired(['cin','date_delivrance_cin','lieu_delivrance_cin','passport','num_fiscal'], false);
        }

        function showElement(el) { if(el) el.style.display='block'; }

        function showFor(value) {
            hideAll();
            if(value==='1') showElement(cinSection), setRequired(['cin','date_delivrance_cin','lieu_delivrance_cin'], true);
            else if(value==='2') showElement(passportSection), setRequired(['passport'], true);
            else if(value==='3') showElement(fiscalSection), setRequired(['num_fiscal'], true);
        }

        if(select) {
            select.addEventListener('change', function(){ showFor(this.value); });

            // initialisation
            let initialValue = select.value || '';
            if(!initialValue){
                if(document.querySelector('[name="cin"]')?.value.trim()) initialValue='1';
                else if(document.querySelector('[name="passport"]')?.value.trim()) initialValue='2';
                else if(document.querySelector('[name="num_fiscal"]')?.value.trim()) initialValue='3';
            }
            showFor(initialValue);
        }

    } catch(e) {
        console.error('Erreur dans le script global:', e);
    }
});
</script>


<script>
    function togglePassword(id, el) {
        const input = document.getElementById(id);
        if (input.type === "password") {
            input.type = "text";
            el.textContent = "🔓";
        } else {
            input.type = "password";
            el.textContent = "🔒"; 
        }
    }
</script>

<!--script>
    document.addEventListener('DOMContentLoaded', function () {
    const select = document.getElementById('id_type_identite');
    const cinSection = document.getElementById('cin_fields');
    const passportSection = document.getElementById('passport_field');
    const fiscalSection = document.getElementById('fiscal_field');

    console.log('init identity script', { selectExists: !!select, cin: !!cinSection, passport: !!passportSection, fiscal: !!fiscalSection });

    function setRequired(names, required) {
        names.forEach(name => {
        const els = document.querySelectorAll(`[name="${name}"]`);
        els.forEach(el => {
            if (required) el.setAttribute('required', 'required');
            else el.removeAttribute('required');
        });
        });
    }

    function hideAll() {
        [cinSection, passportSection, fiscalSection].forEach(sec => {
        if (!sec) return;
        if (sec.classList) sec.classList.add('d-none');
        sec.style.display = 'none';
        });
        setRequired(['cin', 'date_delivrance_cin', 'lieu_delivrance_cin', 'passport', 'num_fiscal'], false);
    }

    function showElement(sec) {
        if (!sec) return;
        if (sec.classList) sec.classList.remove('d-none');
        sec.style.display = '';
    }

    function showFor(value) {
        console.log('showFor value=', value);
        hideAll();
        if (value === '1') {
        showElement(cinSection);
        setRequired(['cin', 'date_delivrance_cin', 'lieu_delivrance_cin'], true);
        } else if (value === '2') {
        showElement(passportSection);
        setRequired(['passport'], true);
        } else if (value === '3') {
        showElement(fiscalSection);
        setRequired(['num_fiscal'], true);
        } else {
        
        }
    }

    if (!select) {
        console.error('select id_type_identite non trouvé dans la page');
        hideAll();
        return;
    }

    select.addEventListener('change', function () {
        showFor(this.value);
    });

    let initialValue = String(select.value || '');
    if (!initialValue) {
        const cinVal = (document.querySelector('[name="cin"]')?.value || '').trim();
        const passportVal = (document.querySelector('[name="passport"]')?.value || '').trim();
        const fiscalVal = (document.querySelector('[name="num_fiscal"]')?.value || '').trim();

        if (cinVal) initialValue = '1';
        else if (passportVal) initialValue = '2';
        else if (fiscalVal) initialValue = '3';
    }

    showFor(initialValue);
    });
</!--script-->


@endsection
