@extends('layouts.app')

@section('content')

<div class="projects-container p-relative pt-30 pb-125">
   <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
        <nav class="breadcrumb-nav" aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item">
                    <a href="{{ route('dashboard') }}">
                        <i class="bi bi-house-fill"></i>
                        <span>{{ __('site.breadcrumb_home') }}</span>
                    </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">{{ __('site.breadcrumb_investment') }}</li>
            </ol>
        </nav>

        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

        <div class="welcome-section">
            <span class="subtitle">{{ __('site.projects_subtitle') }}</span>
            @auth
                <h1>{{ __('site.welcome_hello', ['name' => Auth::user()->nom_prenom]) }}</h1>
            @else
                <h1>{{ __('site.welcome_hello', ['name' => '']) }}</h1>
            @endauth
            <p>{{ __('site.projects_overview') }}</p>
        </div>

        <div class="projects-grid">
            <a href="{{ route('salle-sport.index2') }}" class="project-card" aria-label="{{ __('site.project_salle_title') }}">
                <div class="project-icon">
                    <i class="ri-building-2-line"></i>
                </div>
                <h3 class="project-title">{{ __('site.project_salle_title') }}</h3>
                <p class="text-muted mb-3">{{ __('site.project_salle_desc') }}</p>
                <span class="project-link">{{ __('site.action_view_edit') }} <i class="ri-arrow-left-line"></i></span>
            </a>

            <a href="{{ route('jeune_enfant.index') }}" class="project-card" aria-label="{{ __('site.project_spaces_title') }}">
                <div class="project-icon">
                    <i class="ri-group-line"></i>
                </div>
                <h3 class="project-title">{{ __('site.project_spaces_title') }}</h3>
                <p class="text-muted mb-3">{{ __('site.project_spaces_desc') }}</p>
                <span class="project-link">{{ __('site.action_discover_more') }} <i class="ri-arrow-left-line"></i></span>
            </a>

            <a href="{{ route('jeunesse.index') }}" class="project-card" aria-label="{{ __('site.project_private_institutions_title') }}">
                <div class="project-icon">
                    <i class="ri-community-line"></i>
                </div>
                <h3 class="project-title">{{ __('site.project_private_institutions_title') }}</h3>
                <p class="text-muted mb-3">{{ __('site.project_private_institutions_desc') }}</p>
                <span class="project-link">{{ __('site.action_discover_more') }} <i class="ri-arrow-left-line"></i></span>
            </a>

            <a href="{{ route('jeunesse2.index') }}" class="project-card" aria-label="{{ __('site.project_events_title') }}">
                <div class="project-icon">
                    <i class="ri-calendar-event-line"></i>
                </div>
                <h3 class="project-title">{{ __('site.project_events_title') }}</h3>
                <p class="text-muted mb-3">{{ __('site.project_events_desc') }}</p>
                <span class="project-link">{{ __('site.action_view_details') }} <i class="ri-arrow-left-line"></i></span>
            </a>

            <a href="{{ route('formation.index') }}" class="project-card" aria-label="{{ __('site.project_training_center_title') }}">
                <div class="project-icon">
                    <i class="ri-medal-line"></i>
                </div>
                <h3 class="project-title">{{ __('site.project_training_center_title') }}</h3>
                <p class="text-muted mb-3">{{ __('site.project_training_center_desc') }}</p>
                <span class="project-link">{{ __('site.action_view_details') }} <i class="ri-arrow-left-line"></i></span>
            </a>

            <a href="{{ route('exoneration_choix') }}" class="project-card" aria-label="{{ __('site.project_tax_exemption_title') }}">
                <div class="project-icon">
                    <i class="ri-bank-line"></i>
                </div>
                <h3 class="project-title">{{ __('site.project_tax_exemption_title') }}</h3>
                <p class="text-muted mb-3">{{ __('site.project_tax_exemption_desc') }}</p>
                <span class="project-link">{{ __('site.action_view_details') }} <i class="ri-arrow-left-line"></i></span>
            </a>
        </div>
    </div>
</div>

@endsection
