@extends('layouts.app')
@section('content')


<div class="projects-container p-relative pt-30 pb-125" dir="rtl">
   <img class="it-about-shape-1" src="assets/img/shape/about-1-1.png" alt="">
    <div class="container">
     <nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('investissement_choix') }}">
                <span>اختيار نوع الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">مشاريع الإعفاء الجبائي</li>
    </ol>
</nav>


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
   
        <div class="welcome-section">
            <span class="subtitle">مشاريع الإعفاء الجبائي</span>
            <h1>مرحباً، {{ Auth::user()->nom_prenom }}</h1>
            <p>إختر نوع كراس الشروط</p>
        </div>
        <div class="projects-grid">
            <a href="{{ route('exoneration.index', ['id_type_formulaire' => 1]) }}" class="project-card">
                <div class="project-icon">
                    <i class="bi bi-building-fill"></i>
                </div>
                <h3 class="project-title">إحداث قاعة خاصة للرياضة</h3>
                <p class="text-muted mb-3">إعفاء جبائي لقاعات الرياضة</p>
                <span class="project-link">عرض التفاصيل <i class="bi bi-arrow-left-short"></i></span>
            </a>

            <a href="{{ route('exoneration.index', ['id_type_formulaire' => 3]) }}" class="project-card">
                <div class="project-icon">
                    <i class="bi bi-people-fill"></i>
                </div>
                <h3 class="project-title">الفضاءات الترفيهية للشباب و الطفولة</h3>
                <p class="text-muted mb-3">إعفاء جبائي للفضاءات الترفيهية</p>
                <span class="project-link">عرض التفاصيل <i class="bi bi-arrow-left-short"></i></span>
            </a>

            <a href="{{ route('exoneration.index', ['id_type_formulaire' => 4]) }}" class="project-card">
                <div class="project-icon">
                    <i class="bi bi-building-fill-gear"></i>
                </div>
                <h3 class="project-title">المؤسسات الشبابية الخاصة</h3>
                <p class="text-muted mb-3">إعفاء جبائي للمؤسسات الشبابية</p>
                <span class="project-link">عرض التفاصيل <i class="bi bi-arrow-left-short"></i></span>
            </a>

            <a href="{{ route('exoneration.index', ['id_type_formulaire' => 21]) }}" class="project-card">
                <div class="project-icon">
                    <i class="bi bi-calendar2-event-fill"></i>
                </div>
                <h3 class="project-title">تنظيم الأنشطة الترفيهية</h3>
                <p class="text-muted mb-3">إعفاء جبائي للأنشطة الترفيهية</p>
                <span class="project-link">عرض التفاصيل <i class="bi bi-arrow-left-short"></i></span>
            </a>

            <a href="{{ route('exoneration.index', ['id_type_formulaire' => 5]) }}" class="project-card">
                <div class="project-icon">
                    <i class="bi bi-trophy-fill"></i>
                </div>
                <h3 class="project-title">مركز التربصات و تكوين الرياضيين</h3>
                <p class="text-muted mb-3">إعفاء جبائي لمراكز التكوين</p>
                <span class="project-link">عرض التفاصيل <i class="bi bi-arrow-left-short"></i></span>
            </a>
        </div>
    </div>
</div>

@endsection