@extends('layouts.app')

@section('content')

            <div class="it-signup-area pt-300 pb-0" dir="rtl">
                <div class="container">
                    <div class="it-signup-bg gray-bg fix p-relative">
                        <div class="row">
                            <div class="col-xl-6 col-lg-6">
                                <div class="it-signup-wrap">
                                    <h4 class="it-signup-title">تسجيل الدخول</h4>
                                    <p class="mb-30">
                                        الرجاء إدخال بريدك الإلكتروني وكلمة المرور للوصول إلى حسابك.
                                    </p>

                                    @if(session('success'))
                                        <div class="alert alert-success">{{ session('success') }}</div>
                                    @endif

                                    @if($errors->any())
                                        <div class="alert alert-danger">
                                            {{ $errors->first() }}
                                        </div>
                                    @endif

                                    <form action="{{ route('login') }}" method="POST" novalidate>
                                        @csrf
                                        <div class="it-signup-input-wrap">


                                            <div class="it-signup-input mb-20">
                                                <label>البريد الإلكتروني</label>
                                                <input type="email" name="email" style="text-transform: none; direction: rtl;" placeholder="أدخل البريد الإلكتروني" value="{{ old('email') }}">
                                                
                                            </div>

                                            <div class="it-signup-input mb-25 position-relative">
                                                <label>كلمة المرور</label>
                                                <input type="password" id="mdp" name="mdp"
                                                    style="text-transform: none; direction: rtl; padding-right: 35px;"
                                                    placeholder="أدخل كلمة المرور">

                                                <span onclick="togglePassword('mdp', this)" 
                                                    style="position:absolute; top:50%; right:10px; transform:translateY(-50%); cursor:pointer; font-size:18px;">
                                                    🔒
                                                </span>

                                                
                                            </div>
                                        </div>

                                        <div class="it-signup-forget d-flex justify-content-between flex-wrap">
                                            <div class="it-contact-agree mb-20">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="remember" id="flexCheckDefault">
                                                    <label class="form-check-label" for="flexCheckDefault">
                                                        تذكرني
                                                    </label>
                                                </div>
                                            </div>
                                            <a class="mb-20" href="{{ route('password.request')}}">نسيت كلمة المرور؟</a>
                                        </div>

                                        <div class="it-signup-btn mb-25">
                                            <button class="it-btn-orange w-100" type="submit">
                                                <span>
                                                    <span class="text-1">تسجيل الدخول</span>
                                                    <span class="text-2">تسجيل الدخول</span>
                                                </span>
                                                <i>
                                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                            fill="white" />
                                                    </svg>
                                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                            fill="white" />
                                                    </svg>
                                                </i>
                                            </button>
                                        </div>
                                    </form>

                                    <div class="it-signup-text text-center">
                                        <span>ليس لديك حساب؟ <a href="{{ route('register') }}">إنشاء حساب</a></span> 
                                    </div>

                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-6">
                                <div class="it-signup-logo z-index-1">
                                    <img src="assets/img/logo/sign.png" alt="" style="width: 256px;">                 
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
      

<script>
    function togglePassword(id, el) {
        const input = document.getElementById(id);
        if (input.type === "password") {
            input.type = "text";
            el.textContent = "🔓";
        } else {
            input.type = "password";
            el.textContent = "🔒"; 
        }
    }
</script>

@endsection
