@extends('layouts.app')

@section('styles')
<style>
/* --- RTL Global --- */
body {
    direction: rtl;
    text-align: right;
    font-family: 'Cairo', sans-serif;
}

/* --- Section principale --- */
.card {
    border-radius: 15px;
    border: 1px solid #e0e0e0;
    background: #fff;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
    transition: all 0.3s ease;
}

/* Effet au survol pour dynamisme */
.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 12px 30px rgba(0, 0, 0, 0.2);
}


/* --- Labels et Inputs --- */
.form-label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #333;
}

.form-control {
    margin-bottom: 1rem;
    border-radius: 10px;
    border: 1px solid #ccc;
    padding: 10px 15px;
    text-align: right;
    transition: border-color 0.3s ease;
}

.form-control:focus {
    border-color: #ff6600;
    box-shadow: 0 0 4px rgba(255, 102, 0, 0.4);
}

/* --- Boutons personnalisés (rouge vif) --- */
.it-btn-red, .it-btn-secondary {
    border: none;
    border-radius: 10px;
    padding: 10px 25px;
    font-weight: bold;
    transition: all 0.3s ease;
    box-shadow: 0 3px 8px rgba(0,0,0,0.15);
}

/* Bouton principal rouge */
.it-btn-red {
    background-color: #dc3545; /* rouge vif */
    color: #fff;
}

.it-btn-red:hover {
    background-color: #b52a37;
    transform: translateY(-2px);
}

/* Bouton secondaire gris */
.it-btn-secondary {
    background-color: #6c757d;
    color: #fff;
}

.it-btn-secondary:hover {
    background-color: #5a6268;
    transform: translateY(-2px);
}


/* --- Messages d’alerte --- */
.alert {
    border-radius: 10px;
    direction: rtl;
    text-align: right;
}

/* --- Titres et structure --- */
.it-section-title-box span {
    font-size: 1.2rem;
    color: #ff6600;
}

.it-section-title {
    font-weight: 700;
    color: #333;
}

/* --- Animation au basculement --- */
#profile-edit, #profile-info {
    transition: opacity 0.3s ease;
}

.it-section-subtitle {
    color: #dc3545 !important; /* rouge vif */
    font-weight: 600;
    font-size: 18px;
    letter-spacing: 0.5px;
}




.btn-back {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    background-color: #dc3545; /* rouge vif */
    color: #fff !important;
    font-weight: 600;
    padding: 10px 22px;
    border-radius: 30px;
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 3px 8px rgba(220, 53, 69, 0.25);
    direction: rtl; /* pour alignement naturel en arabe */
}

.btn-back:hover {
    background-color: #b52a37;
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(220, 53, 69, 0.35);
}

.btn-back i {
    font-size: 18px;
    margin-left: 6px; /* espace entre l'icône et le texte */
}
</style>
@endsection

@section('content')
<div class="it-about-3-area p-relative pt-90 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
        <div class="container mt-4 mb-2 text-end">
               <a href="{{ route('dashboard') }}" class="btn-back">
                  <span>رجوع</span>
                  <i class="bi bi-arrow-left-circle-fill"></i>
                  
               </a>
            </div>
            <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

        <div class="row">
            <div class="col-xl-12">
                <div class="it-section-title-box text-center mb-65" style="padding-top:50px;">
                    <span class="it-section-subtitle">معلوماتي الشخصية</span>
                    <h4 class="it-section-title mb-0">عرض بيانات الحساب</h4>
                </div>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card p-4 shadow-sm">

                    {{-- Messages de succès et erreurs --}}
                    @if(session('success'))
                        <div class="alert alert-success mb-4">{{ session('success') }}</div>
                    @endif

                    @if($errors->any())
                        <div class="alert alert-danger mb-4">
                            <ul class="mb-0 list-unstyled">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    {{-- Affichage des informations --}}
                    <div id="profile-info" class="row" style="padding: 40px;">
                        <div class="col-md-6 mb-3"><strong>الاسم الكامل :</strong> {{ $user->nom_prenom }}</div>
                        <div class="col-md-6 mb-3"><strong>البريد الإلكتروني :</strong> {{ $user->email }}</div>
                        <div class="col-md-6 mb-3"><strong>رقم بطاقة التعريف الوطنية :</strong> {{ $user->cin }}</div>
                        <div class="col-md-6 mb-3"><strong>تاريخ الإصدار :</strong> {{ $user->date_delivrance_cin ? \Carbon\Carbon::parse($user->date_delivrance_cin)->format('d-m-Y') : '---' }}</div>
                        <div class="col-md-6 mb-3"><strong>مكان الإصدار :</strong> {{ $user->lieu_delivrance_cin }}</div>
                        <div class="col-md-6 mb-3"><strong>الهاتف :</strong> {{ $user->tel ?? 'غير محدد' }}</div>
                        <div class="col-12 mb-3"><strong>العنوان :</strong> {{ $user->adresse ?? 'غير محدد' }}</div>
                        <div class="col-12 mt-4 text-center">
                            <button type="button" class="it-btn-orange toggle-edit-btn">
                                <i class="fa fa-edit me-2"></i> تعديل المعلومات
                            </button>
                        </div>
                    </div>

                    {{-- Formulaire de modification --}}
                    <form id="profile-edit" action="{{ route('profile.update') }}" method="POST" class="d-none">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الاسم الكامل</label>
                                <input type="text" name="nom_prenom" class="form-control" value="{{ $user->nom_prenom }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">البريد الإلكتروني</label>
                                <input type="email" name="email" class="form-control" value="{{ $user->email }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">رقم بطاقة التعريف الوطنية</label>
                                <input type="text" name="cin" class="form-control" value="{{ $user->cin }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">تاريخ الإصدار</label>
                                <input type="date" name="date_delivrance_cin" class="form-control" value="{{ $user->date_delivrance_cin }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">مكان الإصدار</label>
                                <input type="text" name="lieu_delivrance_cin" class="form-control" value="{{ $user->lieu_delivrance_cin }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الهاتف</label>
                                <input type="tel" name="tel" class="form-control" value="{{ $user->tel }}">
                            </div>
                            <div class="col-12 mb-3">
                                <label class="form-label">العنوان</label>
                                <textarea name="adresse" class="form-control" rows="3">{{ $user->adresse }}</textarea>
                            </div>
                            <div class="col-12 mt-4 text-center">
                                <button type="submit" class="it-btn-orange"><i class="fa fa-save me-2"></i> حفظ التغييرات</button>
                                <button type="button" class="it-btn-secondary ms-2 toggle-edit-btn"><i class="fa fa-times me-2"></i> إلغاء</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
jQuery(document).ready(function($) {
    function toggleEditMode() {
        $('#profile-info, #profile-edit').toggleClass('d-none');
    }

    $(document).on('click', '.toggle-edit-btn', function(e) {
        e.preventDefault();
        toggleEditMode();
    });

    $('#profile-edit').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const formData = form.serialize();

        $.ajax({
            url: form.attr('action'),
            method: 'POST',
            data: formData,
            success: function(response) {
                const successMsg = `
                    <div class="alert alert-success mb-4 text-right">
                        ${response.message || 'تم تحديث المعلومات بنجاح'}
                    </div>`;
                form.prepend(successMsg);
                setTimeout(() => window.location.reload(), 1000);
            },
            error: function(xhr) {
                let errorHtml = '<ul class="mb-0 list-unstyled">';
                if (xhr.status === 422) {
                    const errors = xhr.responseJSON.errors;
                    for (let field in errors) errorHtml += `<li>${errors[field][0]}</li>`;
                    errorHtml += '</ul>';
                    form.prepend(`<div class="alert alert-danger mb-4 text-right">${errorHtml}</div>`);
                } else {
                    form.prepend(`
                        <div class="alert alert-danger mb-4 text-right">
                            <ul class="mb-0 list-unstyled">
                                <li>حدث خطأ أثناء تحديث المعلومات. يرجى المحاولة مرة أخرى.</li>
                            </ul>
                        </div>
                    `);
                }
            }
        });
    });
});
</script>
@endsection
