@extends('layouts.app')

@section('content')

            <div class="it-signup-area pt-100 pb-0" dir="rtl">
                <div class="container">
                    <div class="it-signup-bg gray-bg fix p-relative">
                        <div class="row justify-content-center">
                            <div class="col-xl-6 col-lg-6">
                                <div class="it-signup-wrap">
                                    <h4 class="it-signup-title">إعادة تعيين كلمة المرور</h4>
                                    <p class="mb-30">
                                        أدخل كلمة المرور الجديدة لإعادة تعيين كلمة المرور الخاصة بحسابك.
                                    </p>

                                    @if(session('success'))
                                        <div class="alert alert-success">{{ session('success') }}</div>
                                    @endif

                                    @if($errors->any())
                                        <div class="alert alert-danger">{{ $errors->first() }}</div>
                                    @endif

                                    <form action="{{ route('password.update') }}" method="POST" novalidate>
                                        @csrf
                                        <input type="hidden" name="token" value="{{ $token }}">

                                        <div class="it-signup-input-wrap">

                                            <div class="it-signup-input mb-20">
                                                <label>البريد الإلكتروني</label>
                                                <input type="email" name="email" style="text-transform: none; direction: rtl;" value="{{ $email }}" readonly>
                                            </div>

                                            <div class="it-signup-input mb-25 position-relative">
                                                <label>كلمة المرور الجديدة</label>
                                                <input type="password" id="password" name="mdp"
                                                    style="text-transform: none; direction: rtl; padding-right: 35px;"
                                                    placeholder="أدخل كلمة المرور الجديدة">
                                                <span onclick="togglePassword('password', this)" 
                                                    style="position:absolute; top:50%; right:10px; transform:translateY(-50%); cursor:pointer; font-size:18px;">
                                                    🔒
                                                </span>
                                            </div>

                                            <div class="it-signup-input mb-25 position-relative">
                                                <label>تأكيد كلمة المرور</label>
                                                <input type="password" id="password_confirmation" name="mdp_confirmation"
                                                    style="text-transform: none; direction: rtl; padding-right: 35px;"
                                                    placeholder="أعد إدخال كلمة المرور">
                                                <span onclick="togglePassword('password_confirmation', this)" 
                                                    style="position:absolute; top:50%; right:10px; transform:translateY(-50%); cursor:pointer; font-size:18px;">
                                                    🔒
                                                </span>
                                            </div>

                                        </div>

                                        <div class="it-signup-btn mb-25">
                                            <button class="it-btn-orange w-100" type="submit">
                                                <span>
                                                    <span class="text-1">إعادة تعيين كلمة المرور</span>
                                                    <span class="text-2">إعادة تعيين كلمة المرور</span>
                                                </span>
                                            </button>
                                        </div>

                                        <div class="it-signup-text text-center">
                                            <span>تذكرت كلمة المرور؟ <a href="{{ route('login') }}">تسجيل الدخول</a></span>
                                        </div>
                                    </form>

                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-6">
                                <div class="it-signup-logo z-index-1">
                                    <img src="assets/img/logo/sign.png" alt="" style="width: 256px;">                 
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
 
<script>
function togglePassword(id, el) {
    const input = document.getElementById(id);
    if (input.type === "password") {
        input.type = "text";
        el.textContent = "🔓";
    } else {
        input.type = "password";
        el.textContent = "🔒"; 
    }
}
</script>
@endsection
