@extends('layouts.app')

@section('content')

            <div class="it-signup-area pt-0 pb-0" dir="rtl">
                <div class="container">
                    <div class="it-signup-bg gray-bg fix p-relative">
                        <div class="row justify-content-center">
                            <div class="col-xl-6 col-lg-6">
                                <div class="it-signup-wrap">
                                    <h4 class="it-signup-title">نسيت كلمة المرور</h4>
                                    <p class="mb-30">
                                        أدخل بريدك الإلكتروني وسنرسل لك رابط لإعادة تعيين كلمة المرور.
                                    </p>

                                    @if(session('success'))
                                        <div class="alert alert-success">{{ session('success') }}</div>
                                    @endif

                                    @if($errors->any())
                                        <div class="alert alert-danger">
                                            {{ $errors->first() }}
                                        </div>
                                    @endif

                                    <form action="{{ route('password.email') }}" method="POST" novalidate>
                                        @csrf
                                        <div class="it-signup-input-wrap">
                                            <div class="it-signup-input mb-20">
                                                <label>البريد الإلكتروني</label>
                                                <input type="email" name="email" style="text-transform: none; direction: rtl;" placeholder="أدخل البريد الإلكتروني" value="{{ old('email') }}">
                                               
                                            </div>
                                        </div>

                                        <div class="it-signup-btn mb-25">
                                            <button class="it-btn-orange w-100" type="submit">
                                                <span>
                                                    <span class="text-1">إرسال رابط إعادة التعيين</span>
                                                    <span class="text-2">إرسال رابط إعادة التعيين</span>
                                                </span>
                                                <i>
                                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                            fill="white" />
                                                    </svg>
                                                </i>
                                            </button>
                                        </div>

                                        <div class="it-signup-text text-center">
                                            <span>تذكرت كلمة المرور؟ <a href="{{ route('login') }}">تسجيل الدخول</a></span> 
                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    
@endsection
