@extends('layouts.app')

@section('content')
<div id="smooth-wrapper">
    <div id="smooth-content">
        <main>
            <div class="it-signup-area pt-150 pb-0" dir="rtl">
                <div class="container">
                    <div class="it-signup-bg gray-bg fix p-relative">
                        <div class="row justify-content-center">
                            <div class="col-xl-6 col-lg-6">
                                <div class="it-signup-wrap">
                                    <h4 class="it-signup-title">التحقق من رقم بطاقة التعريف</h4>
                                    <p class="mb-30">
                                        الرجاء إدخال رقم بطاقة التعريف وتاريخ الإصدار للتحقق قبل إنشاء الحساب.
                                    </p>

                                    <form id="cinForm">
    @csrf
    <div class="it-signup-input mb-20">
        <label>رقم بطاقة التعريف</label>
        <input type="text" name="cin" style="text-transform: none; direction: rtl;" class="form-control" placeholder="أدخل رقم بطاقة التعريف">
    </div>

    <div class="it-signup-input mb-25">
        <label>تاريخ الإصدار</label>
        <input type="date" name="date_delivrance_cin" class="form-control">
    </div>

    <div class="it-signup-btn mb-25">
        <button type="submit" class="it-btn-orange w-100">
            تحقق
        </button>
    </div>
</form>

<div id="result" class="mt-3"></div>


                                    <div id="result" class="mt-3"></div>

                                    <div class="it-signup-text text-center mt-3">
                                        <span>لديك حساب بالفعل؟ <a href="{{ route('login') }}">تسجيل الدخول</a></span>
                                    </div>

                                </div> 
                            </div>

                            <div class="col-xl-6 col-lg-6 d-flex justify-content-center align-items-center">
                                <div class="it-signup-logo z-index-1">
                                    <img src="assets/img/logo/signup.png" alt="" style="width: 256px;">
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<script>
document.getElementById('cinForm').addEventListener('submit', async function(e){
    e.preventDefault();

    const cin = this.cin.value.trim();
    const date = this.date_delivrance_cin.value;

    if(!cin || !date){
        document.getElementById('result').innerHTML = `<div class="alert alert-danger">الرجاء ملء جميع الحقول</div>`;
        return;
    }

    try {
        const response = await fetch("{{ url('/api/check-cin') }}", {
        method: 'POST',
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({ cin: cin, date_delivrance_cin: date })
    });

        const data = await response.json();

        if(response.ok){
            window.location.href = "{{ route('register') }}" + 
            "?cin=" + encodeURIComponent(data.data.cin) + 
            "&date_delivrance_cin=" + encodeURIComponent(data.data.date_delivrance_cin) +
            "&nom_prenom=" + encodeURIComponent(data.data.nom_prenom) +
            "&lieu_delivrance_cin=" + encodeURIComponent(data.data.lieu_delivrance_cin);

        } else {
            document.getElementById('result').innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
        }


    } catch (error) {
        console.error(error);
        document.getElementById('result').innerHTML = `<div class="alert alert-danger">حدث خطأ، حاول مرة أخرى.</div>`;
    }
});

</script>
@endsection
