// Fonction pour vérifier si un élément existe
function elementExists(id) {
    return document.getElementById(id) !== null;
}

// Rendre la fonction toggleSection globale pour qu'elle soit accessible depuis les attributs onchange
window.toggleSection = function(selectId, targetId) {
    // Vérifier si les éléments existent avant de continuer
    if (!elementExists(selectId) || !elementExists(targetId)) {
        return;
    }

    const select = document.getElementById(selectId);
    const target = document.getElementById(targetId);

    // Vérifier la valeur du select
    if (select.value === '1') {
        target.style.display = 'flex';
        target.style.flexDirection = 'column';
    } else {
        target.style.display = 'none';
        // Réinitialiser les inputs
        const inputs = target.getElementsByTagName('input');
        Array.from(inputs).forEach(input => {
            input.value = '';
        });
    }
};

// Fonction pour initialiser un select
function initializeSelect(sectionId) {
    if (!elementExists(sectionId)) {
        return;
    }

    const select = document.getElementById(sectionId);
    const targetId = 'id_' + sectionId;

    // Initialiser l'état
    toggleSection(sectionId, targetId);

    // Ajouter le listener
    select.addEventListener('change', function() {
        toggleSection(this.id, targetId);
    });
}

// Initialisation au chargement de la page
document.addEventListener('DOMContentLoaded', function() {
    // Liste des sections à initialiser
    const sections = [
        'salle_exercice',
        'piscine',
        'vestiaire',
        'unitaires_sanitaire',
        'stockage_conservation',
        'espace_exterieur',
        'garage'
    ];

    // Initialiser chaque section
    sections.forEach(initializeSelect);
});

document.addEventListener('DOMContentLoaded', function() {
    // Gestion du gouvernorat et de la délégation
    if (elementExists('gouvernorat_id') && elementExists('delegation_id')) {
        const gouvernoratSelect = document.getElementById('gouvernorat_id');
        const delegationSelect = document.getElementById('delegation_id');

        gouvernoratSelect.addEventListener('change', function() {
            const gouvernoratId = this.value;
            delegationSelect.disabled = !gouvernoratId;

            if (gouvernoratId) {
                fetch(`/delegations/${gouvernoratId}`)
                    .then(response => response.json())
                    .then(data => {
                        delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';
                        if (Array.isArray(data)) {
                            data.forEach(delegation => {
                                if (delegation && delegation.id_deleg && delegation.nom_ar) {
                                    delegationSelect.innerHTML += `<option value="${delegation.id_deleg}">${delegation.nom_ar}</option>`;
                                }
                            });
                        }
                        delegationSelect.disabled = false;
                    })
                    .catch(error => {
                        console.error('Erreur lors du chargement des délégations:', error);
                        delegationSelect.disabled = true;
                        delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';
                    });
            } else {
                delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';
                delegationSelect.disabled = true;
            }
        });
    }
});
