document.addEventListener('DOMContentLoaded', function() {
    // Liste des sections avec leurs champs
    const sections = [
        'salle_exercice',
        'piscine',
        'vestiaire',
        'unitaires_sanitaire',
        'stockage_conservation',
        'espace_exterieur',
        'garage'
    ];

    // Fonction pour basculer l'affichage d'une section
    function toggleSection(selectId, targetId) {
        const select = document.getElementById(selectId);
        const target = document.getElementById(targetId);
        
        if (select && target) {
            target.style.display = select.value === '1' ? 'block' : 'none';
            
            // Réinitialiser les champs si la section est masquée
            if (select.value === '0') {
                const inputs = target.getElementsByTagName('input');
                Array.from(inputs).forEach(input => input.value = '');
            }
        }
    }

    // Initialiser les sections
    sections.forEach(sectionId => {
        const select = document.getElementById(sectionId);
        if (select) {
            // Initialiser l'état actuel
            toggleSection(sectionId, 'id_' + sectionId);
            
            // Ajouter le listener pour les changements
            select.addEventListener('change', function() {
                toggleSection(this.id, 'id_' + this.id);
            });
        }
    });

    // Gestion du gouvernorat et de la délégation
    const gouvernoratSelect = document.getElementById('gouvernorat_id');
    const delegationSelect = document.getElementById('delegation_id');

    if (gouvernoratSelect && delegationSelect) {
        gouvernoratSelect.addEventListener('change', function() {
            const gouvernoratId = this.value;
            delegationSelect.disabled = !gouvernoratId;

            if (gouvernoratId) {
                fetch(`/delegations/${gouvernoratId}`)
                    .then(response => response.json())
                    .then(data => {
                        delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';
                        if (Array.isArray(data)) {
                            data.forEach(delegation => {
                                if (delegation && delegation.id_deleg && delegation.nom_ar) {
                                    delegationSelect.innerHTML += `<option value="${delegation.id_deleg}">${delegation.nom_ar}</option>`;
                                }
                            });
                        }
                        delegationSelect.disabled = false;
                    })
                    .catch(error => {
                        console.error('Erreur:', error);
                        delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';
                        delegationSelect.disabled = true;
                    });
            } else {
                delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';
                delegationSelect.disabled = true;
            }
        });
    }
});
