document.addEventListener('DOMContentLoaded', function() {
    // Sélection des éléments du formulaire
    const select = document.getElementById('id_type_identite');
    const cinSection = document.getElementById('cin_fields');
    const passportSection = document.getElementById('passport_field');
    const fiscalSection = document.getElementById('fiscal_field');

    // Fonction pour cacher toutes les sections
    function hideAllSections() {
        [cinSection, passportSection, fiscalSection].forEach(section => {
            if (section) {
                section.style.display = 'none';
                // Désactiver les champs requis
                section.querySelectorAll('input').forEach(input => {
                    input.required = false;
                });
            }
        });
    }

    // Fonction pour afficher une section
    function showSection(section) {
        if (section) {
            section.style.display = 'block';
            // Activer les champs requis
            section.querySelectorAll('input').forEach(input => {
                input.required = true;
            });
        }
    }

    // Fonction pour gérer le changement de type d'identité
    function handleIdentityTypeChange(value) {
        hideAllSections();
        
        switch(value) {
            case '1':
                showSection(cinSection);
                break;
            case '2':
                showSection(passportSection);
                break;
            case '3':
                showSection(fiscalSection);
                break;
        }
    }

    // Si le select existe, ajouter les écouteurs d'événements
    if (select) {
        select.addEventListener('change', function() {
            handleIdentityTypeChange(this.value);
        });

        // Initialisation avec la valeur actuelle
        handleIdentityTypeChange(select.value);
    }

    // Fonction pour basculer la visibilité du mot de passe
    window.togglePassword = function(id, el) {
        const input = document.getElementById(id);
        if (input) {
            input.type = input.type === "password" ? "text" : "password";
            el.textContent = input.type === "password" ? "🔒" : "🔓";
        }
    };
});
