// =====================
// SweetAlert2 Confirm
// =====================
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: message,
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        icon: 'warning'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}

// =====================
// Limiter input text
// =====================
document.addEventListener('DOMContentLoaded', function() {
    var textInputs = document.querySelectorAll('input[type="text"]');
    textInputs.forEach(function(input) {
        input.setAttribute('maxlength', '250');
    });
});

// =====================
// Limiter input number
// =====================
document.addEventListener('DOMContentLoaded', function() {
    function limitNumberInputDigits(selector, maxDigits) {
        document.querySelectorAll(selector).forEach(function(input) {
            input.addEventListener('input', function() {
                let value = this.value.replace(/\D/g, '');
                if (value.length > maxDigits) {
                    value = value.slice(0, maxDigits);
                }
                this.value = value;
            });
        });
    }
    limitNumberInputDigits('input[type="number"]', 15);
});


/***********  Utilisateur ***********/

// =====================
// Zone de Recherche
// =====================

function showSearchInput(value) {
        document.getElementById('searchByCIN').style.display = value === 'cin' ? 'block' : 'none';
        document.getElementById('searchByRole').style.display = value === 'role' ? 'block' : 'none';
    }
    document.addEventListener('DOMContentLoaded', function() {
        const option = document.getElementById('search-option').value;
        showSearchInput(option);
});

/***********  Salle de sport ***********/

// ===========================
// modifier statut de demande
// ===========================

function confirmStatusChange(form, currentStatus) {
    Swal.fire({
        title: 'هل تريد حقًا تغيير حالة الطلب؟',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false, 
        customClass: {
            confirmButton: 'btn btn-orange me-2', 
            cancelButton: 'btn btn-danger'       
        },
        input: 'radio',
        inputOptions: {
            '1': 'قبول',
            '3': 'رفض'
        },
        inputValidator: (value) => {
            if (!value) return 'اختر الحالة الجديدة!';
        },
        preConfirm: async (value) => {
            if (value === '3') { 
                const result = await Swal.fire({
                    title: 'أدخل سبب الرفض:',
                    input: 'text',
                    inputPlaceholder: 'سبب الرفض',
                    inputValidator: (motif) => {
                        if (!motif) return 'يجب إدخال سبب الرفض!';
                    },
                    showCancelButton: true,
                    confirmButtonText: 'تأكيد',
                    cancelButtonText: 'إلغاء',
                    reverseButtons: true,
                    buttonsStyling: false,
                    customClass: {
                        confirmButton: 'btn btn-orange me-2',
                        cancelButton: 'btn btn-danger'
                    }
                });
                if (result.isConfirmed) {
                    return { statut: value, motif: result.value };
                } else {
                    return false;
                }
            }
            return { statut: value };
        }
    }).then((result) => {
        if (!result || !result.value) return;
        const form = button.closest('form');
        const data = result.value;

      
        form.querySelectorAll('input[name="id_statut"], input[name="commentaire_motif"]').forEach(i => i.remove());

        
        const inputStatut = document.createElement('input');
        inputStatut.type = 'hidden';
        inputStatut.name = 'id_statut';
        inputStatut.value = data.statut;
        form.appendChild(inputStatut);

       
        if (data.motif) {
            const inputMotif = document.createElement('input');
            inputMotif.type = 'hidden';
            inputMotif.name = 'commentaire_motif';
            inputMotif.value = data.motif;
            form.appendChild(inputMotif);
        }

        form.submit();
    });
}

// ==================
// Zone de Recherche
// ==================
function showSearchInput2(value) {
    document.getElementById('searchByDate').style.display = value === 'date' ? 'block' : 'none';
    document.getElementById('searchByTypeIdentite').style.display = value === 'type_identite' ? 'block' : 'none';
    if(value !== 'type_identite'){
        document.getElementById('inputCIN').style.display = 'none';
        document.getElementById('inputPassport').style.display = 'none';
        document.getElementById('inputFiscal').style.display = 'none';
    }
}

function showIdentityInput2(value) {
    document.getElementById('inputCIN').style.display = value == '1' ? 'block' : 'none';
    document.getElementById('inputPassport').style.display = value == '2' ? 'block' : 'none';
    document.getElementById('inputFiscal').style.display = value == '3' ? 'block' : 'none';
}

document.addEventListener('DOMContentLoaded', function() {
    showSearchInput2(document.getElementById('search-option').value);
    showIdentityInput2(document.getElementById('type_identite_select')?.value || '');
});

// ==================
// Condition statut#2
// ==================
function openDebutActiviteForm(idImm) {
    window.location.href = "{{ route('debut_activite.create2') }}" + "?immobilier_id=" + idImm;
}

function openEditActiviteForm(idDebutActivite) {
    window.location.href = "{{ route('debut_activite.edit2', ':id') }}".replace(':id', idDebutActivite);
}

function openConsulterActiviteForm(idDebutActivite) {
    window.location.href = "{{ route('debut_activite.show2', ':id') }}".replace(':id', idDebutActivite);
}




/*-- Type Identite (create)--*/

    function showTypeIdentiteInput() {
        var select = document.getElementById('id_type_identite');
        var value = select.value;
        var fields = document.querySelectorAll('.identite-field');
        fields.forEach(f => f.style.display = 'none');

        if(value == '1') { 
            document.getElementById('cin_input').style.display = 'block';
        } else if(value == '2') { 
            document.getElementById('passport_input').style.display = 'block';
        } else if(value == '3') { 
            document.getElementById('num_fiscal_input').style.display = 'block';
        }
    }

/*-- Type Identite (edit)--*/
    function showTypeIdentiteInput2() {
    var select = document.getElementById('id_type_identite');
    if (!select) return; 
    var value = select.value;
    var fields = document.querySelectorAll('.identite-field');
    fields.forEach(f => f.style.display = 'none');

    if(value == '1') { 
        document.getElementById('cin_input').style.display = 'block';
    } else if(value == '2') { 
        document.getElementById('passport_input').style.display = 'block';
    } else if(value == '3') { 
        document.getElementById('num_fiscal_input').style.display = 'block';
    }
}
document.addEventListener('DOMContentLoaded', function() {
    showTypeIdentiteInput2();
});



function showTypeIdentiteInput3() {
    var select = document.getElementById('id_type_identite');
    if (!select) return; 

    var value = select.value;

    // Cacher tous les champs
    document.getElementById('cin_input_wrapper').style.display = 'none';
    document.getElementById('passport_field').style.display = 'none';
    document.getElementById('fiscal_field').style.display = 'none';
    document.getElementById('cin_extra_fields').style.display = 'none';

    // Afficher le champ correspondant
    if(value == '1') { 
        document.getElementById('cin_input_wrapper').style.display = 'block';
        document.getElementById('cin_extra_fields').style.display = 'flex';
    } else if(value == '2') { 
        document.getElementById('passport_field').style.display = 'block';
    } else if(value == '3') { 
        document.getElementById('fiscal_field').style.display = 'block';
    }
}

// Exécuter au chargement de la page pour pré-sélection si nécessaire
document.addEventListener('DOMContentLoaded', function() {
    showTypeIdentiteInput3();
});

/*-- Gouvernorat/Delegation --*/
/*
    document.getElementById('gouvernorat_id').addEventListener('change', function() {
        let gouvId = this.value;
        let delegationSelect = document.getElementById('delegation_id');

        delegationSelect.innerHTML = '<option value="" disabled selected>تحميل...</option>';
        delegationSelect.disabled = true;

        fetch('/delegations/' + gouvId)
            .then(response => response.json())
            .then(data => {
                delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';
                data.forEach(d => {
                    let option = document.createElement('option');
                    option.value = d.id_delegation;
                    option.text = d.nom_ar;
                    delegationSelect.add(option);
                });
            delegationSelect.disabled = false;
            });
    });
*/

/*composants immobilier */
    function toggleSection(selectId, sectionId) {
        var sel = document.getElementById(selectId);
        var section = document.getElementById(sectionId);
        if (!sel || !section) return;

        if (sel.value === '1') {
            section.style.display = 'block';
            section.querySelectorAll('input').forEach(function(inp) {
                inp.setAttribute('required','required');
            });
        } else {
            section.style.display = 'none';
            section.querySelectorAll('input').forEach(function(inp) {
                inp.removeAttribute('required');
                inp.value = '';
            });
        }
    }
    document.addEventListener('DOMContentLoaded', function() {
        ['salle_exercice','piscine','vestiaire','unitaires_sanitaire','stockage_conservation','espace_exterieur','garage']
            .forEach(function(id) {
                toggleSection(id,'id_' + id);
            });
    });

/*  Edit statut  */    
function toggleMotifInput() {
    const select = document.getElementById('id_statut');
    const motifDiv = document.getElementById('motifDiv');
    if (select.value == '3') {
        motifDiv.classList.remove('d-none');
    } else {
        motifDiv.classList.add('d-none');
    }
}
document.addEventListener('DOMContentLoaded', function() {
    toggleMotifInput();
});


/* ***********************************   Debut activite ***************************************/

function setPlaceholder() {
    const idTypeSelect = document.getElementById('id_type_identite');
    const identifiantInput = document.getElementById('identifiant');
    const messageDiv = document.getElementById('message');

    const type = idTypeSelect.value;
    if (type === "1") identifiantInput.placeholder = "ادخل رقم بطاقة التعريف الوطنية (CIN)";
    else if (type === "2") identifiantInput.placeholder = "ادخل رقم جواز السفر (Passport)";
    else if (type === "3") identifiantInput.placeholder = "ادخل الرقم التعريفي الجبائي (Num Fiscal)";
    else identifiantInput.placeholder = "ادخل رقم الهوية";

    identifiantInput.value = "";
    messageDiv.innerHTML = '';
}

function verifierIdentite() {
    const idType = document.getElementById('id_type_identite').value;
    const identifiant = document.getElementById('identifiant').value;
    const sectionIdentite = document.getElementById('sectionIdentite');
    const messageDiv = document.getElementById('message');

    const nomPrenomInput = document.getElementById('nom_prenom');
    const identifiantAffiche = document.getElementById('identifiantAffiche');
    const mandoubiaInput = document.getElementById('mandoubia');
    const utilisateurIdInput = document.getElementById('utilisateur_id');

    if (!idType || !identifiant) {
        messageDiv.innerHTML = '<div class="alert alert-warning">الرجاء اختيار نوع الهوية و إدخال الرقم</div>';
        sectionIdentite.classList.add('d-none');
        return;
    }

    fetch("/admin/debut-activite/verifier-identite", {
        method: 'POST',
        headers: {
            'Content-Type':'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ 
            id_type_identite: idType, 
            identifiant: identifiant, 
            immobilier_id: document.querySelector("input[name='immobilier_id']").value 
        })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            sectionIdentite.classList.remove('d-none');
            nomPrenomInput.value = data.user.nom_prenom;

            if (idType === "1") identifiantAffiche.value = data.user.cin ?? '';
            else if (idType === "2") identifiantAffiche.value = data.user.passport ?? '';
            else if (idType === "3") identifiantAffiche.value = data.user.num_fiscal ?? '';

            mandoubiaInput.value = data.immobilier?.gouvernorat_nom_ar ?? '';
            utilisateurIdInput.value = data.user.id;

            messageDiv.innerHTML = '<div class="alert alert-success">تم التحقق بنجاح</div>';
        } else {
            messageDiv.innerHTML = '<div class="alert alert-danger">رقم الهوية غير مطابق للمستخدم المحدد</div>';
            sectionIdentite.classList.add('d-none');
        }
    })
    .catch(() => {
        messageDiv.innerHTML = '<div class="alert alert-danger">حدث خطأ أثناء التحقق</div>';
        sectionIdentite.classList.add('d-none');
    });
}

document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('id_type_identite').addEventListener('change', setPlaceholder);
    document.getElementById('verifierBtn').addEventListener('click', verifierIdentite);
});


