// Namespace pour éviter les conflits
const SalleSportForm = {
    init: function() {
        this.setupFormValidation();
        this.setupToggleSections();
        this.setupInputLimits();
        this.setupDependentSelects();
    },

    setupFormValidation: function() {
        const form = document.querySelector('.salle-sport-form form');
        if (!form) return;

        form.addEventListener('submit', function(e) {
            // Votre logique de validation ici
        });
    },

        setupDependentSelects: function() {
        const gouvernoratSelect = document.getElementById('gouvernorat_id');
        const delegationSelect = document.getElementById('delegation_id');

        if (gouvernoratSelect && delegationSelect) {
            gouvernoratSelect.addEventListener('change', function() {
                const gouvernoratId = this.value;
                delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';

                if (gouvernoratId) {
                    // Utiliser la bonne URL pour l'API
                    fetch(`/delegations/${gouvernoratId}`)
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('Erreur réseau');
                            }
                            return response.json();
                        })
                        .then(delegations => {
                            if (Array.isArray(delegations)) {
                                delegations.forEach(d => {
                                    const option = new Option(d.nom_ar, d.id_delegation);
                                    delegationSelect.add(option);
                                });
                                delegationSelect.disabled = false;
                            } else {
                                console.error('Format de réponse inattendu:', delegations);
                            }
                        })
                        .catch(error => {
                            console.error('Erreur lors de la récupération des délégations:', error);
                        });
                } else {
                    delegationSelect.disabled = true;
                }
            });
        }
    },

        setupToggleSections: function() {
        const toggleSection = (selectId, sectionId) => {
            const select = document.getElementById(selectId);
            const section = document.getElementById(sectionId);
            if (!select || !section) return;

            const updateVisibility = () => {
                section.style.display = select.value === '1' ? 'block' : 'none';
            };

            select.addEventListener('change', updateVisibility);
            updateVisibility(); // État initial
        };

        // Liste des sections à basculer
        const sections = [
            'salle_exercice',
            'piscine',
            'vestiaire',
            'unitaires_sanitaire',
            'stockage_conservation',
            'espace_exterieur',
            'garage'
        ];

        sections.forEach(id => {
            toggleSection(id, 'id_' + id);
        });
    },

    setupInputLimits: function() {
        // Limite pour les champs texte
        document.querySelectorAll('.salle-sport-form input[type="text"]').forEach(input => {
            input.setAttribute('maxlength', '250');
        });

        // Limite pour les champs numériques
        document.querySelectorAll('.salle-sport-form input[type="number"]').forEach(input => {
            input.addEventListener('input', function() {
                let value = this.value.replace(/\D/g, '');
                if (value.length > 15) {
                    value = value.slice(0, 15);
                }
                this.value = value;
            });
        });
    }
};

// Initialisation sécurisée
document.addEventListener('DOMContentLoaded', function() {
    SalleSportForm.init();
});
