const JeuneEnfantForm = {
    init: function() {
        this.setupFormValidation();
        this.setupToggleSections();
        this.setupDependentSelects();
    },

    setupFormValidation: function() {
        // Ajoutez ici la logique de validation du formulaire si nécessaire
    },

    setupToggleSections: function() {
        const toggleSection = (selectId, sectionId) => {
            const select = document.getElementById(selectId);
            const section = document.getElementById(sectionId);
            if (!select || !section) return;

            const updateVisibility = () => {
                section.style.display = select.value === '1' ? 'block' : 'none';
            };

            select.addEventListener('change', updateVisibility);
            updateVisibility(); // État initial
        };

        // Liste des sections à basculer
        const sections = [
            'creche',
            'jardin',
            'club'
            // Ajoutez d'autres sections selon vos besoins
        ];

        sections.forEach(id => {
            toggleSection(id, 'id_' + id);
        });
    },

    setupDependentSelects: function() {
        const gouvernoratSelect = document.getElementById('gouvernorat_id');
        const delegationSelect = document.getElementById('delegation_id');

        if (gouvernoratSelect && delegationSelect) {
            gouvernoratSelect.addEventListener('change', function() {
                const gouvernoratId = this.value;
                delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';

                if (gouvernoratId) {
                    fetch(`/delegations/${gouvernoratId}`)
                        .then(response => response.json())
                        .then(delegations => {
                            delegations.forEach(d => {
                                const option = new Option(d.nom_ar, d.id_delegation);
                                delegationSelect.add(option);
                            });
                            delegationSelect.disabled = false;
                        })
                        .catch(error => {
                            console.error('Erreur:', error);
                        });
                } else {
                    delegationSelect.disabled = true;
                }
            });
        }
    }
};
