document.addEventListener('DOMContentLoaded', function() {
      const MAX_LENGTH = 100;
      const links = document.querySelectorAll(".news-title");
      links.forEach(link => {
         const text = link.textContent.trim();
         if (text.length > MAX_LENGTH) {
            link.textContent = text.substring(0, MAX_LENGTH) + "…";
         }
      });

      const languageDropdown = document.querySelector('.language-dropdown');
      const languageButton = languageDropdown.querySelector('button');
      const languageOptions = languageDropdown.querySelector('.language-options');

      languageButton.addEventListener('click', function(e) {
         e.stopPropagation();
         languageOptions.style.display = languageOptions.style.display === 'none' ? 'block' : 'none';
      });

      document.addEventListener('click', function() {
         languageOptions.style.display = 'none';
      });

      languageOptions.addEventListener('click', function(e) {
         e.stopPropagation();
      });

      const languageOptionLinks = languageOptions.querySelectorAll('.language-option');
      languageOptionLinks.forEach(link => {
         link.addEventListener('click', function(e) {
            e.preventDefault();
            const selectedLang = this.getAttribute('data-lang');
            languageOptions.style.display = 'none';
         });
      });
   });





function validatePassword() {
        const password = document.getElementById('password').value;

        const minLength = document.getElementById('min-length');
        const uppercase = document.getElementById('uppercase');
        const lowercase = document.getElementById('lowercase');
        const specialChar = document.getElementById('special-char');

        if (password.length >= 8) {
            minLength.style.color = 'green';
        } else {
            minLength.style.color = 'red';
        }

        if (/[A-Z]/.test(password)) {
            uppercase.style.color = 'green';
        } else {
            uppercase.style.color = 'red';
        }

        if (/[a-z]/.test(password)) {
            lowercase.style.color = 'green';
        } else {
            lowercase.style.color = 'red';
        }

        if (/[^A-Za-z0-9]/.test(password)) {
            specialChar.style.color = 'green';
        } else {
            specialChar.style.color = 'red';
        }
    }

