<?php
// resources/lang/fr/site.php

return [
    'current_status_label'=>' Statut actuel',
    // hero / search
    'search_title' => 'Rechercher sur le site',
    'search_placeholder' => 'Entrez un mot-clé...',
    'search_button' => 'Rechercher',

    // about (short labels)
    'about_subtitle' => 'À propos du ministère',
    'about_title' => 'Aperçu du ministère et de ses activités',
    'about_read_more' => 'Lire la suite',

    // about (main paragraph)
    'about_text' => "Le Ministère de la Jeunesse et des Sports de la République tunisienne est l'entité publique chargée du développement et de l'autonomisation de la jeunesse ainsi que de la promotion des activités sportives dans le pays. Le Ministère élabore des politiques et des programmes visant à former une génération capable de participer activement à la vie sociale et de promouvoir les valeurs nationales et culturelles.<br><br>Il facilite un environnement propice aux initiatives des jeunes, organise des événements et activités sportives, encourage les talents et soutient le développement du sport national à tous les niveaux. Le Ministère collabore avec des acteurs locaux et internationaux pour mettre en place des programmes de formation et d'éducation qui renforcent les compétences des jeunes et des sportifs.<br><br>Le Ministère joue un rôle central dans la construction d’une société active et saine, cherchant le développement durable et renforçant l’esprit sportif et les valeurs humaines.",

    // news area
    'news_subtitle' => 'Dernières actualités',
    'news_title' => 'Découvrez les dernières nouveautés',
    'news_more' => 'Plus d’actualités',
    'no_news' => "Aucune actualité pour le moment.",
    'read_more' => 'Lire la suite',
    'news_date_format_example' => 'Y.m.d',

    // services / offerings
    'services_subtitle' => 'Opportunités et services',
    'services_title' => 'Espace des opportunités et services disponibles au ministère',
    'services_competitions' => 'Concours et recrutements',
    'services_training' => 'Formations et services',
    'services_regional' => 'Délégations régionales',
    'services_library' => 'Bibliothèque du ministère',
    'services_projects' => 'Lancement de projets',
    'services_programs' => 'Programmes et activités',
    'services_apply_more' => 'En savoir plus',
    'service_read_more' => 'Lire la suite',

    // projects
    'projects_subtitle' => 'Lancement de projets',
    'projects_title' => 'Activités et projets supervisés par le ministère',
    'project_1' => 'Création d’une salle multisports',
    'project_2' => 'Espaces de loisirs pour la jeunesse et l’enfance',
    'project_3' => 'Structures sportives privées',
    'project_4' => 'Organisation d’activités récréatives pour la jeunesse et l’enfance',
    'project_5' => 'Centre de stages et formation des sportifs',

    // trophies / honors
    'trophies_subtitle' => 'Palmarès sportifs',
    'trophies_title' => 'Principales distinctions nationales et internationales',
    'trophies_browse' => 'Parcourir tout',
    'trophies_read_more' => 'En savoir plus',

    // brand / sport universities
    'sport_universities' => 'Fédérations sportives',
    'sport_universities_desc' => 'Références et données sur les fédérations sportives',

    // booking / auberges
    'book_now' => 'Réservez maintenant',
    'all_centers' => 'Tous les centres',
    'auberge_capacity_beds' => ':count lits',
    'auberge_capacity_tents' => ':count lits sous tentes',

    // contact
    'contact_subtitle' => 'Moyens de contact',
    'contact_title' => 'Contactez-nous',
    'contact_description' => 'Pour toute demande ou contact direct, veuillez utiliser les informations suivantes',
    'contact_phone' => 'Téléphone',
    'contact_email' => 'Email',
    'contact_address' => 'Adresse',
    'contact_placeholder_name' => 'Nom complet*',
    'contact_placeholder_email' => 'Adresse e-mail*',
    'contact_placeholder_phone' => 'Numéro de téléphone*',
    'contact_subject' => 'Sujet*',
    'contact_option_inquiry' => 'Demande',
    'contact_option_note' => 'Remarque',
    'contact_option_complaint' => 'Plainte',
    'contact_option_suggestion' => 'Suggestion',
    'contact_message_placeholder' => 'Message*',
    'contact_send' => 'Envoyer',
    'contact_form_title' => 'Contactez-nous',
    'contact_form_paragraph' => "Nous sommes heureux de recevoir vos questions et remarques. Nous nous efforçons toujours de vous servir avec professionnalisme et qualité.",
    'contact_address_full' => 'Rue Mohamed Ali Agid, Cité El Khadra 1003 Tunis',
    'no_image_alt' => "Pas d'image disponible",

    // CTA / misc
    'youth_centers_title' => 'Structures et centres d’hébergement pour la jeunesse en Tunisie',
    'discover_bookings' => 'Structures de jeunesse en Tunisie… découvrez et réservez directement',

    // footer
    'footer' => [
        'ministry_name' => 'Ministère de la Jeunesse et des Sports',
        'menu' => [
            'home' => 'Accueil',
            'ministry' => 'Le Ministère',
            'media' => 'Média',
            'contact' => 'Contactez-nous',
        ],
        'youth' => [
            'title' => 'Jeunesse',
            'job_offers' => 'Offres d\'emploi et concours',
            'activities' => 'Activités et programmes',
            'associations' => 'Activités des associations',
            'register_creative' => 'Inscrire un jeune créatif',
        ],
        'contact' => [
            'maps_link' => 'https://www.google.com/maps/place/%D8%B4%D8%A7%D8%B1%D8%B9+%D9%85%D8%AD%D9%85%D8%AF+%D8%B9%D9%84%D9%8A+%D8%B9%D9%82%D9%8A%D8%AF+%D8%8C+%D8%AD%D9%8A+%D8%A7%D9%84%D8%AE%D8%B6%D8%B1%D8%A7%D8%A1+1003+%D8%AA%D9%88%D9%86%D8%B3/@36.8021319,10.1799697,17z/data=!3m1!4b1!4m5!3m4!1s0x12fd338381973143:0xf26655b21ed1d308!8m2!3d36.8021319!4d10.1821584',
            'address' => 'Rue Mohamed Ali Agid, Cité El Khadra 1003 Tunis',
            'email' => 'mjsep@mjs.tn',
            'phone_display' => '71.841.433',
            'phone_link' => '+2171841433',
            'title' => 'Contactez-nous',
        ],
        'subscribe' => [
            'title' => 'Inscription',
            'text' => 'Abonnez-vous à notre bulletin hebdomadaire pour recevoir les dernières actualités et mises à jour.',
            'placeholder' => 'Entrez votre adresse e-mail',
            'button' => 'S\'abonner',
        ],
        'copyright' => [
            'prefix' => 'Tous droits réservés',
        ],
        'powered_by' => 'DataEra',
    ],

    // base site metadata
    'republic' => 'République tunisienne',
    'ministry_name' => 'Ministère de la Jeunesse et des Sports',
    'hero_contact' => 'Contactez-nous',
    'news_more_button' => 'Dernières actualités',
    'gouvernorat_title_prefix' => 'Gouvernorat',

    // booking & centers
    'booking_title' => 'Réservation',
    'booking_choose_house' => 'Choisir la maison',
    'booking_choose_house_option' => 'Choisir une maison de jeunesse',
    'sample_house_1' => 'Maison de jeunesse 1',
    'sample_house_2' => 'Maison de jeunesse 2',
    'sample_house_3' => 'Maison de jeunesse 3',
    'booking_number_places' => 'Nombre de places',
    'booking_arrival' => 'Date d\'arrivée',
    'booking_departure' => 'Date de départ',
    'booking_type' => 'Type d\'hébergement',
    'booking_type_option' => 'Choisir le type d\'hébergement',
    'booking_type_full' => 'Pension complète',
    'booking_type_half' => 'Demi-pension',
    'booking_type_no_meals' => 'Hébergement sans repas',
    'booking_submit' => 'Réserver',

    'centers_overview' => 'Moyens et centres d’hébergement pour la jeunesse',
    'centers_in_gouv_subtitle' => 'مركبات و مراكز اقامة الشباب في',
    'centers_in_gouv_title' => 'Centres de jeunesse à',
    'no_centers_in_gouv' => 'Aucun centre de jeunesse trouvé dans ce gouvernorat.',

    'beds_label' => 'lits',
    'tents_label' => 'tentes',
    'book_now' => 'Réservez maintenant',
    'all_centers' => 'Tous les centres',

    // features & map
    'about_service_title' => 'Service des maisons de jeunes',
    'about_we_offer' => 'Nous proposons :',
    'about_feature_rooms' => 'Chambres entièrement équipées',
    'about_feature_food' => 'Service de restauration',
    'about_feature_facilities' => 'Infrastructures sportives et de loisirs',
    'about_feature_prices' => 'Tarifs compétitifs',
    'map_alt' => 'Carte des maisons de jeunesse',

    'marker_tunis' => 'Maison de jeunesse Tunis',
    'marker_sousse' => 'Maison de jeunesse Sousse',
    'marker_sfaxes' => 'Maison de jeunesse Sfax',
    'marker_mednine' => 'Maison de jeunesse Médenine',
    'marker_bizerte' => 'Maison de jeunesse Bizerte',

    'login_first' => 'Connectez-vous d\'abord',
    'about_center' => 'À propos du centre',
    'services_title' => 'Services',
    'available_spaces_title' => 'Espaces disponibles',

    'space_tv' => 'Espace TV/Web',
    'space_radio' => 'Espace Radio/Web',
    'space_gaming' => 'Espace jeux vidéo',

    'sports_title' => 'Installations sportives',
    'cultural_spaces_title' => 'Lieux culturels et musées à proximité',

    'virtual_tour_label' => 'Visite virtuelle',
    'virtual_tour_subtitle' => 'Découvrez les maisons de jeunesse via une visite virtuelle à 360°',

    'contact_description' => 'Pour toute demande ou contact direct, veuillez utiliser les informations suivantes',
    'call_center' => 'Centre d\'appel',
    'call_center_desc' => 'Contactez-nous pour des demandes générales.',
    'our_location' => 'Notre emplacement',
    'find_us_on_map' => 'Découvrez notre emplacement sur la carte.',
    'location_not_specified' => '📍 L’emplacement de cet établissement n\'est pas encore défini.',

    // concours / search / results
    'breadcrumb_home' => 'Accueil',
    'concours_page_title' => 'Concours et recrutements',
    'concours_page_description' => "Liste des concours disponibles actuellement. Cliquez sur « Inscription » pour ouvrir la page d'inscription.",
    'services_subtitle' => 'Opportunités et services',
    'concours_search_placeholder' => 'Recherchez par titre de concours...',
    'reset_button' => 'Réinitialiser',
    'registration_ends' => "Fin d'inscription",
    'register_button' => "S'inscrire",
    'results_button' => 'Résultats',
    'no_concours' => "Aucun concours disponible actuellement.",
    'concours_results_title' => 'Résultats du concours',
    'results_search_placeholder' => 'Recherchez par nom / CIN / e-mail...',
    'results_prompt' => "Entrez le nom ou le numéro de carte d'identité (CIN) puis appuyez sur « Recherche » pour afficher les résultats.",
    'results_prompt_note' => "Aucun enregistrement ne sera affiché sans recherche.",

    // table headers & statuses
    'table_name' => 'Nom',
    'table_cin' => 'Numéro CIN',
    'table_email' => 'Courriel',
    'table_status' => 'État',
    'table_created_at' => 'Date de création',

    'status_acceptation_definitif' => 'Accepté (définitif)',
    'status_acceptation_primaire' => 'Accepté (primaire)',
    'status_refuse' => 'Refusé',
    'status_en_attente' => 'En attente',
    'no_results' => 'Aucun résultat correspondant à votre recherche.',

    'news_back_to_list' => 'Retour à la liste',
    'no_image_alt' => "Pas d'image disponible",
    'youtube_video' => 'Vidéo YouTube',

    // auth / login
    'login_title' => 'Connexion',
    'login_description' => "Veuillez entrer votre adresse e-mail et votre mot de passe pour accéder à votre compte.",
    'email_label' => "Adresse e-mail",
    'password_label' => 'Mot de passe',
    'email_placeholder' => "Entrez votre adresse e-mail",
    'password_placeholder' => "Entrez votre mot de passe",
    'remember_me' => 'Se souvenir de moi',
    'forgot_password' => 'Mot de passe oublié ?',
    'login_button' => 'Se connecter',
    'no_account_text' => "Vous n'avez pas de compte ?",
    'create_account' => 'Créer un compte',

    // registration
    'register_title' => 'Créer un nouveau compte',
    'register_description' => 'Veuillez remplir les informations suivantes pour compléter votre inscription.',
    'full_name_label' => 'Nom et prénom',
    'full_name_placeholder' => 'Entrez le nom et le prénom',
    'identity_type_label' => 'Type d\'identité',
    'choose_identity_placeholder' => '-- Choisir le type d\'identité --',
    'cin_label' => 'Numéro CIN',
    'cin_placeholder' => 'Entrez le numéro CIN',
    'cin_issue_date_label' => 'Date de délivrance',
    'cin_issue_place_label' => 'Lieu de délivrance',
    'cin_issue_place_placeholder' => 'Entrez le lieu de délivrance',
    'passport_label' => 'Numéro de passeport',
    'passport_placeholder' => 'Entrez le numéro de passeport',
    'fiscal_id_label' => 'Identifiant fiscal',
    'fiscal_id_placeholder' => 'Entrez l\'identifiant fiscal',
    'confirm_password_label' => 'Confirmer le mot de passe',
    'confirm_password_placeholder' => 'Confirmez le mot de passe',
    'accept_terms_html' => 'J\'accepte la <strong>politique de confidentialité</strong> et les <strong>conditions générales d\'utilisation</strong>.',
    'rgpd_hint' => 'Vous pouvez lire les conditions et la politique de confidentialité avant de continuer. Votre consentement sera enregistré en toute sécurité.',
    'rgpd_title' => 'Conditions et politique de confidentialité',
    'rgpd_body_html' => '<h3>Introduction</h3><p>Avant de créer un compte, merci de lire ... (insérez ici la version FR complète de la modal RGPD)</p>',
    'rgpd_accept' => 'J\'accepte et continuer',
    'rgpd_decline' => 'Refuser',
    'rgpd_close_label' => 'Fermer',
    'already_have_account' => 'Vous avez déjà un compte ?',
    'password_reset_title' => 'Mot de passe oublié',
    'password_reset_description' => 'Entrez votre adresse e-mail et nous vous enverrons un lien pour réinitialiser votre mot de passe.',
    'send_reset_link' => 'Envoyer le lien de réinitialisation',
    'remembered_password' => 'Vous vous souvenez de votre mot de passe ?',

    // dashboard / services
    'dashboard_welcome' => 'Bienvenue, :name',
    'dashboard_manage_services' => 'Gérez votre compte et les services disponibles',
    'service_personal_info_title' => 'Mes informations personnelles',
    'service_personal_info_desc' => 'Afficher et modifier vos informations personnelles',
    'service_personal_info_action' => 'Voir et modifier',
    'service_investment_title' => 'Investissement',
    'service_investment_desc' => 'Découvrez les opportunités d\'investissement disponibles',
    'service_investment_action' => 'Découvrir',
    'service_association_funding_title' => 'Financement des associations',
    'service_association_funding_desc' => 'Gestion des documents de financement des associations',
    'service_association_funding_action' => 'En savoir plus',
    'service_events_title' => 'Manifestations sportives',
    'service_events_desc' => 'Organisation et gestion des événements sportifs',
    'service_events_action' => 'En savoir plus',
    'service_reservations_title' => 'Mes réservations',
    'service_reservations_desc' => 'Gérer vos réservations et rendez-vous',
    'service_reservations_action' => 'Voir les détails',

    // profile / buttons
    'back' => 'Retour',
    'profile_section_subtitle' => 'Mes informations personnelles',
    'profile_section_title' => 'Afficher les informations du compte',
    'profile_edit_button' => 'Modifier les informations',
    'profile_save_button' => 'Enregistrer les modifications',
    'profile_cancel_button' => 'Annuler',

    // fallbacks
    'not_specified' => 'Non renseigné',
    'breadcrumb_home' => 'Accueil',

    // projects / miscellaneous continued
    'welcome_hello' => 'Bonjour, :name',
    'projects_overview' => 'Activités et projets sous la supervision du ministère',
    'project_salle_title' => 'Création d\'une salle privée de sport',
    'project_salle_desc' => 'Construction et gestion d\'une salle de sport privée',
    'project_spaces_title' => 'Espaces récréatifs pour la jeunesse et l\'enfance',
    'project_spaces_desc' => 'Gestion et organisation d\'activités récréatives',
    'project_private_institutions_title' => 'Institutions jeunesse privées',
    'project_private_institutions_desc' => 'Gestion et développement des institutions jeunesse',
    'project_events_title' => 'Organisation d\'activités récréatives',
    'project_events_desc' => 'Planification et mise en œuvre de programmes récréatifs',
    'project_training_center_title' => 'Centre de stages et formation des sportifs',
    'project_training_center_desc' => 'Formation et développement des compétences sportives',
    'project_tax_exemption_title' => 'Projets d\'exonération fiscale',
    'project_tax_exemption_desc' => 'Gestion et organisation des exonérations fiscales',
    'action_view_edit' => 'Afficher & modifier',
    'action_discover_more' => 'Découvrir',
    'action_view_details' => 'Voir les détails',

    // salles list / table
    'breadcrumb_salles_list' => 'Liste des salles sportives',
    'section_subtitle_requests' => 'Demandes de salles de sport',
    'section_title_all_requests' => 'Afficher toutes les demandes',
    'btn_add_request' => 'Ajouter une demande',
    'no_salles_requests' => 'Aucune demande de salle de sport.',
    'table_id' => 'ID',
    'table_deposit_date' => "Date d'enregistrement",
    'table_applicant' => "Nom du demandeur",
    'table_status' => 'Statut',
    'table_actions' => 'Actions',
    'table_start_activity' => "Début de l'activité",
    'table_tax_exemption' => "Exonération fiscale",
    'btn_view' => 'Voir',
    'btn_edit' => 'Modifier',
    'btn_delete' => 'Supprimer',

    'status_pending' => 'En attente',
    'status_accepted' => 'Accepté',
    'status_refused' => 'Refusé',
    'status_unknown' => 'Inconnu',

    'start_activity_notify' => "Informer du début d'activité",
    'start_activity_edit' => 'Modifier la demande',
    'start_activity_view' => 'Consulter la demande',

    'exoneration_add' => "Ajouter une exonération fiscale",
    'exoneration_edit' => 'Modifier la demande',
    'exoneration_view' => 'Consulter la demande',

    'yes' => 'Oui',
    'no' => 'Non',
    'component' => 'Composant',

    'print' => 'Imprimer',
    'view_file' => 'Voir le fichier',
    'not_specified' => '-',

    // exoneration form
    'exoneration' => [
        'form_title' => 'Formulaire d\'inscription à l\'exonération fiscale',
        'identity' => [
            'title' => 'Identité du porteur de projet',
        ],
        'project_name_label' => 'Nom du projet',
        'project_place_label' => 'Lieu du projet',
        'documents' => [
            'title' => 'Ajouter les pièces demandées',
            '1' => ['label' => '1- Copie du cahier des charges', 'desc' => 'Paraphée sur toutes ses pages par le porteur et accompagnée du récépissé de dépôt ou du cachet de la délégation régionale.'],
            '2' => ['label' => '2- Original du certificat de dépôt', 'desc' => 'Délivré par l\'instance compétente et listant les équipements à acquérir.'],
            '3' => ['label' => '3- Facture', 'desc' => 'Facture finale en arabe ou en français détaillant les équipements concernés.'],
            '4' => ['label' => '4- Contrat entre acheteur et fournisseur', 'desc' => 'Contient références, quantités, prix et marque, signé par les deux parties.'],
            '5' => ['label' => '5- Document d\'arrivée', 'desc' => 'Remis par le transporteur.'],
            '6' => ['label' => '6- Document d\'embarquement', 'desc' => 'Document de chargement/expédition.'],
            '7' => ['label' => '7- Copie de la carte fiscale', 'desc' => 'Copie de la carte d\'identification fiscale de l\'entreprise.'],
            '8' => ['label' => '8- Copie du registre national des établissements', 'desc' => 'Extrait du registre national des établissements.'],
            '9' => ['label' => '9- Copie du certificat de propriété', 'desc' => 'Ou contrat de vente/donation/location enregistré.'],
            '10' => ['label' => '10- Engagement', 'desc' => 'Engagement signé de non-cession des équipements pendant 5 ans.'],
            '11' => ['label' => '11- Exemple technique du projet', 'desc' => 'Plan établi par un architecte avec cachet et signature.'],
        ],
    ],

    // start activity form / document labels
    'start_activity' => [
        'form_number_label' => "N° du formulaire :",
        'form_title' => "Formulaire de déclaration de début d'activité",
        'current_status' => "Statut actuel :",
        'status' => [
            'accepted' => 'Accepté',
            'rejected' => 'Refusé',
            'pending' => 'En attente',
        ],
        'rejection_reason_label' => 'Motif du refus :',
        'owner_identity_title' => "Identité du porteur de projet",
        'owner_identity_number' => "N° d'identité",
        'start_date_label' => "Date de début d'activité",
        'start_date_hint' => "La date de début doit être au moins 15 jours après la date de dépôt du récépissé.",
        'attached_documents' => "Documents joints",
        'documents' => [
            'preuve_propriete_location' => [
                'label' => 'Copie du titre de propriété ou contrat de location',
                'desc'  => 'Copie du titre de propriété ou du contrat de location valide et enregistré.',
            ],
            'plan_architectural' => [
                'label' => 'Plan architectural',
                'desc'  => 'Plan architectural détaillant l\'agencement et les équipements.',
            ],
            'declaration_investissement' => [
                'label' => 'Attestation de déclaration d\'investissement',
                'desc'  => 'Attestation délivrée par l\'autorité compétente.',
            ],
            'identification' => [
                'label' => 'Carte d\'identité / Passeport',
                'desc'  => 'Copie de la carte d\'identité ou du passeport.',
            ],
            'extrait_registre_national_entreprise' => [
                'label' => 'Extrait du registre national des entreprises',
                'desc'  => 'Extrait du registre national des entreprises si applicable.',
            ],
            'certificat_prevention' => [
                'label' => 'Certificat de prévention',
                'desc'  => 'Certificat de conformité aux normes de prévention et sécurité.',
            ],
            'contrat_assurance' => [
                'label' => "Contrat d'assurance",
                'desc'  => "Copie du contrat d'assurance couvrant le lieu ou l'activité.",
            ],
            'approbation_autorite_minicipale' => [
                'label' => "Approbation de l'autorité locale",
                'desc'  => "Approbation ou avis de l'autorité locale le cas échéant.",
            ],
        ],
        'rejection_reason_label' => 'Motif du refus :',
    ],

    // header labels
    'header' => [
        'regional_delegation' => 'Délégation régionale de la jeunesse et des sports',
    ],

    // consolidated investment block (no duplicates)
    'investment' => [
        'label' => 'Investissement',
        'breadcrumb' => [
            'home' => 'Accueil',
            'index' => 'Investissement',
            'salles_list' => 'Liste des salles sportives',
            'add_salle' => 'Ajouter une salle sportive',
			 'add_exo' => 'Ajouter une demande d exonération',
			  'modif_exo' => 'Modifer une demande d exonération',
			    'show_exo' => 'Voir une demande d exonération',
        ],
        'detail' => 'Détails de la salle sportive',
        'form_title_salle' => "Formulaire de dépôt du cahier des charges pour la création d'une salle privée de sport",
        'view_request' => 'Consulter la demande',
        'form' => [
            'identity' => [
                'title' => 'Identité du demandeur',
            ],
            'property' => [
                'title' => 'Informations sur le bien',
            ],
            'label' => [
                'full_name' => 'Nom et prénom ou raison sociale',
                'email' => 'E-mail',
                'identity_type' => 'Type d\'identité',
                'cin' => 'Numéro CIN',
                'passport' => 'Numéro de passeport',
                'fiscal_id' => 'Identifiant fiscal',
                'cin_issue_date' => 'Date de délivrance',
                'cin_issue_place' => 'Lieu de délivrance',
                'phone' => 'Téléphone',
                'address' => 'Adresse',
                'property_address' => 'Adresse du bien',
                'gouvernorat' => 'Gouvernorat',
                'delegation' => 'Délégation',
                'property_type' => 'Type de bien',
                'surface_total' => 'Surface totale (m²)',
                'usage_type' => 'Usage du bien',
                'document_property' => 'Document de propriété',
                'other_surfaces' => 'Autres surfaces',
                'count' => 'Nombre',
                'surface' => 'Surface',
            ],
            'placeholder' => [
                'choose' => 'Choisir...',
                'loading' => 'Chargement...',
                'cin' => 'Entrez le numéro de CIN',
                'passport' => 'Entrez le numéro de passeport',
                'fiscal' => 'Entrez l\'identifiant fiscal',
                'cin_issue_place' => 'Entrez le lieu de délivrance',
                'count' => 'Nombre',
                'surface' => 'Surface (m²)',
            ],
            'validation' => [
                'property_address_max' => 'L\'adresse du bien ne doit pas dépasser 100 caractères.',
                'surface_min' => 'La surface doit être au moins 100 m².',
                'surface_hint' => 'La surface doit être au moins 100 m².',
            ],
            'button' => [
                'submit' => 'Envoyer',
            ],
            'components' => [
                'title' => 'Composition du bien',
                'exercise_hall' => 'Salle d\'exercice',
                'pool' => 'Piscine',
                'changing_rooms' => 'Vestiaires',
                'sanitary_units' => 'Unités sanitaires',
                'storage_space' => 'Espace de stockage',
                'outdoor_space' => 'Espace extérieur',
                'garage' => 'Garage / Parking',
            ],
        ],
    ],
// add/merge these into returned array
'table_project_nature' => 'Nature du projet',
'no_forms' => "Il n'y a pas de formulaires",
'confirm_edit_title' => 'Voulez-vous modifier ce formulaire ?',
'confirm_delete_title' => 'Voulez-vous supprimer ce formulaire ?',
'confirm_yes' => 'Oui',
'confirm_cancel' => 'Annuler',
'close' => 'Fermer',
  'breadcrumb_investment' => 'Investissement',
    'project_spaces_title' => 'Espaces récréatifs pour la jeunesse et l\'enfance',
    'add_form_title' => 'Ajouter un formulaire',

    // form sections & labels
    'form_section_investor' => 'Investisseur',
    'label_full_name' => 'Nom et prénom',
    'label_birth_place' => 'Lieu de naissance',
    'label_birth_date' => 'Date de naissance',
    'label_identity' => 'Identité',
    'label_issue_date' => 'Date de délivrance',
    'label_issue_place' => 'Lieu de délivrance',
    'label_address' => 'Adresse personnelle',
    'label_education_level' => 'Niveau d\'études',
    'label_last_degree' => 'Dernier diplôme obtenu',
    'label_experience' => 'Ancienneté dans l\'activité',

    // features
    'features_title' => 'Caractéristiques du projet récréatif',
    'espace_spectacle' => 'Espaces récréatifs en plein air et spectacles',
    'espace_sportif' => 'Espaces récréatifs sportifs',
    'espace_service' => 'Espace d\'activités de services',
    'espace_culturel' => 'Espace d\'activités culturelles, artistiques et scientifiques',
    'caracteristique_placeholder' => 'Particularités',

    // project nature
    'project_nature_title' => 'Nature du projet',
    'choose_nature' => 'Veuillez choisir la nature du projet',
    'choose_placeholder' => 'Choisir...',

    // number of places
    'number_places_expected' => 'Nombre de postes prévus',
    'nbr_diplome_universitaire_label' => 'Titulaire d\'un diplôme universitaire',
    'nbr_diplome_universitaire_placeholder' => 'Titulaire d\'un diplôme universitaire',
    'nbr_autre_label' => 'Autres',
    'nbr_autre_placeholder' => 'Autres',

    // manager
    'section_manager_title' => 'Directeur de l\'établissement',
    'label_director_name' => 'Nom et prénom',
    'label_director_cin' => 'N° de carte d\'identité nationale',

    // investment table
    'investment_financing_title' => 'Données sur l\'investissement et le financement',
    'investment_table_invest' => 'Investissement',
    'investment_table_amount' => 'Montant',
    'investment_table_sources' => 'Sources de financement',
    'investment_table_remarks' => 'Remarques',
    'add_row' => 'Ajouter une ligne',
    'delete' => 'Supprimer',
    'financing_hint' => '(*) Fonds propres, prêts long terme, prêts moyen terme, prêts court terme, subventions, autres sources.',

    // declaration & remarks
    'declaration_title' => 'Déclaration sur l\'honneur',
    'declaration_text' => 'Je soussigné(e) certifie l\'exactitude des informations fournies dans ce formulaire et déclare ne pas avoir fait l\'objet d\'une sanction pénale ou administrative empêchant la gestion ou l\'exercice de l\'activité.',
    'remarks_title' => 'Remarques de la délégation régionale de la jeunesse et des sports :',
    'remarks_placeholder' => 'Écrivez vos remarques ici...',

    // form actions
    'form_submit' => 'Envoyer',
// -- new/merged keys for this view (French)
'page_show_form' => 'Afficher le formulaire',
'place_of_birth' => 'Lieu de naissance',
'date_of_birth' => 'Date de naissance',
'personal_address' => 'Adresse personnelle',
'education_level' => 'Niveau d\'études',
'last_degree' => 'Dernier diplôme obtenu',
'experience_label' => 'Ancienneté dans l\'activité',
'project_characteristics' => 'Caractéristiques du projet',
'characteristics_placeholder' => 'Ses particularités',
'espace_spectacle_label' => 'Espaces de spectacle et plein air',
'espace_sportif_label' => 'Espaces sportifs récréatifs',
'espace_service_label' => 'Espace activités de services',
'espace_culturel_label' => 'Espace activités culturelles, artistiques et scientifiques',
'select_project_nature' => 'Veuillez choisir la nature du projet',
'number_positions_title' => 'Nombre de postes envisagés',
'holders_degree_label' => 'Titulaire(s) de diplôme(s)',
'others_label' => 'Autres',
'director_title' => 'Directeur de l\'établissement',
'investment_finance_title' => 'Informations sur l\'investissement et le financement',
'investment_label' => 'Investissement',
'amount_label' => 'Montant',
'fund_sources_label' => 'Sources de financement',
'notes_label' => 'Remarques',
'funds_examples' => '(*) Fonds propres, prêts long terme, prêts moyen terme, prêts court terme, subventions, autres.',
'declaration_title' => 'Déclaration sur l\'honneur',
'declaration_text' => 'Je soussigné(e) déclare l’exactitude des informations fournies dans ce formulaire et déclare n’avoir subi aucune sanction pénale ou administrative empêchant la gestion ou l’exploitation d’une structure ou d’activités prévues.',
'remarks_title' => 'Remarques de la délégation régionale',
'write_remarks_placeholder' => 'Écrivez vos remarques ici...',


];
