<?php
// resources/lang/en/site.php

return [
    // hero / search
    'search_title' => 'Search the site',
    'search_placeholder' => 'Enter a keyword...',
    'search_button' => 'Search',

    // about (short labels)
    'about_subtitle' => 'About the ministry',
    'about_title' => 'Overview of the ministry and its activities',
    'about_read_more' => 'Read more',

    // about (main paragraph - keep as HTML-safe text if needed)
    'about_text' => "The Ministry of Youth and Sports of the Tunisian Republic is the public body responsible for the development and empowerment of youth as well as the promotion of sporting activities in the country. The Ministry develops policies and programmes aimed at training a generation capable of actively participating in social life and promoting national and cultural values.<br><br>It fosters an environment conducive to youth initiatives, organises sporting events and activities, encourages talent and supports the development of sport at all levels. The Ministry cooperates with local and international actors to implement training and educational programmes that strengthen the skills of young people and athletes.<br><br>The Ministry plays a central role in building an active and healthy society, pursuing sustainable development and reinforcing the sporting spirit and human values.",

    // news area
    'news_subtitle' => 'Latest news',
    'news_title' => 'Discover the latest updates',
    'news_more' => 'More news',
    'no_news' => "No news at the moment.",
    'read_more' => 'Read more',
    'news_date_format_example' => 'Y.m.d', // optional usage hint

    // services / offerings (section)
    'services_subtitle' => 'Opportunities & services',
    'services_title' => 'Space for opportunities and services available at the ministry',
    'services_competitions' => 'Competitions & recruitments',
    'services_training' => 'Training & services',
    'services_regional' => 'Regional delegations',
    'services_library' => 'Ministry library',
    'services_projects' => 'Project launches',
    'services_programs' => 'Programs & activities',
    'services_apply_more' => 'Learn more',
    'service_read_more' => 'Read more',

    // projects / projects-carousel
    'projects_subtitle' => 'Project launches',
    'projects_title' => 'Activities and projects supervised by the ministry',
    'project_1' => 'Creation of a multisport hall',
    'project_2' => 'Recreation spaces for youth and children',
    'project_3' => 'Private sporting facilities',
    'project_4' => 'Organisation of recreational activities for youth and children',
    'project_5' => 'Training and internship centre for athletes',

    // trophies / honors
    'trophies_subtitle' => 'Sporting honours',
    'trophies_title' => 'Major national and international distinctions',
    'trophies_browse' => 'Browse all',
    'trophies_read_more' => 'Learn more',

    // brand / sport universities
    'sport_universities' => 'Sport federations',
    'sport_universities_desc' => 'References and data about sport federations',

    // booking / auberges
    'book_now' => 'Book now',
    'all_centers' => 'All centres',
    'auberge_capacity_beds' => ':count beds', // example with param
    'auberge_capacity_tents' => ':count beds under tents',

    // contact
    'contact_subtitle' => 'Contact methods',
    'contact_title' => 'Contact us',
    
    'contact_description' => 'For any inquiry or direct contact, please use the following information',
    'contact_phone' => 'Phone',
    'contact_email' => 'Email',
    'contact_address' => 'Address',
    'contact_placeholder_name' => 'Full name*',
    'contact_placeholder_email' => 'Email address*',
    'contact_placeholder_phone' => 'Phone number*',
    'contact_subject' => 'Subject*',
    'contact_option_inquiry' => 'Inquiry',
    'contact_option_note' => 'Note',
    'contact_option_complaint' => 'Complaint',
    'contact_option_suggestion' => 'Suggestion',
    'contact_message_placeholder' => 'Message*',
    'contact_send' => 'Send',
    'contact_form_title' => 'Contact us',
    'contact_form_paragraph' => "We are happy to receive your questions and feedback. We always strive to serve you professionally and with quality.",
    'contact_address_full' => 'Mohamed Ali Agid street,El Khadra city 1003 Tunis',
    // news list card defaults
    'no_image_alt' => "No image available",

    // misc / CTA
    'youth_centers_title' => 'Youth accommodation facilities and centres in Tunisia',
    'discover_bookings' => 'Youth facilities in Tunisia… discover and book directly',

    'footer' => [
        'ministry_name' => 'Ministry of Youth and Sports',

        'menu' => [
            'home' => 'Home',
            'ministry' => 'The Ministry',
            'media' => 'Media',
            'contact' => 'Contact us',
        ],

        'youth' => [
            'title' => 'Youth',
            'job_offers' => 'Job offers & competitions',
            'activities' => 'Activities & programmes',
            'associations' => 'Associations activities',
            'register_creative' => 'Register a creative youth',
        ],

        'contact' => [
            // keep the maps link identical to the FR file unless you want a different one
            'maps_link' => 'https://www.google.com/maps/place/%D8%B4%D8%A7%D8%B1%D8%B9+%D9%85%D8%AD%D9%85%D8%AF+%D8%B9%D9%84%D9%8A+%D8%B9%D9%82%D9%8A%D8%AF+%D8%8C+%D8%AD%D9%8A+%D8%A7%D9%84%D8%AE%D8%B6%D8%B1%D8%A7%D8%A1+1003+%D8%AA%D9%88%D9%86%D8%B3/@36.8021319,10.1799697,17z/data=!3m1!4b1!4m5!3m4!1s0x12fd338381973143:0xf26655b21ed1d308!8m2!3d36.8021319!4d10.1821584',
            'address' => 'Rue Mohamed Ali Agid, Cité El Khadra 1003 Tunis',
            'email' => 'mjsep@mjs.tn',
            // phone_display is human formatted; phone_link should be international format without spaces if needed for href
            'phone_display' => '71.841.433',
            'phone_link' => '+2171841433',
            'title' => 'Contact us',
        ],

        'subscribe' => [
            'title' => 'Subscribe',
            'text' => 'Subscribe to our weekly newsletter to receive the latest news and updates.',
            'placeholder' => 'Enter your email address',
            'button' => 'Subscribe',
        ],

        'copyright' => [
            'prefix' => 'All rights reserved',
        ],

        'powered_by' => 'DataEra',
    ],

    'republic' => 'Tunisian Republic',
    'ministry_name' => 'Ministry of Youth and Sports',
    'hero_contact' => 'Contact us',
    'news_more_button' => 'Latest news',

    // youth centers / virtual tour
    'youth_centers_title' => 'Youth accommodation facilities and centres in Tunisia',
    'discover_bookings' => 'Discover centres and book directly',

    // about / service
    'about_service_title' => 'Youth houses service',
    'about_text' => "We offer a reservation service for youth houses across the country. Our youth houses provide comfortable and affordable accommodation for young people and families. They stand out for their strategic location and diverse services.",
    'about_we_offer' => 'We offer:',
    'about_feature_rooms' => 'Fully equipped rooms',
    'about_feature_food' => 'Catering service',
    'about_feature_facilities' => 'Sport and leisure facilities',
    'about_feature_prices' => 'Competitive rates',

    // map alt text
    'map_alt' => 'Map of youth houses',
    'gouvernorat_title_prefix' => 'Governorate',
    'booking_title' => 'Booking',
    'booking_choose_house' => 'Choose a house',
    'booking_choose_house_option' => 'Choose a youth house',
    'sample_house_1' => 'Youth house 1',
    'sample_house_2' => 'Youth house 2',
    'sample_house_3' => 'Youth house 3',
    'booking_number_places' => 'Number of places',
    'booking_arrival' => 'Arrival date',
    'booking_departure' => 'Departure date',
    'booking_type' => 'Accommodation type',
    'booking_type_option' => 'Choose accommodation type',
    'booking_type_full' => 'Full board',
    'booking_type_half' => 'Half board',
    'booking_type_no_meals' => 'Accommodation without meals',
    'booking_submit' => 'Book',

    'centers_overview' => 'Means and youth accommodation centres',
    'centers_in_gouv_subtitle' => 'مركبات و مراكز اقامة الشباب في', // kept original Arabic prefix as in FR file
    'centers_in_gouv_title' => 'Youth centres in',
    'no_centers_in_gouv' => 'No youth centre found in this governorate.',

    'beds_label' => 'beds',
    'tents_label' => 'tents',
    'book_now' => 'Book now',
    'all_centers' => 'All centres',

    'about_service_title' => 'Youth houses service',
    'about_text' => "We provide a youth house booking service across the country. Our youth houses offer comfortable and affordable accommodation for young people and families. They stand out for their strategic location and varied services.",
    'about_we_offer' => 'We provide:',
    'about_feature_rooms' => 'Fully equipped rooms',
    'about_feature_food' => 'Catering service',
    'about_feature_facilities' => 'Sport and leisure facilities',
    'about_feature_prices' => 'Competitive rates',

    'marker_tunis' => 'Youth house Tunis',
    'marker_sousse' => 'Youth house Sousse',
    'marker_sfaxes' => 'Youth house Sfax',
    'marker_mednine' => 'Youth house Médenine',
    'marker_bizerte' => 'Youth house Bizerte',

    'login_first' => 'Please log in first',

    'about_center' => 'About the centre',

    'services_title' => 'Services',
    'available_spaces_title' => 'Available spaces',

    'space_tv' => 'TV/Web space',
    'space_radio' => 'Radio/Web space',
    'space_gaming' => 'Video games space',

    'sports_title' => 'Sport facilities',
    'cultural_spaces_title' => 'Nearby cultural venues and museums',

    'virtual_tour_label' => 'Virtual tour',
    'virtual_tour_subtitle' => 'Discover youth houses via a 360° virtual tour',

    'contact_subtitle' => 'To contact',
    'contact_description' => 'For any request or direct contact, please use the following information',

    'call_center' => 'Call centre',
    'call_center_desc' => 'Contact us for general inquiries.',

    'our_location' => 'Our location',
    'find_us_on_map' => 'Find us on the map.',

    'location_not_specified' => '📍 The location of this facility is not yet specified.',

    // about/service block (duplicates kept consistent)
    'about_service_title' => 'Youth houses service',
    'about_we_offer' => 'We offer:',
    'about_feature_rooms' => 'Fully equipped rooms',
    'about_feature_food' => 'Catering service',
    'about_feature_facilities' => 'Sport and leisure facilities',
    'about_feature_prices' => 'Competitive rates',

    'breadcrumb_home' => 'Home',
    'concours_page_title' => 'Competitions & recruitments',
    'concours_page_description' => 'List of competitions currently available. Click "Register" to open the registration page.',

    // section short label
    'services_subtitle' => 'Opportunities & services',

    // search / form
    'concours_search_placeholder' => 'Search by competition title...',

    'reset_button' => 'Reset',

    // card / list
    'registration_ends' => "Registration ends",
    'register_button' => "Register",
    'results_button' => 'Results',
    'no_concours' => "No competitions available at the moment.",

    'concours_results_title' => 'Competition results',

    'results_search_placeholder' => 'Search by name / CIN / email...',
    // results_prompt keys (kept from FR)
    'results_prompt' => "Enter the name or identity card number (CIN) then press \"Search\" to display results.",
    'results_prompt_note' => "No records will be displayed without a search.",

    // table headers
    'table_name' => 'Name',
    'table_cin' => 'CIN number',
    'table_email' => 'Email',
    'table_status' => 'Status',
    'table_created_at' => 'Created at',

    // statuses (match possible values in DB)
    'status_acceptation_definitif' => 'Accepted (final)',
    'status_acceptation_primaire'  => 'Accepted (preliminary)',
    'status_refuse'                => 'Refused',
    'status_en_attente'            => 'Pending',

    'no_results' => 'No results matching your search.',

    // back button
    'news_back_to_list' => 'Back to list',

    // fallback/no-image
    'no_image_alt' => "No image available",

    // iframe title
    'youtube_video' => 'YouTube video',

    // auth / login
    'login_title' => 'Login',
    'login_description' => "Please enter your email address and password to access your account.",
    'email_label' => "Email address",
    'password_label' => 'Password',
    'email_placeholder' => "Enter your email address",
    'password_placeholder' => "Enter your password",
    'remember_me' => 'Remember me',
    'forgot_password' => 'Forgot password?',
    'login_button' => 'Log in',
    'no_account_text' => "Don't have an account?",
    'create_account' => 'Create an account',

    // registration page
    'register_title' => 'Create a new account',
    'register_description' => 'Please fill in the following information to complete your registration.',
    'full_name_label' => 'Full name',
    'full_name_placeholder' => 'Enter full name',
    'identity_type_label' => 'Identity type',
    'choose_identity_placeholder' => '-- Choose identity type --',
    'cin_label' => 'CIN number',
    'cin_placeholder' => 'Enter the CIN number',
    'cin_issue_date_label' => 'Issue date',
    'cin_issue_place_label' => 'Place of issue',
    'cin_issue_place_placeholder' => 'Enter place of issue',
    'passport_label' => 'Passport number',
    'passport_placeholder' => 'Enter passport number',
    'fiscal_id_label' => 'Fiscal identifier',
    'fiscal_id_placeholder' => 'Enter fiscal identifier',
    'confirm_password_label' => 'Confirm password',
    'confirm_password_placeholder' => 'Confirm the password',
    'accept_terms_html' => 'I accept the <strong>privacy policy</strong> and the <strong>terms of use</strong>.',
    'rgpd_hint' => 'You may read the terms and the privacy policy before continuing. Your consent will be recorded securely.',
    'rgpd_title' => 'Terms and privacy policy',
    'rgpd_body_html' => '<h3>Introduction</h3><p>Before creating an account, please read ... (insert the full EN version of the RGPD modal here)</p>',
    'rgpd_accept' => 'I accept and continue',
    'rgpd_decline' => 'Decline',
    'rgpd_close_label' => 'Close',
    'already_have_account' => 'Already have an account?',

    'password_reset_title' => 'Forgot password',
    'password_reset_description' => "Enter your email and we'll send you a link to reset your password.",
    'send_reset_link' => 'Send reset link',
    'remembered_password' => 'Remembered your password?',
  'dashboard_welcome' => 'Hello, :name',
    'dashboard_manage_services' => 'Manage your account and available services',

    'service_personal_info_title' => 'My personal information',
    'service_personal_info_desc'  => 'View and edit your personal information',
    'service_personal_info_action'=> 'View & edit',

    'service_investment_title' => 'Investment',
    'service_investment_desc'  => 'Explore available investment opportunities',
    'service_investment_action'=> 'Discover more',

    'service_association_funding_title' => 'Associations funding',
    'service_association_funding_desc'  => 'Manage association funding documents',
    'service_association_funding_action'=> 'Discover more',

    'service_events_title' => 'Sporting events',
    'service_events_desc'  => 'Organise and manage sporting events',
    'service_events_action'=> 'Discover more',

    'service_reservations_title' => 'My reservations',
    'service_reservations_desc'  => 'Manage your reservations and appointments',
    'service_reservations_action'=> 'View details',
// profile / dashboard strings
'back' => 'Back',
'profile_section_subtitle' => 'My personal information',
'profile_section_title' => 'View account details',

// buttons & actions
'profile_edit_button' => 'Edit information',
'profile_save_button' => 'Save changes',
'profile_cancel_button' => 'Cancel',

// fallbacks
'not_specified' => 'Not specified',


    'investment' => 'Investment',

    'projects_subtitle' => 'Project launches',
    'welcome_hello' => 'Hello, :name',
    'projects_overview' => 'Activities and projects under the Ministry',

    'project_salle_title' => 'Create a private sports hall',
    'project_salle_desc' => 'Build and manage a private sports hall',

    'project_spaces_title' => 'Recreation spaces for youth and children',
    'project_spaces_desc' => 'Manage and organize recreational activities',

    'project_private_institutions_title' => 'Private youth institutions',
    'project_private_institutions_desc' => 'Manage and develop youth institutions',

    'project_events_title' => 'Organize recreational activities',
    'project_events_desc' => 'Plan and deliver recreational programs',

    'project_training_center_title' => 'Training & athlete internship center',
    'project_training_center_desc' => 'Train and develop athletic skills',

    'project_tax_exemption_title' => 'Tax exemption projects',
    'project_tax_exemption_desc' => 'Manage and organize tax exemption projects',

    'action_view_edit' => 'View & edit',
    'action_discover_more' => 'Discover more',
    'action_view_details' => 'View details',
    'breadcrumb_investment' => 'Investment',
    'breadcrumb_salles_list' => 'Sport halls list',

    // section / header
    'section_subtitle_requests' => 'Sport hall applications',
    'section_title_all_requests' => 'View all applications',

    // buttons
    'btn_add_request' => 'Add application',
    'btn_view' => 'View',
    'btn_edit' => 'Edit',
    'btn_delete' => 'Delete',

    // table
    'table_id' => 'ID',
    'table_deposit_date' => 'Submission date',
    'table_applicant' => 'Applicant name',
    'table_status' => 'Status',
    'table_actions' => 'Actions',
    'table_start_activity' => 'Start of activity',
    'table_tax_exemption' => 'Tax exemption',

    'no_salles_requests' => 'No sport hall applications.',

    // statuses
    'status_pending' => 'Pending',
    'status_accepted' => 'Accepted',
    'status_refused' => 'Refused',
    'status_unknown' => 'Unknown',

    // activity / exoneration actions
    'start_activity_notify' => 'Notify start of activity',
    'start_activity_edit' => 'Edit application',
    'start_activity_view' => 'View application',

    'exoneration_add' => 'Add tax exemption',
    'exoneration_edit' => 'Edit application',
    'exoneration_view' => 'View application',

    // common / fallback
    'not_specified' => 'Not specified',
    'confirm_delete' => 'Are you sure you want to delete?',
    
    'search_button' => 'Search',

    'investment' => [
    'breadcrumb' => [
        'home' => 'Home',
        'index' => 'Investment',
        'salles_list' => 'Sport halls list',
        'add_salle' => 'Add sport hall',
    ],
    'section' => [
        'subtitle' => 'Sport hall applications',
        'title' => 'View all applications',
    ],
    'btn' => [
        'add_request' => 'Add application',
    ],
    'no_salles_requests' => 'No sport hall applications.',
    'table' => [
        'id' => 'ID',
        'deposit_date' => 'Submission date',
        'applicant' => 'Applicant name',
        'status' => 'Status',
        'actions' => 'Actions',
        'start_activity' => 'Start of activity',
        'tax_exemption' => 'Tax exemption',
    ],
    'form' => [
        'identity' => [
            'title' => 'Applicant identity',
        ],
        'property' => [
            'title' => 'Property identity',
        ],
        'label' => [
            'full_name' => 'Full name or business name',
            'email' => 'Email',
            'identity_type' => 'Identity type',
            'cin' => 'ID card number',
            'passport' => 'Passport number',
            'fiscal_id' => 'Fiscal identifier',
            'cin_issue_date' => 'Issue date',
            'cin_issue_place' => 'Issue place',
            'phone' => 'Personal phone',
            'address' => 'Personal address',
            'property_address' => 'Property address',
            'gouvernorat' => 'Governorate',
            'delegation' => 'Delegation',
            'property_type' => 'Property type',
            'surface_total' => 'Total property area (m²)',
            'usage_type' => 'Property usage',
            'document_property' => 'Contract / ownership copy',
            'other_surfaces' => 'Other surfaces',
            'count' => 'Count',
            'surface' => 'Surface',
        ],
        'placeholder' => [
            'choose' => 'Choose...',
            'loading' => 'Loading...',
        ],
        'button' => [
            'submit' => 'Submit',
        ],
    ],
    'confirm_delete' => 'Are you sure you want to delete?',
],

// add / merge into resources/lang/en/site.php (inside the returned array)

'investment' => [
    'breadcrumb' => [
        'home' => 'Home',
        'index' => 'Investment',
        'salles_list' => 'Sports halls list',
        'add_salle' => 'Add sports hall',
    ],
    'form' => [
        'identity' => [
            'title' => 'Applicant identity',
        ],
        'property' => [
            'title' => 'Property information',
        ],
        'label' => [
            'full_name' => 'Full name or trade name',
            'email' => 'Email',
            'identity_type' => 'Identity type',
            'cin' => 'CIN number',
            'passport' => 'Passport number',
            'fiscal_id' => 'Fiscal identifier',
            'cin_issue_date' => 'Issue date',
            'cin_issue_place' => 'Place of issue',
            'phone' => 'Phone number',
            'address' => 'Address',
            'property_address' => 'Property address',
            'gouvernorat' => 'Governorate',
            'delegation' => 'Delegation',
            'property_type' => 'Property type',
            'surface_total' => 'Total property surface (m²)',
            'usage_type' => 'Property usage',
            'document_property' => 'Ownership document',
            'other_surfaces' => 'Other surfaces',
            'count' => 'Count',
            'surface' => 'Surface',
        ],
        'placeholder' => [
            'choose' => 'Choose...',
            'loading' => 'Loading...',
            'cin' => 'Enter CIN number',
            'passport' => 'Enter passport number',
            'fiscal' => 'Enter fiscal identifier',
            'cin_issue_place' => 'Enter place of issue',
            'count' => 'Count',
            'surface' => 'Surface (m²)',
        ],
        'validation' => [
            'property_address_max' => 'Property address must not exceed 100 characters.',
            'surface_min' => 'Surface must be at least 100 m².',
            'surface_hint' => 'Surface must be at least 100 m².',
        ],
        'button' => [
            'submit' => 'Submit',
        ],
        'components' => [
            'title' => 'Property components',
            'exercise_hall' => 'Exercise hall',
            'pool' => 'Swimming pool',
            'changing_rooms' => 'Changing rooms',
            'sanitary_units' => 'Sanitary units',
            'storage_space' => 'Storage area',
            'outdoor_space' => 'Outdoor area',
            'garage' => 'Garage / Parking',
        ],
    ],
],

'yes' => 'Yes',
'no' => 'No',
  'exoneration' => [
        'form_title' => 'Application form for tax exemption',
        'identity' => [
            'title' => 'Project owner identity',
        ],
        'project_name_label' => 'Project title',
        'project_place_label' => 'Project location',
        'documents' => [
            'title' => 'Upload required documents',
            '1' => ['label' => '1- Copy of the specifications booklet', 'desc' => 'Paraphed on all pages by the applicant and accompanied by the deposit receipt or the regional delegation stamp.'],
            '2' => ['label' => '2- Original of the deposit certificate', 'desc' => 'Issued by the competent authority and listing the equipment to be actually purchased.'],
            '3' => ['label' => '3- Invoice', 'desc' => 'Final invoice in Arabic or French listing exclusively the equipment subject to the tax exemption request.'],
            '4' => ['label' => '4- Contract between buyer and supplier', 'desc' => 'Specifies references, quantity, price and brand, signed by both parties.'],
            '5' => ['label' => '5- Arrival notice document', 'desc' => 'Issued by the carrier.'],
            '6' => ['label' => '6- Shipping document', 'desc' => 'Document evidencing shipment/packing.'],
            '7' => ['label' => '7- Copy of tax identification card', 'desc' => 'Copy of the enterprise tax ID card.'],
            '8' => ['label' => '8- Copy of company registry extract', 'desc' => 'Extract from the national company register.'],
            '9' => ['label' => '9- Copy of title deed', 'desc' => 'Or valid sale/donation/lease contract registered with the tax office.'],
            '10' => ['label' => '10- Undertaking', 'desc' => 'Signed undertaking not to transfer purchased equipment for 5 years, listing equipment details.'],
            '11' => ['label' => '11- Architectural example of the project', 'desc' => 'Prepared by an architect, stamped and signed, including project data.'],
        ],
    ],

    // investment form labels (short)
    'investment' => [
        'form' => [
            'label' => [
                'full_name' => 'Full name / trade name',
                'email' => 'Email',
                'identity_type' => 'Identity type',
                'cin' => 'CIN number',
                'passport' => 'Passport number',
                'fiscal_id' => 'Fiscal identifier',
                'cin_issue_date' => 'Issue date',
                'cin_issue_place' => 'Place of issue',
                'phone' => 'Phone number',
                'address' => 'Address',
            ],
            'placeholder' => [
                'cin' => 'Enter CIN number',
                'passport' => 'Enter passport number',
                'fiscal' => 'Enter fiscal identifier',
            ],
            'button' => [
                'submit' => 'Submit',
            ],
        ],
    ],


     'print' => 'Print',
    'view_file' => 'View file',
    'not_specified' => '-',

    'start_activity' => [
        'form_number_label' => 'Form number:',
        'form_title' => 'Notification of start of activity form',
        'current_status' => 'Current status:',
        'status' => [
            'accepted' => 'Accepted',
            'rejected' => 'Rejected',
            'pending' => 'Pending',
        ],
        'rejection_reason_label' => 'Reason for rejection:',
        'owner_identity_title' => 'Project owner identity',
        'owner_identity_number' => 'Identity number',
        'start_date_label' => 'Start date of activity',
        'start_date_hint' => 'The start date must be at least 15 days after the receipt of the registration deposit.',
        'attached_documents' => 'Attached documents',
        'documents' => [
            'preuve_propriete_location' => [
                'label' => 'Copy of title deed or lease contract',
                'desc'  => 'Copy of title deed or valid lease contract registered where applicable.',
            ],
            'plan_architectural' => [
                'label' => 'Architectural plan',
                'desc'  => 'Architectural plan showing layout and equipment placement.',
            ],
            'declaration_investissement' => [
                'label' => 'Investment declaration certificate',
                'desc'  => 'Certificate issued by the competent authority listing equipment.',
            ],
            'identification' => [
                'label' => 'ID card / Passport',
                'desc'  => 'Copy of national ID card or passport.',
            ],
            'extrait_registre_national_entreprise' => [
                'label' => 'Company registry extract',
                'desc'  => 'Extract from the national company register if applicable.',
            ],
            'certificat_prevention' => [
                'label' => 'Prevention / safety certificate',
                'desc'  => 'Certificate of compliance with prevention and safety standards.',
            ],
            'contrat_assurance' => [
                'label' => 'Insurance contract',
                'desc'  => 'Copy of insurance covering the location or activity.',
            ],
            'approbation_autorite_minicipale' => [
                'label' => 'Local authority approval',
                'desc'  => 'Approval or authorization from the local authority if required.',
            ],
        ],
    ],

'yes_no' => 'Yes / No',
    'component' => 'Component',

    'current_status_label' => 'Current status:',
    'status_accepted' => 'Accepted',
    'status_refused' => 'Rejected',
    'status_pending' => 'Pending',

    'header' => [
        'regional_delegation' => 'Regional delegation of youth and sports'
    ],

    'investment' => [
        'breadcrumb' => [
            'home' => 'Home',
            'index' => 'Investment',
            'salles_list' => 'Sports halls list',
        ],
        'detail' => 'Sports hall details',
        'form_title_salle' => 'Cahier des charges deposit form for creating a private sports hall',
        'view_request' => 'View request',
        'form' => [
            'identity' => [
                'title' => 'Project owner identity',
            ],
            'property' => [
                'title' => 'Property identity',
            ],
            'label' => [
                'full_name' => 'Full name or business name',
                'email' => 'Email',
                'identity_type' => 'Identity type',
                'cin' => 'CIN number',
                'passport' => 'Passport number',
                'fiscal_id' => 'Fiscal identifier',
                'phone' => 'Phone',
                'address' => 'Address',
                'property_address' => 'Property address',
                'gouvernorat' => 'Governorate',
                'delegation' => 'Delegation',
                'property_type' => 'Property type',
                'surface_total' => 'Total surface (m²)',
                'usage_type' => 'Usage type',
                'document_property' => 'Contract / title deed',
                'other_surfaces' => 'Other surfaces',
                'count' => 'Count',
                'surface' => 'Surface',
            ],
            'components' => [
                'title' => 'Property components',
                'exercise_hall' => 'Exercise hall',
                'pool' => 'Pool',
                'changing_rooms' => 'Changing rooms',
                'sanitary_units' => 'Sanitary units',
                'storage_space' => 'Storage space',
                'outdoor_space' => 'Outdoor space',
                'garage' => 'Garage',
            ],
        ],
    ],

    'start_activity' => [
        'rejection_reason_label' => 'Reason for rejection:',
    ],
    'current_status_label'=>' Current Status',
  'breadcrumb_investment' => 'Investment',
    'project_spaces_title' => 'Youth & children recreational spaces',
    'add_form_title' => 'Add form',

    // form sections & labels
    'form_section_investor' => 'Investor',
    'label_full_name' => 'Full name',
    'label_birth_place' => 'Place of birth',
    'label_birth_date' => 'Birth date',
    'label_identity' => 'Identity type',
    'label_issue_date' => 'Issue date',
    'label_issue_place' => 'Issue place',
    'label_address' => 'Personal address',
    'label_education_level' => 'Education level',
    'label_last_degree' => 'Last diploma obtained',
    'label_experience' => 'Experience in the activity',

    // features
    'features_title' => 'Recreational project features',
    'espace_spectacle' => 'Outdoor recreational spaces and shows',
    'espace_sportif' => 'Sport recreational spaces',
    'espace_service' => 'Service activity space',
    'espace_culturel' => 'Cultural, artistic and scientific activity space',
    'caracteristique_placeholder' => 'Specific features',

    // project nature
    'project_nature_title' => 'Project nature',
    'choose_nature' => 'Please choose project nature',
    'choose_placeholder' => 'Choose...',

    // number of places
    'number_places_expected' => 'Number of expected jobs',
    'nbr_diplome_universitaire_label' => 'Holders of university degrees',
    'nbr_diplome_universitaire_placeholder' => 'Holders of university degrees',
    'nbr_autre_label' => 'Others',
    'nbr_autre_placeholder' => 'Others',

    // manager
    'section_manager_title' => 'Institution manager',
    'label_director_name' => 'Full name',
    'label_director_cin' => 'National ID number',

    // investment table
    'investment_financing_title' => 'Investment & financing data',
    'investment_table_invest' => 'Investment',
    'investment_table_amount' => 'Amount',
    'investment_table_sources' => 'Financing sources',
    'investment_table_remarks' => 'Remarks',
    'add_row' => 'Add row',
    'delete' => 'Delete',
    'financing_hint' => '(*) Own funds, long-term loans, medium-term loans, short-term loans, grants, other sources.',

    // declaration & remarks
    'declaration_title' => 'Declaration on honour',
    'declaration_text' => 'I, the undersigned, hereby certify the accuracy of the data contained in this form and declare that I have not been subject to any criminal or administrative sanction preventing management or investment in the activities described.',
    'remarks_title' => 'Notes for the regional youth & sports delegation:',
    'remarks_placeholder' => 'Write your remarks here...',

    // form actions
    'form_submit' => 'Submit',

// -- new/merged keys for this view (English)
'page_show_form' => 'View form',
'place_of_birth' => 'Place of birth',
'date_of_birth' => 'Date of birth',
'personal_address' => 'Personal address',
'education_level' => 'Education level',
'last_degree' => 'Last degree obtained',
'experience_label' => 'Experience in activity',
'project_characteristics' => 'Project characteristics',
'characteristics_placeholder' => 'Specifics',
'espace_spectacle_label' => 'Spectacle & outdoor spaces',
'espace_sportif_label' => 'Recreational sports spaces',
'espace_service_label' => 'Service activity space',
'espace_culturel_label' => 'Cultural, artistic & scientific activities space',
'select_project_nature' => 'Please select project nature',
'number_positions_title' => 'Number of expected positions',
'holders_degree_label' => 'Degree holders',
'others_label' => 'Others',
'director_title' => 'Director of the institution',
'investment_finance_title' => 'Investment & financing details',
'investment_label' => 'Investment',
'amount_label' => 'Amount',
'fund_sources_label' => 'Funding sources',
'notes_label' => 'Notes',
'funds_examples' => '(*) Own funds, long-term loans, medium-term loans, short-term loans, grants, other.',
'declaration_title' => 'Declaration on honour',
'declaration_text' => 'I, the undersigned, certify the accuracy of the information contained in this form and declare that I have not been subject to any criminal or administrative sanction that would prevent me from managing or operating an establishment or investing in the activities described.',
'remarks_title' => 'Delegation remarks',
'write_remarks_placeholder' => 'Write your remarks here...',


];
