<?php
// resources/lang/ar/site.php

return [
    // hero / search
    'search_title' => 'البحث في الموقع',
    'search_placeholder' => 'أدخل كلمة أو عبارة...',
    'search_button' => 'بحث',

    // about (short labels)
    'about_subtitle' => 'حول الوزارة',
    'about_title' => 'نظرة عامة عن الوزارة وأنشطتها',
    'about_read_more' => 'اقرأ المزيد',

    // about (main paragraph)
    'about_text' => "وزارة الشباب والرياضة في الجمهورية التونسية هي الهيئة العمومية المسؤولة عن تنمية وتمكين الشباب وتعزيز الأنشطة الرياضية في البلاد. تضع الوزارة سياسات وبرامج تهدف إلى تكوين جيل قادر على المشاركة الفعّالة في الحياة الاجتماعية وتعزيز القيم الوطنية والثقافية.<br><br>تعمل الوزارة على توفير بيئة ملائمة لمبادرات الشباب، وتنظيم الفعاليات والنشاطات الرياضية، وتشجيع المواهب ودعم تطوير الرياضة على جميع المستويات. كما تتعاون مع فاعلين محليين ودوليين لتنفيذ برامج تكوين وتثقيف تعزّز مهارات الشباب والرياضيين.<br><br>تلعب الوزارة دوراً مركزياً في بناء مجتمع نشيط وصحي يسعى للتنمية المستدامة ويعزّز الروح الرياضية والقيم الإنسانية.",

    // news area
    'news_subtitle' => 'آخر الأخبار',
    'news_title' => 'اطلع على أحدث المستجدات',
    'news_more' => 'المزيد من الأخبار',
    'no_news' => "لا توجد أخبار في الوقت الحالي.",
    'read_more' => 'اقرأ المزيد',
    'news_date_format_example' => 'Y.m.d',

    // services / offerings (section)
    'services_subtitle' => 'الفرص والخدمات',
    'services_title' => 'منطقة الفرص والخدمات المتاحة لدى الوزارة',
    'services_competitions' => 'المباريات والانتدابات',
    'services_training' => 'التكوين والخدمات',
    'services_regional' => 'الهياكل الجهوية',
    'services_library' => 'مكتبة الوزارة',
    'services_projects' => 'إطلاق المشاريع',
    'services_programs' => 'البرامج والنشاطات',
    'services_apply_more' => 'معرفة المزيد',
    'service_read_more' => 'اقرأ المزيد',

    // projects / projects-carousel
    'projects_subtitle' => 'إطلاق المشاريع',
    'projects_title' => 'الأنشطة والمشاريع تحت إشراف الوزارة',
    'project_1' => 'إنشاء قاعة متعددة الرياضات',
    'project_2' => 'مساحات ترفيهية للشباب والطفولة',
    'project_3' => 'البنى الرياضية الخاصة',
    'project_4' => 'تنظيم نشاطات ترفيهية للشباب والطفولة',
    'project_5' => 'مركز تكوين وتأهيل الرياضيين',

    // trophies / honors
    'trophies_subtitle' => 'سجل الألقاب الرياضية',
    'trophies_title' => 'أهم الجوائز المحلية والدولية',
    'trophies_browse' => 'تصفح الكل',
    'trophies_read_more' => 'معرفة المزيد',

    // brand / sport universities
    'sport_universities' => 'جامعات رياضية',
    'sport_universities_desc' => 'مراجع وبيانات حول الجامعات الرياضية',

    // booking / auberges
    'book_now' => 'احجز الآن',
    'all_centers' => 'جميع المراكز',
    'auberge_capacity_beds' => ':count سريرا',
    'auberge_capacity_tents' => ':count سريرا تحت الخيام',

    // contact
    'contact_subtitle' => 'وسائل التواصل',
    'contact_title' => 'تواصل معنا',
    'contact_description' => 'لأي استفسار أو تواصل مباشر، يرجى استعمال المعلومات التالية',
    'contact_phone' => 'الهاتف',
    'contact_email' => 'البريد الإلكتروني',
    'contact_address' => 'العنوان',
    'contact_placeholder_name' => 'الاسم الكامل*',
    'contact_placeholder_email' => 'البريد الإلكتروني*',
    'contact_placeholder_phone' => 'رقم الهاتف*',
    'contact_subject' => 'الموضوع*',
    'contact_option_inquiry' => 'استفسار',
    'contact_option_note' => 'ملاحظة',
    'contact_option_complaint' => 'شكوى',
    'contact_option_suggestion' => 'اقتراح',
    'contact_message_placeholder' => 'الرسالة*',
    'contact_send' => 'إرسال',
    'contact_form_title' => 'تواصل معنا',
    'contact_form_paragraph' => "يسعدنا استقبال استفساراتكم وملاحظاتكم. نحن نسعى دوماً لخدمتكم بمهنية وجودة.",
    'contact_address_full' => 'شارع محمد علي عقيد، حي الخضرة 1003 تونس',

    // news list card defaults
    'no_image_alt' => "لا توجد صورة متاحة",

    // misc / CTA
    'youth_centers_title' => 'مركبات ومراكز إقامة الشباب في تونس',
    'discover_bookings' => 'مركبات ومراكز إقامة الشباب في تونس… اكتشف واحجز مباشرة',

    // footer
    'footer' => [
        'ministry_name' => 'وزارة شؤون الشباب و الرياضة',
        'menu' => [
            'home' => 'الرئيسية',
            'ministry' => 'الوزارة',
            'media' => 'ميديا',
            'contact' => 'إتصل بنا',
        ],
        'youth' => [
            'title' => 'شباب',
            'job_offers' => 'عروض الشغل والمناظرات',
            'activities' => 'الأنشطة والبرامج',
            'associations' => 'أنشطة الجمعيات',
            'register_creative' => 'تسجيل شاب مبدع',
        ],
        'contact' => [
            'maps_link' => 'https://www.google.com/maps/place/%D8%B4%D8%A7%D8%B1%D8%B9+%D9%85%D8%AD%D9%85%D8%AF+%D8%B9%D9%84%D9%8A+%D8%B9%D9%82%D9%8A%D8%AF+%D8%8C+%D8%AD%D9%8A+%D8%A7%D9%84%D8%AE%D8%B6%D8%B1%D8%A7%D8%A1+1003+%D8%AA%D9%88%D9%86%D8%B3/@36.8021319,10.1799697,17z/data=!3m1!4b1!4m5!3m4!1s0x12fd338381973143:0xf26655b21ed1d308!8m2!3d36.8021319!4d10.1821584',
            'address' => 'شارع محمد علي عقيد ، حي الخضراء 1003 تونس',
            'email' => 'mjsep@mjs.tn',
            'phone_display' => '71.841.433',
            'phone_link' => '+2171841433',
            'title' => 'تواصل معنا',
        ],
        'subscribe' => [
            'title' => 'الاشتراك',
            'text' => 'اشترك في نشرتنا الأسبوعية لتصلك آخر الأخبار والتحديثات.',
            'placeholder' => 'أدخل بريدك الإلكتروني',
            'button' => 'اشترك',
        ],
        'copyright' => [
            'prefix' => 'جميع الحقوق محفوظة',
        ],
        'powered_by' => 'DataEra',
    ],

    // base/site metadata
    'republic' => 'الجمهورية التونسية',
    'ministry_name' => 'وزارة الشباب والرياضة',
    'hero_contact' => 'اتصل بنا',
    'news_more_button' => 'آخر الأخبار',
     'gouvernorat_title_prefix' => 'ولاية',
    // youth centers / virtual tour
    'discover_bookings' => 'اكتشف مركبات ومراكز إقامة الشباب عبر مختلف الولايات',

    // about / service
    'about_service_title' => 'خدمة دور الشباب',
    'about_we_offer' => 'نوفر:',
    'about_feature_rooms' => 'غرف مجهزة بالكامل',
    'about_feature_food' => 'خدمة الإطعام',
    'about_feature_facilities' => 'مرافق رياضية وترفيهية',
    'about_feature_prices' => 'أسعار تنافسية',

    // map alt text
    'map_alt' => 'خريطة دور الشباب',

    // breadcrumb / concours / search / results
    'breadcrumb_home' => 'الرئيسية',
    'concours_page_title' => 'المناظرات و الانتدابات',
    'concours_page_description' => 'قائمة المناظرات المتاحة حالياً. انقر على "التسجيل" لفتح صفحة التسجيل.',
    'services_subtitle' => 'فرص وخدمات',
    'concours_search_placeholder' => 'ابحث بعنوان المسابقة...',
    'reset_button' => 'إعادة',
    'registration_ends' => 'انتهاء التسجيل',
    'register_button' => 'التسجيل',
    'results_button' => 'نتائج',
    'no_concours' => 'لا توجد مسابقات متاحة حالياً.',
    'concours_results_title' => 'نتائج المناظرة',
    'results_search_placeholder' => 'ابحث بالاسم / CIN / البريد...',
    'results_prompt' => 'أدخل الاسم أو رقم بطاقة التعريف (CIN) ثم اضغط "بحث" لعرض النتائج.',
    'results_prompt_note' => 'لن يتم عرض أي سجلات دون بحث.',

    // table headers (Arabic)
    'table_name' => 'الاسم',
    'table_cin' => 'رقم بطاقة التعريف',
    'table_email' => 'البريد',
    'table_status' => 'الحالة',
    'table_created_at' => 'تاريخ الإنشاء',

    // statuses
    'status_acceptation_definitif' => 'مقبول نهائياً',
    'status_acceptation_primaire' => 'مقبول أولياً',
    'status_refuse' => 'مرفوض',
    'status_en_attente' => 'قيد الانتظار',
    'no_results' => 'لا توجد نتائج مطابقة لبحثك.',

    // auth / login
    'login_title' => 'تسجيل الدخول',
    'login_description' => 'الرجاء إدخال بريدك الإلكتروني وكلمة المرور للوصول إلى حسابك.',
    'email_label' => 'البريد الإلكتروني',
    'password_label' => 'كلمة المرور',
    'email_placeholder' => 'أدخل البريد الإلكتروني',
    'password_placeholder' => 'أدخل كلمة المرور',
    'remember_me' => 'تذكرني',
    'forgot_password' => 'نسيت كلمة المرور؟',
    'login_button' => 'تسجيل الدخول',
    'no_account_text' => 'ليس لديك حساب؟',
    'create_account' => 'إنشاء حساب',
    'password_reset_title' => 'نسيت كلمة المرور',
    'password_reset_description' => 'أدخل بريدك الإلكتروني وسنرسل لك رابط لإعادة تعيين كلمة المرور.',
    'send_reset_link' => 'إرسال رابط إعادة التعيين',
    'remembered_password' => 'تذكرت كلمة المرور؟',

    // dashboard / services
    'dashboard_welcome' => 'مرحباً، :name',
    'dashboard_manage_services' => 'إدارة حسابك والخدمات المتاحة',
    'service_personal_info_title' => 'معلوماتي الشخصية',
    'service_personal_info_desc' => 'عرض وتعديل معلوماتك الشخصية',
    'service_personal_info_action' => 'عرض وتعديل',
    'service_investment_title' => 'الاستثمار',
    'service_investment_desc' => 'استكشف فرص الاستثمار المتاحة',
    'service_investment_action' => 'اكتشف المزيد',
    'service_association_funding_title' => 'تمويل الجمعيات',
    'service_association_funding_desc' => 'إدارة وثائق تمويل الجمعيات',
    'service_association_funding_action' => 'اكتشف المزيد',
    'service_events_title' => 'التظاهرات الرياضية',
    'service_events_desc' => 'تنظيم وإدارة الفعاليات الرياضية',
    'service_events_action' => 'اكتشف المزيد',
    'service_reservations_title' => 'حجوزاتي',
    'service_reservations_desc' => 'إدارة حجوزاتك ومواعيدك',
    'service_reservations_action' => 'عرض التفاصيل',

    // profile / buttons
    'back' => 'رجوع',
    'profile_section_subtitle' => 'معلوماتي الشخصية',
    'profile_section_title' => 'عرض بيانات الحساب',
    'profile_edit_button' => 'تعديل المعلومات',
    'profile_save_button' => 'حفظ التغييرات',
    'profile_cancel_button' => 'إلغاء',

    // profile update messages
    'profile_update_success' => 'تم تحديث الملف الشخصي بنجاح.',
    'profile_update_validation_error' => 'يرجى تصحيح الأخطاء الظاهرة والمحاولة مرة أخرى.',
    'profile_update_error' => 'حدث خطأ أثناء تحديث الملف الشخصي. الرجاء المحاولة لاحقاً.',
    'profile_update_error_default' => 'حدث خطأ غير متوقع.',

    // misc / booking & center labels
    'about_center' => 'عن المركز',
    'accept_terms_html' => 'أوافق على <strong>سياسة الخصوصية</strong> و<strong>شروط الاستخدام</strong>.',
    'already_have_account' => 'هل لديك حساب بالفعل؟',
    'available_spaces_title' => 'المساحات المتاحة',
    'beds_label' => 'أسرة',
    'booking_arrival' => 'تاريخ الوصول',
    'booking_choose_house' => 'اختر الدار',
    'booking_choose_house_option' => 'اختر دار الشباب',
    'booking_departure' => 'تاريخ المغادرة',
    'booking_number_places' => 'عدد الأماكن',
    'booking_submit' => 'احجز',
    'booking_title' => 'الحجز',
    'booking_type' => 'نوع الإقامة',
    'booking_type_full' => 'إقامة كاملة',
    'booking_type_half' => 'نصف إقامة',
    'booking_type_no_meals' => 'إقامة بدون وجبات',
    'booking_type_option' => 'اختر نوع الإقامة',
    'call_center' => 'مركز الاتصال',
    'call_center_desc' => 'اتصل بنا للاستفسارات العامة.',
    'centers_in_gouv_subtitle' => 'مركبات ومراكز إقامة الشباب في',
    'centers_in_gouv_title' => 'مراكز الشباب في',
    'centers_overview' => 'المرافق ومراكز إقامة الشباب',
    'choose_identity_placeholder' => '-- اختر نوع الهوية --',
    'cin_issue_date_label' => 'تاريخ الإصدار',
    'cin_issue_place_label' => 'مكان الإصدار',
    'cin_issue_place_placeholder' => 'أدخل مكان الإصدار',
    'cin_label' => 'رقم بطاقة التعريف (CIN)',
    'cin_placeholder' => 'أدخل رقم بطاقة التعريف',
    'confirm_password_label' => 'تأكيد كلمة المرور',
    'confirm_password_placeholder' => 'أكد كلمة المرور',
    'cultural_spaces_title' => 'الأماكن الثقافية والمتاحف القريبة',
    'find_us_on_map' => 'اعثر علينا على الخريطة',
    'full_name_label' => 'الاسم الكامل',
    'full_name_placeholder' => 'أدخل الاسم الكامل',
    'fiscal_id_label' => 'الرقم الجبائي',
    'fiscal_id_placeholder' => 'أدخل الرقم الجبائي',
    'identity_type_label' => 'نوع الهوية',
    'location_not_specified' => '📍 لم يتم تحديد موقع هذا المرفق بعد.',
    'login_first' => 'يرجى تسجيل الدخول أولاً',
    'marker_bizerte' => 'دار شباب بنزرت',
    'marker_mednine' => 'دار شباب مدنين',
    'marker_sfaxes' => 'دار شباب صفاقس',
    'marker_sousse' => 'دار شباب سوسة',
    'marker_tunis' => 'دار شباب تونس',
    'news_back_to_list' => 'العودة إلى القائمة',
    'no_centers_in_gouv' => 'لم يتم العثور على أي مركز شباب في هذه الولاية.',
    'our_location' => 'موقعنا',
    'passport_label' => 'رقم جواز السفر',
    'passport_placeholder' => 'أدخل رقم جواز السفر',
    'register_description' => 'يرجى ملء المعلومات التالية لإكمال التسجيل.',
    'register_title' => 'إنشاء حساب جديد',
    'rgpd_accept' => 'أوافق وأتابع',
    'rgpd_decline' => 'رفض',
    'rgpd_close_label' => 'إغلاق',
    'rgpd_hint' => 'يمكنك قراءة الشروط وسياسة الخصوصية قبل المتابعة. سيتم تسجيل موافقتك بشكل آمن.',
    'rgpd_title' => 'الشروط وسياسة الخصوصية',
    'rgpd_body_html' => '<h3>مقدمة</h3><p>قبل إنشاء حساب، يرجى قراءة الشروط وسياسة الخصوصية بعناية... (أدخل هنا النسخة العربية الكاملة لمحتوى RGPD)</p>',
    'sample_house_1' => 'دار الشباب 1',
    'sample_house_2' => 'دار الشباب 2',
    'sample_house_3' => 'دار الشباب 3',
    'space_gaming' => 'مساحة ألعاب الفيديو',
    'space_radio' => 'مساحة راديو/ويب',
    'space_tv' => 'مساحة تلفاز/ويب',
    'sports_title' => 'المرافق الرياضية',
    'tents_label' => 'خيام',
    'virtual_tour_label' => 'جولة افتراضية',
    'virtual_tour_subtitle' => 'اكتشف دور الشباب عبر جولة افتراضية 360°',
    'youtube_video' => 'فيديو YouTube',

    // investment / projects
    'investment' => 'الاستثمار',
    'breadcrumb_investment' => 'الاستثمار',
    'projects_subtitle' => 'بعث المشاريع',
    'welcome_hello' => 'مرحباً، :name',
    'projects_overview' => 'أنشطة ومشاريع تحت إشراف الوزارة',
    'project_salle_title' => 'إحداث قاعة خاصة للرياضة',
    'project_salle_desc' => 'إنشاء وإدارة قاعة رياضية خاصة',
    'project_spaces_title' => 'الفضاءات الترفيهية للشباب والطفولة',
    'project_spaces_desc' => 'إدارة وتنظيم الأنشطة الترفيهية',
    'project_private_institutions_title' => 'المؤسسات الشبابية الخاصة',
    'project_private_institutions_desc' => 'إدارة وتطوير المؤسسات الشبابية',
    'project_events_title' => 'تنظيم الأنشطة الترفيهية للشباب والطفولة',
    'project_events_desc' => 'تخطيط وتنفيذ البرامج الترفيهية',
    'project_training_center_title' => 'مركز التربصات وتكوين الرياضيين',
    'project_training_center_desc' => 'تدريب وتطوير المهارات الرياضية',
    'project_tax_exemption_title' => 'مشاريع الإعفاء الجبائي',
    'project_tax_exemption_desc' => 'إدارة وتنظيم الإعفاءات الضريبية',
    'action_view_edit' => 'عرض وتعديل',
    'action_discover_more' => 'اكتشف المزيد',
    'action_view_details' => 'عرض التفاصيل',

    // salles list / table
    'breadcrumb_salles_list' => 'قائمة القاعات الرياضية',
    'section_subtitle_requests' => 'طلبات قاعات الرياضة',
    'section_title_all_requests' => 'عرض جميع الطلبات',
    'btn_add_request' => 'إضافة طلب',
    'no_salles_requests' => 'لا توجد طلبات قاعات الرياضة.',
    'table_id' => 'المعرف',
    'table_deposit_date' => 'تاريخ الإيداع',
    'table_applicant' => 'إسم مقدم الطلب',
    'table_status' => 'وضعية الطلب',
    'table_actions' => 'إجراءات',
    'table_start_activity' => 'بداية النشاط',
    'table_tax_exemption' => 'إعفاء جبائي',
    'btn_view' => 'عرض',
    'btn_edit' => 'تعديل',
    'btn_delete' => 'حذف',

    'status_pending' => 'في الانتظار',
    'status_accepted' => 'مقبول',
    'status_refused' => 'مرفوض',
    'status_unknown' => 'غير معروف',

    'start_activity_notify' => 'إعلام ببداية النشاط',
    'start_activity_edit' => 'تعديل الطلب',
    'start_activity_view' => 'اطلاع على الطلب',

    'exoneration_add' => 'إضافة إعفاء جبائي',
    'exoneration_edit' => 'تعديل الطلب',
    'exoneration_view' => 'اطلاع على الطلب',

    // nested investment translations (form labels, components, placeholders, validation)
    'investment' => [
        'breadcrumb' => [
            'home' => 'الرئيسية',
            'index' => 'الاستثمار',
            'salles_list' => 'قائمة القاعات الرياضية',
            'add_salle' => 'إضافة قاعة رياضية',
        ],
        'detail' => 'تفاصيل القاعة الرياضية',
        'form_title_salle' => 'استمارة إيداع كراس الشروط لإحداث قاعة خاصة للرياضة',
        'view_request' => 'اطلاع على المطلب',
        'form' => [
            'title' => 'نموذج',
            'identity' => [
                'title' => 'هوية الباعث',
            ],
            'property' => [
                'title' => 'هوية العقار',
            ],
            'label' => [
                'full_name' => 'الاسم و اللقب أو الاسم التجاري',
                'email' => 'البريد الإلكتروني',
                'identity_type' => 'نوع الهوية',
                'cin' => 'رقم بطاقة التعريف',
                'passport' => 'رقم جواز السفر',
                'fiscal_id' => 'رقم المعرف الجبائي',
                'cin_issue_date' => 'تاريخ الإصدار',
                'cin_issue_place' => 'مكان الإصدار',
                'phone' => 'رقم الهاتف الشخصي',
                'address' => 'العنوان الشخصي',
                'property_address' => 'عنوان العقار',
                'gouvernorat' => 'الولاية',
                'delegation' => 'البلدية',
                'property_type' => 'صيغة العقار',
                'surface_total' => 'المساحة الجملية للعقار (م²)',
                'usage_type' => 'صيغة استغلال العقار',
                'document_property' => 'نسخة العقد/الملكية',
                'other_surfaces' => 'مساحات اخرى',
                'count' => 'عدد',
                'surface' => 'مساحة',
            ],
            'placeholder' => [
                'choose' => 'اختر...',
                'loading' => 'تحميل...',
                'cin' => 'أدخل رقم بطاقة التعريف',
                'passport' => 'أدخل رقم جواز السفر',
                'fiscal' => 'أدخل رقم المعرف الجبائي',
                'cin_issue_place' => 'أدخل مكان الإصدار',
                'count' => 'عدد',
                'surface' => 'مساحة (م²)',
            ],
            'validation' => [
                'property_address_max' => 'يجب ألا يتجاوز عنوان العقار 100 حرفاً.',
                'surface_min' => 'المساحة يجب أن تكون على الأقل 100 م².',
                'surface_hint' => 'المساحة يجب أن تكون 100م² على الأقل.',
            ],
            'button' => [
                'submit' => 'إرسال',
            ],
            'components' => [
                'title' => 'مكونات العقار',
                'exercise_hall' => 'قاعة التمارين',
                'pool' => 'حوض مائي',
                'changing_rooms' => 'حجرات ملابس',
                'sanitary_units' => 'وحدات صحية',
                'storage_space' => 'فضاء للخزن والمعدات',
                'outdoor_space' => 'فضاء خارجي',
                'garage' => 'مأوى سيارات',
            ],
        ],
    ],

    // generic yes/no used in template
    'yes' => 'نعم',
    'no' => 'لا',
    'yes_no' => 'نعم / لا',
    'component' => 'المكوّن',

    // print / files
    'print' => 'طباعة',
    'view_file' => 'عرض الملف',
    'not_specified' => '-',

    // exoneration
    'exoneration' => [
        'form_title' => 'إستمارة تسجيل الإنتفاع بإعفاء جبائي',
        'identity' => [
            'title' => 'هوية صاحب المشروع',
        ],
        'project_name_label' => 'عنوان المشروع',
        'project_place_label' => 'مكان المشروع',
        'documents' => [
            'title' => 'إضافة الوثائق المطلوبة',
            '1' => ['label' => '1- نسخة من كراس الشروط', 'desc' => 'مؤشر عليها في جميع صفحاتها من قبل الباعث و مصحوبة بنسخة من وصل الإيداع أو ختم المندوبية الجهوية للشباب والرياضة.'],
            '2' => ['label' => '2- الأصل من شهادة إيداع التصريح', 'desc' => 'مسلمة من قبل مصالح وكالة النهوض بالصناعة وتحدد التجهيزات المقرر اقتناؤها فعلياً.'],
            '3' => ['label' => '3- فاتورة', 'desc' => 'فاتورة نهائية بالعربية أو الفرنسية تحتوي على قائمة التجهيزات موضوع طلب الامتياز الجبائي.'],
            '4' => ['label' => '4- عقد بين المشتري والمورد', 'desc' => 'يحتوي على المواصفات، الكمية، الثمن والعلامة التجارية موقعة من الطرفين.'],
            '5' => ['label' => '5- وثيقة الإعلام بالوصول', 'desc' => 'تسلم من قبل الناقل.'],
            '6' => ['label' => '6- وثيقة الشحن', 'desc' => 'وثيقة الشحن الخاصة بالسلعة.'],
            '7' => ['label' => '7- نسخة من بطاقة التعريف الجبائي', 'desc' => 'نسخة من بطاقة التعريف الجبائي للمؤسسة.'],
            '8' => ['label' => '8- نسخة من مضمون السجل الوطني للمؤسسات', 'desc' => 'نسخة من مضمون السجل الوطني للمؤسسات.'],
            '9' => ['label' => '9- نسخة من شهادة الملكية', 'desc' => 'أو عقد بيع/هبة/كراء ساري ومسجل بالقباضة المالية.'],
            '10' => ['label' => '10- تعهد', 'desc' => 'تعهد موقع بعدم التفويت في التجهيزات لمدة 5 سنوات مع ذكر التجهيزات.'],
            '11' => ['label' => '11- مثال هندسي للمشروع', 'desc' => 'مثال هندسي يوضّح تركيز التجهيزات مرفق بختم وموقّع من مهندس.'],
        ],
    ],

    // start_activity (documents & labels)
    'start_activity' => [
        'form_number_label' => 'رقم الاستمارة:',
        'form_title' => 'استمارة الاعلام ببداية النشاط',
        'current_status' => 'الوضعية الحالية:',
        'status' => [
            'accepted' => 'مقبول',
            'rejected' => 'مرفوض',
            'pending' => 'في الانتظار',
        ],
        'rejection_reason_label' => 'سبب الرفض:',
        'owner_identity_title' => 'هوية الباعث',
        'owner_identity_number' => 'رقم الهوية',
        'start_date_label' => 'تاريخ بداية النشاط',
        'start_date_hint' => 'تاريخ بداية النشاط يجب ان يكون بعد 15 يوما من تاريخ استلام وصل التسجيل.',
        'attached_documents' => 'الوثائق المرفقة',
        'documents' => [
            'preuve_propriete_location' => [
                'label' => 'نسخة من شهادة الملكية أو عقد الكراء',
                'desc'  => 'نسخة من شهادة الملكية أو عقد الكراء صالحة ومسجلة.',
            ],
            'plan_architectural' => [
                'label' => 'مخطط معماري',
                'desc'  => 'مخطط معماري للمكان يبين التوزيع والتجهيزات.',
            ],
            'declaration_investissement' => [
                'label' => 'شهادة تصريح بالاستثمار',
                'desc'  => 'شهادة تصدر عن المصالح المختصة تبين طبيعة الاستثمار.',
            ],
            'identification' => [
                'label' => 'بطاقة تعريف / جواز',
                'desc'  => 'نسخة من بطاقة التعريف الوطنية أو جواز السفر.',
            ],
            'extrait_registre_national_entreprise' => [
                'label' => 'السجل الوطني للمؤسسات',
                'desc'  => 'استخراج من السجل الوطني للمؤسسات إن وجد.',
            ],
            'certificat_prevention' => [
                'label' => 'شهادة الوقاية',
                'desc'  => 'شهادة مطابقة لمعايير الوقاية والصحة والسلامة إن وجدت.',
            ],
            'contrat_assurance' => [
                'label' => 'عقد التأمين',
                'desc'  => 'نسخة من عقد التأمين للمكان أو النشاط.',
            ],
            'approbation_autorite_minicipale' => [
                'label' => 'اعتماد السلطة المحلية',
                'desc'  => 'موافقة أو اعتماد من السلطات المحلية عند الاقتضاء.',
            ],
        ],
        'rejection_reason_label' => 'سبب الرفض:',
    ],

    // header
    'header' => [
        'regional_delegation' => 'المندوبية الجهوية للشباب و الرياضة',
    ],
    'current_status_label'=>'الوضعية الحالية',

// add/merge these into returned array
'table_project_nature' => 'طبيعة المشروع',
'no_forms' => 'لا توجد استمارات',
'confirm_edit_title' => 'هل تريد تعديل هذه الاستمارة؟',
'confirm_delete_title' => 'هل تريد حذف هذه الاستمارة؟',
'confirm_yes' => 'نعم',
'confirm_cancel' => 'إلغاء',
'close' => 'إغلاق',

// -- new/merged keys for this view (Arabic)
'page_show_form' => 'عرض الاستمارة',
'place_of_birth' => 'مكان الولادة',
'date_of_birth' => 'تاريخ الولادة',
'personal_address' => 'العنوان الشخصي',
'education_level' => 'المستوى التعليمي',
'last_degree' => 'آخر شهادة متحصل عليها',
'experience_label' => 'الاقدمية في تعاطي النشاط',
'project_characteristics' => 'خصائص المشروع الترفيهي',
'characteristics_placeholder' => 'خصوصياتها',
'espace_spectacle_label' => 'فضاءات ترفيهية والهواء الطلق والعروض',
'espace_sportif_label' => 'فضاءات ترفيهية رياضية',
'espace_service_label' => 'فضاء الأنشطة الخدماتية',
'espace_culturel_label' => 'فضاء الأنشطة الثقافية والفنية والعلمية',
'select_project_nature' => 'الرجاء اختيار طبيعة المشروع',
'number_positions_title' => 'عدد مواطن الشغل المؤملة',
'holders_degree_label' => 'من حاملي الشهادات العلمية',
'others_label' => 'آخرين',
'director_title' => 'مدير المؤسسة',
'investment_finance_title' => 'بيانات عن الاستثمار والتمويل',
'investment_label' => 'الاستثمار',
'amount_label' => 'المبلغ',
'fund_sources_label' => 'مصادر التمويل',
'notes_label' => 'الملاحظات',
'funds_examples' => '(*) أموال ذاتية، قروض طويلة المدى، قروض متوسطة المدى، قروض قصيرة المدى، منح، مواد أخرى.',
'declaration_title' => 'تصريح على الشرف',
'declaration_text' => 'إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.',
'remarks_title' => 'ملاحظات المندوبية الجهوية',
'write_remarks_placeholder' => 'اكتب ملاحظاتك هنا...',

 'project_spaces_title' => 'الفضاءات الترفيهية للشباب و الطفولة',
    'add_form_title' => 'إضافة استمارة',

    // form sections & labels
    'form_section_investor' => 'المستثمر',
    'label_full_name' => 'الاسم و اللقب',
    'label_birth_place' => 'مكان الولادة',
    'label_birth_date' => 'تاريخ الولادة',
    'label_identity' => 'الهوية الشخصية',
    'label_issue_date' => 'تاريخ الإصدار',
    'label_issue_place' => 'مكان الإصدار',
    'label_address' => 'العنوان الشخصي',
    'label_education_level' => 'المستوى التعليمي',
    'label_last_degree' => 'آخر شهادة متحصل عليها',
    'label_experience' => 'الخبرة / الأقدمية في تعاطي النشاط',

    // features
    'features_title' => 'خصائص المشروع الترفيهي',
    'espace_spectacle' => 'فضاءات ترفيهية و الهواء الطلق و العروض',
    'espace_sportif' => 'فضاءات ترفيهية رياضية',
    'espace_service' => 'فضاء الأنشطة الخدماتية',
    'espace_culturel' => 'فضاء الأنشطة الثقافية و الفنية و العلمية',
    'caracteristique_placeholder' => 'خصوصياتها',

    // project nature
    'project_nature_title' => 'طبيعة المشروع',
    'choose_nature' => 'الرجاء اختيار طبيعة المشروع',
    'choose_placeholder' => 'اختر...',

    // number of places
    'number_places_expected' => 'عدد مواطن الشغل المؤملة',
    'nbr_diplome_universitaire_label' => 'من حاملي الشهادات العلمية',
    'nbr_diplome_universitaire_placeholder' => 'من حاملي الشهادات العلمية',
    'nbr_autre_label' => 'آخرين',
    'nbr_autre_placeholder' => 'آخرين',

    // manager
    'section_manager_title' => 'مدير المؤسسة',
    'label_director_name' => 'الاسم و اللقب',
    'label_director_cin' => 'رقم بطاقة التعريف الوطنية',

    // investment table
    'investment_financing_title' => 'بيانات عن الاستثمار و التمويل',
    'investment_table_invest' => 'الإستثمار',
    'investment_table_amount' => 'المبلغ',
    'investment_table_sources' => 'مصادر التمويل',
    'investment_table_remarks' => 'الملاحظات',
    'add_row' => 'إضافة صف',
    'delete' => 'حذف',
    'financing_hint' => '(*) أمول ذاتية، قروض طويلة المدى، قروض متوسطة المدى، قروض قصيرة المدى، منح، مواد أخرى.',

    // declaration & remarks
    'declaration_title' => 'تصريح على الشرف',
    'declaration_text' => 'إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.',
    'remarks_title' => 'ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :',
    'remarks_placeholder' => 'اكتب ملاحظاتك هنا...',

    // form actions
    'form_submit' => 'إرسال',
];
