<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserRolesTable extends Migration
{
    public function up()
    {
        
        Schema::create('user_roles', function (Blueprint $table) {
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('roles_id');

            $table->primary(['user_id', 'roles_id']);

            $table->foreign('user_id')
                ->references('id')->on('utilisateur')
                ->onDelete('cascade');

            $table->foreign('roles_id')
                ->references('id_roles')->on('roles')
                ->onDelete('cascade');
        });








    }

    public function down()
    {
        Schema::dropIfExists('user_roles');
    }
}
