<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRolesPermissionsTable extends Migration
{
    public function up()
    {
        Schema::create('roles_permissions', function (Blueprint $table) {
            $table->unsignedBigInteger('roles_id');
            $table->unsignedBigInteger('perm_id');

            $table->primary(['roles_id', 'perm_id']); 

            $table->foreign('roles_id')
                  ->references('id_roles')->on('roles')
                  ->onDelete('cascade');

            $table->foreign('perm_id')
                  ->references('id_perm')->on('permissions')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('roles_permissions');
    }
}
