<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sections', function (Blueprint $table) {
            $table->id('id_S');
            $table->string('titre_S', 100);
            $table->integer('ordre_S');
            $table->string('contenue_S', 255)->nullable();
            $table->unsignedBigInteger('id_P');
            $table->timestamps();

            $table->foreign('id_P')
                  ->references('id_P')
                  ->on('pages')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sections');
    }
};
