<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('utilisateur', function (Blueprint $table) {
            $table->id(); 
            $table->string('nom_prenom', 100);
            $table->string('cin', 8)->unique();
            $table->date('date_delivrance_cin');
            $table->string('lieu_delivrance_cin', 100);
            $table->string('passport', 12)->unique();
            $table->string('num_fiscal', 12)->unique();
            $table->string('email', 100)->unique();
            $table->string('mdp', 100); 
            $table->string('remember_token', 100)->nullable();
            $table->string('image', 255)->nullable();
            $table->string('tel', 12)->nullable();
            $table->string('adresse', 100)->nullable();
            $table->boolean('est_active')->default(true);
            
            $table->timestamps(); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('utilisateur');
    }
};
