<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('auberge_mode_acces', function (Blueprint $table) {
            $table->unsignedBigInteger('id_auberge');
            $table->unsignedBigInteger('id_type');

            $table->primary(['id_auberge', 'id_type']);

            $table->foreign('id_auberge')
                  ->references('id')
                  ->on('auberge')
                  ->onDelete('cascade');

            $table->foreign('id_type')
                  ->references('id_type')
                  ->on('tp_mode_acces_auberge')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('auberge_mode_acces');
    }
};
