<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('auberge', function (Blueprint $table) {
            $table->id();
            $table->string('nom', 100);
            $table->string('description', 255)->nullable();
            $table->string('adresse', 255);
            $table->string('contact_tel', 12);
            $table->string('contact_email', 100);
            $table->integer('capacite_chambre')->nullable();
            $table->integer('capacite_tente')->nullable();
            $table->string('service_restauration', 255)->nullable();
            $table->string('service_disponibles', 255)->nullable();
            $table->boolean('accueil_personnes_handicapees')->default(false);
            $table->string('activites', 255)->nullable();

            $table->unsignedBigInteger('type_id');
            $table->unsignedBigInteger('gouver_id');
            $table->unsignedBigInteger('delegation_id');

            $table->foreign('type_id')->references('id_type')->on('tp_type_auberge')->onDelete('cascade');
            $table->foreign('gouver_id')->references('id_gouver')->on('tp_gouvernorat')->onDelete('cascade');
            $table->foreign('delegation_id')->references('id_delegation')->on('tp_delegation')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('auberge');
    }
};
