<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\Type;
use App\Models\Guide;

class ViewServiceProvider extends ServiceProvider
{
    public function boot()
    {
        View::composer('*', function ($view) {
            $types = Type::with('guides.children')
                        ->orderBy('id_type')
                        ->get();

            $guidesPrincipaux = Guide::with(['children' => function ($q) {
                    $q->orderBy('ordre');
                }])
                ->where('type', 'menu_principal')
                ->whereNull('id_parent')
                ->orderBy('ordre')
                ->get();

            $view->with([
                'types' => $types,
                'guidesPrincipaux' => $guidesPrincipaux,
            ]);
        });
    }
}
